/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.ExecuteUpdate;
import net.ucanaccess.jdbc.NormalizedSQL;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.IThrowingRunnable;
import net.ucanaccess.util.IThrowingSupplier;
import net.ucanaccess.util.Try;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCStatement;

public class UcanaccessStatement
implements Statement {
    private UcanaccessConnection connection;
    protected Statement wrapped;
    private Object generatedKey;
    private Map<String, String> aliases;
    private boolean enableDisable;

    protected Map<String, String> getAliases() {
        return this.aliases;
    }

    protected void setAliases(Map<String, String> _aliases) {
        this.aliases = _aliases;
    }

    public UcanaccessStatement(Statement _wrapped, UcanaccessConnection _conn) {
        this.wrapped = _wrapped;
        this.connection = _conn;
    }

    private String convertSql(String _sql, UcanaccessConnection _conn) {
        if (SQLConverter.checkDDL(_sql)) {
            return _sql;
        }
        NormalizedSQL nsql = SQLConverter.convertSQL(_sql, _conn);
        this.aliases = nsql.getAliases();
        return this.preprocess(nsql.getSql());
    }

    private String convertSql(String _sql) {
        if (SQLConverter.checkDDL(_sql)) {
            return _sql;
        }
        NormalizedSQL nsql = SQLConverter.convertSQL(_sql);
        this.aliases = nsql.getAliases();
        return this.preprocess(nsql.getSql());
    }

    private String preprocess(String _sql) {
        return this.connection.preprocess(_sql);
    }

    @Override
    public void addBatch(String _batch) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.addBatch(SQLConverter.convertSQL(_batch).getSql()));
    }

    @Override
    public void cancel() throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(this.wrapped::cancel);
    }

    @Override
    public void clearBatch() throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(this.wrapped::clearBatch);
    }

    @Override
    public void clearWarnings() throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(this.wrapped::clearWarnings);
    }

    @Override
    public void close() throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(this.wrapped::close);
    }

    @Override
    public void closeOnCompletion() throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> {
            if (this.wrapped instanceof JDBCStatement) {
                ((JDBCStatement)this.wrapped).closeOnCompletion();
            } else if (this.wrapped instanceof JDBCPreparedStatement) {
                ((JDBCPreparedStatement)this.wrapped).closeOnCompletion();
            } else if (this.wrapped instanceof UcanaccessStatement) {
                UcanaccessStatement stat = (UcanaccessStatement)this.wrapped;
                stat.closeOnCompletion();
            } else {
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.CLOSE_ON_COMPLETION_STATEMENT);
            }
        });
    }

    protected void checkLastModified() throws UcanaccessSQLException {
        block5: {
            block4: {
                if (this.connection.getAutoCommit()) break block4;
                if (!this.connection.isCheckModified()) break block5;
            }
            Connection hsqldb = UcanaccessStatement.tryCatch(this.wrapped::getConnection);
            this.connection.checkLastModified();
            if (hsqldb != this.connection.getHSQLDBConnection()) {
                this.reset();
            }
        }
    }

    @Override
    public boolean execute(String _sql) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new Execute(this, this.convertSql(_sql, this.connection)).execute();
        });
    }

    @Override
    public boolean execute(String _sql, int _autoGeneratedKeys) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new Execute(this, this.convertSql(_sql, this.connection), _autoGeneratedKeys).execute();
        });
    }

    @Override
    public boolean execute(String _sql, int[] _indexes) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new Execute(this, this.convertSql(_sql, this.connection), _indexes).execute();
        });
    }

    @Override
    public boolean execute(String _sql, String[] _columnNames) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new Execute(this, _sql, _columnNames).execute();
        });
    }

    @Override
    public int[] executeBatch() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            return new ExecuteUpdate(this).executeBatch();
        });
    }

    @Override
    public ResultSet executeQuery(String _sql) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new UcanaccessResultSet(this.wrapped.executeQuery(this.convertSql(_sql, this.connection)), this);
        });
    }

    @Override
    public int executeUpdate(String _sql) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new ExecuteUpdate(this, this.convertSql(_sql)).execute();
        });
    }

    @Override
    public int executeUpdate(String _sql, int _autoGeneratedKeys) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new ExecuteUpdate(this, this.convertSql(_sql), _autoGeneratedKeys).execute();
        });
    }

    @Override
    public int executeUpdate(String _sql, int[] _indexes) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new ExecuteUpdate(this, this.convertSql(_sql), _indexes).execute();
        });
    }

    @Override
    public int executeUpdate(String _sql, String[] _columnNames) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            return new ExecuteUpdate(this, this.convertSql(_sql), _columnNames).execute();
        });
    }

    @Override
    public UcanaccessConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getFetchDirection);
    }

    @Override
    public int getFetchSize() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getFetchSize);
    }

    @Override
    public ResultSet getGeneratedKeys() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            this.checkLastModified();
            StringBuilder sb = new StringBuilder();
            if (this.generatedKey != null) {
                sb.append(" SELECT ").append(this.generatedKey instanceof String ? "'" + String.valueOf(this.generatedKey) + "'" : this.generatedKey).append(" AS GENERATED_KEY ").append(" FROM DUAL");
            } else {
                sb.append(" SELECT 0 ").append("AS GENERATED_KEY ").append("FROM DUAL WHERE 1=2");
            }
            Connection conn = this.connection.getHSQLDBConnection();
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(sb.toString());
            return new UcanaccessResultSet(rs, this);
        });
    }

    @Override
    public int getMaxFieldSize() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getMaxFieldSize);
    }

    @Override
    public int getMaxRows() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getMaxRows);
    }

    @Override
    public boolean getMoreResults() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> this.wrapped.getMoreResults());
    }

    @Override
    public boolean getMoreResults(int _current) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> this.wrapped.getMoreResults(_current));
    }

    @Override
    public int getQueryTimeout() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getQueryTimeout);
    }

    @Override
    public ResultSet getResultSet() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            ResultSet rs = this.wrapped.getResultSet();
            return this.wrapped == null || rs == null ? null : new UcanaccessResultSet(rs, this);
        });
    }

    @Override
    public int getResultSetConcurrency() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getResultSetConcurrency);
    }

    @Override
    public int getResultSetHoldability() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getResultSetHoldability);
    }

    @Override
    public int getResultSetType() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getResultSetType);
    }

    @Override
    public int getUpdateCount() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> {
            int i = this.wrapped.getUpdateCount();
            return i == -1 && this.enableDisable ? 0 : i;
        });
    }

    @Override
    public SQLWarning getWarnings() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::getWarnings);
    }

    Statement getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isClosed() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::isClosed);
    }

    @Override
    public boolean isCloseOnCompletion() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::isCloseOnCompletion);
    }

    @Override
    public boolean isPoolable() throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(this.wrapped::isPoolable);
    }

    @Override
    public boolean isWrapperFor(Class<?> _iface) throws UcanaccessSQLException {
        return UcanaccessStatement.tryCatch(() -> this.wrapped.isWrapperFor(_iface));
    }

    @Override
    public void setCursorName(String _name) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setCursorName(_name));
    }

    @Override
    public void setEscapeProcessing(boolean _enable) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setEscapeProcessing(_enable));
    }

    @Override
    public void setFetchDirection(int _direction) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setFetchDirection(_direction));
    }

    @Override
    public void setFetchSize(int _rows) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setFetchSize(_rows));
    }

    @Override
    public void setMaxFieldSize(int _max) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setMaxFieldSize(_max));
    }

    @Override
    public void setMaxRows(int _max) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setMaxRows(_max));
    }

    @Override
    public void setPoolable(boolean _poolable) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setPoolable(_poolable));
    }

    @Override
    public void setQueryTimeout(int _seconds) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> this.wrapped.setQueryTimeout(_seconds));
    }

    @Override
    public <T> T unwrap(Class<T> _iface) throws UcanaccessSQLException {
        return (T)UcanaccessStatement.tryCatch(() -> this.wrapped.unwrap(_iface));
    }

    protected void reset() throws UcanaccessSQLException {
        Statement old = this.wrapped;
        Statement stat = UcanaccessStatement.tryCatch(() -> this.getConnection().getHSQLDBConnection().createStatement(this.wrapped.getResultSetType(), this.wrapped.getResultSetConcurrency(), this.wrapped.getResultSetHoldability()));
        this.reset(stat);
        UcanaccessStatement.tryCatch(old::close);
    }

    protected void reset(Statement _st) throws UcanaccessSQLException {
        UcanaccessStatement.tryCatch(() -> {
            int maxRows = this.wrapped.getMaxRows();
            int maxFldSz = this.wrapped.getMaxFieldSize();
            int fetchDir = this.wrapped.getFetchDirection();
            int fetchSz = this.wrapped.getFetchSize();
            int qryTimeout = this.wrapped.getQueryTimeout();
            this.wrapped = _st;
            this.wrapped.setMaxRows(maxRows);
            this.wrapped.setMaxFieldSize(maxFldSz);
            this.wrapped.setFetchDirection(fetchDir);
            this.wrapped.setFetchSize(fetchSz);
            this.wrapped.setQueryTimeout(qryTimeout);
        });
    }

    public void setGeneratedKey(Object key) {
        this.generatedKey = key;
    }

    boolean isEnableDisable() {
        return this.enableDisable;
    }

    void setEnableDisable(boolean _enableDisable) {
        this.enableDisable = _enableDisable;
    }

    protected static final <T extends Throwable> void tryCatch(IThrowingRunnable<T> _catchable) throws UcanaccessSQLException {
        Try.catching(_catchable).orThrow(UcanaccessSQLException::wrap);
    }

    protected static final <R, T extends Throwable> R tryCatch(IThrowingSupplier<R, T> _catchable) throws UcanaccessSQLException {
        return Try.catching(_catchable).orThrow(UcanaccessSQLException::wrap);
    }
}

