/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.query.QueryFormat;
import com.healthmarketscience.jackcess.impl.query.QueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.converters.DFunction;
import net.ucanaccess.converters.Functions;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.ParametricQuery;
import net.ucanaccess.converters.Pivot;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.converters.UcanaccessTable;
import net.ucanaccess.ext.FunctionType;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.log.Logger;
import net.ucanaccess.log.LoggerMessageEnum;
import net.ucanaccess.type.ObjectType;
import net.ucanaccess.util.Try;

public class LoadJet {
    private static final AtomicInteger NAMING_COUNTER = new AtomicInteger(0);
    private final Connection conn;
    private final Database dbIO;
    private boolean err;
    private final FunctionsLoader functionsLoader = new FunctionsLoader();
    private final List<String> loadedIndexes = new ArrayList<String>();
    private final List<String> loadedQueries = new ArrayList<String>();
    private final List<String> loadedProcedures = new ArrayList<String>();
    private final List<String> loadedTables = new ArrayList<String>();
    private final LogsFlusher logsFlusher = new LogsFlusher();
    private final TablesLoader tablesLoader = new TablesLoader();
    private final TriggersLoader triggersGenerator = new TriggersLoader();
    private final ViewsLoader viewsLoader = new ViewsLoader();
    private boolean sysSchema;
    private boolean ff1997;
    private boolean skipIndexes;
    private final Metadata metadata;

    public LoadJet(Connection _conn, Database _dbIo) {
        this.conn = _conn;
        this.dbIO = _dbIo;
        try {
            this.ff1997 = Database.FileFormat.V1997.equals((Object)this.dbIO.getFileFormat());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.metadata = new Metadata(_conn);
    }

    public void loadDefaultValues(Table _t) throws SQLException, IOException {
        this.tablesLoader.setDefaultValues(_t);
    }

    public void loadDefaultValues(Column _cl) throws SQLException, IOException {
        this.tablesLoader.setDefaultValue(_cl);
    }

    public String defaultValue4SQL(Column _cl) throws IOException {
        PropertyMap pm = _cl.getProperties();
        Object defaulT = pm.getValue("DefaultValue");
        if (defaulT == null) {
            return null;
        }
        return this.tablesLoader.defaultValue4SQL(defaulT, _cl.getType());
    }

    private static boolean hasAutoNumberColumn(Table t) {
        List cols = t.getColumns();
        for (Column col : cols) {
            if (!col.isAutoNumber() && !DataType.BOOLEAN.equals((Object)col.getType())) continue;
            return true;
        }
        return false;
    }

    public void addFunctions(Class<?> _clazz) throws SQLException {
        this.functionsLoader.addFunctions(_clazz, false);
    }

    private void exec(String _expression, boolean _logging) throws SQLException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement st = this.conn.createStatement();){
                st.executeUpdate(_expression);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException _ex) {
            if (_logging && _ex.getErrorCode() != -5528) {
                Logger.log("Cannot execute:" + _expression + " " + _ex.getMessage());
            }
            throw _ex;
        }
    }

    private String escapeIdentifier(String tn) throws SQLException {
        return SQLConverter.escapeIdentifier(tn, this.conn);
    }

    public SQLWarning getLoadingWarnings() {
        Object message;
        if (this.viewsLoader.notLoaded.isEmpty() && this.tablesLoader.unresolvedTables.isEmpty()) {
            return null;
        }
        SQLWarning sqlw = null;
        for (String s : this.viewsLoader.notLoaded.keySet()) {
            Object object = message = s.length() > 0 ? "Cannot load view " + s + " " + this.viewsLoader.notLoaded.get(s) : "Cannot load views ";
            if (sqlw == null) {
                sqlw = new SQLWarning((String)message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning((String)message));
        }
        for (String s : this.viewsLoader.notLoadedProcedure.keySet()) {
            Object object = message = s.length() > 0 ? "Cannot load procedure " + s + " " + this.viewsLoader.notLoadedProcedure.get(s) : "Cannot load procedures ";
            if (sqlw == null) {
                sqlw = new SQLWarning((String)message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning((String)message));
        }
        for (String s : this.tablesLoader.unresolvedTables) {
            message = "Cannot resolve table " + s;
            if (sqlw == null) {
                sqlw = new SQLWarning((String)message);
                continue;
            }
            sqlw.setNextWarning(new SQLWarning((String)message));
        }
        return sqlw;
    }

    public void resetFunctionsDefault() {
        this.functionsLoader.resetDefault();
    }

    public void loadDB() throws SQLException, IOException {
        try {
            this.functionsLoader.loadMappedFunctions();
            this.tablesLoader.loadTables();
            this.viewsLoader.loadViews();
            this.conn.commit();
            SQLConverter.cleanEscaped();
        }
        finally {
            Logger.log("Loaded Tables:");
            this.logsFlusher.dumpList(this.loadedTables);
            Logger.log("Loaded Queries:");
            this.logsFlusher.dumpList(this.loadedQueries);
            Logger.log("Loaded Procedures:");
            this.logsFlusher.dumpList(this.loadedProcedures);
            Logger.log("Loaded Indexes:");
            this.logsFlusher.dumpList(this.loadedIndexes, true);
            this.conn.close();
        }
    }

    public void synchronisationTriggers(String tableName, boolean hasAutoNumberColumn, boolean hasAppendOnly) throws SQLException {
        this.triggersGenerator.synchronisationTriggers(tableName, hasAutoNumberColumn, hasAppendOnly);
    }

    public Object tryDefault(Object _default) {
        Statement st;
        block13: {
            Object object;
            block14: {
                Throwable throwable = null;
                Object var3_5 = null;
                st = this.conn.createStatement();
                try {
                    ResultSet rs = st.executeQuery("SELECT " + String.valueOf(_default) + " FROM DUAL");
                    if (!rs.next()) break block13;
                    object = rs.getObject(1);
                    if (st == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (st != null) {
                                st.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception _ex) {
                        return null;
                    }
                }
                st.close();
            }
            return object;
        }
        if (st != null) {
            st.close();
        }
        return null;
    }

    public void setSysSchema(boolean _sysSchema) {
        this.sysSchema = _sysSchema;
    }

    public void setSkipIndexes(boolean _skipIndexes) {
        this.skipIndexes = _skipIndexes;
    }

    static /* synthetic */ void access$0(LoadJet loadJet, String string, boolean bl) throws SQLException {
        loadJet.exec(string, bl);
    }

    private final class FunctionsLoader {
        private final Set<String> functionDefinitions = new LinkedHashSet<String>();

        private FunctionsLoader() {
        }

        private void addAggregates() {
            Stream.of(this.getAggregate("last", "LONGVARCHAR"), this.getAggregate("last", "DECIMAL(100,10)"), this.getAggregate("last", "BOOLEAN"), this.getAggregate("first", "LONGVARCHAR"), this.getAggregate("first", "DECIMAL(100,10)"), this.getAggregate("first", "BOOLEAN"), this.getLastTimestamp(), this.getFirstTimestamp()).forEach(this.functionDefinitions::add);
        }

        private String getLastTimestamp() {
            return "CREATE AGGREGATE FUNCTION last(IN val TIMESTAMP, IN flag boolean, INOUT ts TIMESTAMP, INOUT counter INT) RETURNS TIMESTAMP CONTAINS SQL BEGIN ATOMIC IF flag THEN RETURN ts; ELSE IF counter IS NULL THEN SET counter = 0; END IF; SET counter = counter + 1; SET ts = val; RETURN NULL; END IF; END";
        }

        private String getFirstTimestamp() {
            return "CREATE AGGREGATE FUNCTION First(IN val TIMESTAMP, IN flag boolean, INOUT ts TIMESTAMP , INOUT counter INT) RETURNS TIMESTAMP CONTAINS SQL BEGIN ATOMIC IF flag THEN RETURN ts; ELSE IF counter IS NULL THEN SET counter = 0; END IF; SET counter = counter + 1;  IF counter = 1 THEN SET ts = val; END IF; RETURN NULL; END IF; END ";
        }

        private void addFunction(String _functionName, String _javaMethodName, String _returnType, String ... _paramTypes) {
            StringBuilder code = new StringBuilder();
            if (DBReference.is2xx()) {
                String parms = IntStream.rangeClosed(1, _paramTypes.length).mapToObj(i -> "par" + i + " " + _paramTypes[i - 1]).collect(Collectors.joining(", "));
                code.append("CREATE FUNCTION ").append(_functionName).append("(").append(parms).append(")").append(" RETURNS ").append(_returnType).append(" LANGUAGE JAVA DETERMINISTIC NO SQL EXTERNAL NAME ").append("'CLASSPATH:").append(_javaMethodName).append("'");
            } else {
                code.append("CREATE ALIAS ").append(_functionName).append(" FOR \"").append(_javaMethodName).append("\"");
            }
            this.functionDefinitions.add(code.toString());
        }

        private void addFunctions(Class<?> _clazz, boolean _cswitch) {
            Map<String, String> tmap = TypesMap.getAccess2HsqlTypesMap();
            Method[] methodArray = _clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                List functionTypes = Stream.of(method.getAnnotations()).filter(ant -> ant.annotationType().equals(FunctionType.class)).map(FunctionType.class::cast).collect(Collectors.toList());
                for (FunctionType func : functionTypes) {
                    String methodName = _clazz.getName() + "." + method.getName();
                    Object functionName = (String)((Object)Objects.requireNonNullElse(func.functionName(), methodName));
                    TypesMap.AccessType[] acts = func.argumentTypes();
                    TypesMap.AccessType ret = func.returnType();
                    String retTypeName = ret.name();
                    Object returnType = tmap.getOrDefault(retTypeName, retTypeName);
                    if (TypesMap.AccessType.TEXT.equals((Object)ret)) {
                        returnType = (String)returnType + "(255)";
                    }
                    String[] args = new String[acts.length];
                    int i = 0;
                    while (i < args.length) {
                        String typeName = acts[i].name();
                        args[i] = tmap.getOrDefault(typeName, typeName);
                        if (TypesMap.AccessType.TEXT.equals((Object)acts[i])) {
                            int n3 = i;
                            args[n3] = String.valueOf(args[n3]) + "(255)";
                        }
                        ++i;
                    }
                    if (func.namingConflict()) {
                        SQLConverter.addWAFunctionName((String)functionName);
                        functionName = (String)functionName + "WA";
                    }
                    this.addFunction((String)functionName, methodName, (String)returnType, args);
                }
                ++n2;
            }
            this.createFunctions();
            if (_cswitch) {
                this.createSwitch();
            }
        }

        private void resetDefault() {
            Method[] mths;
            Class<Functions> clazz = Functions.class;
            Method[] methodArray = mths = clazz.getDeclaredMethods();
            int n = mths.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] ants;
                Method mth = methodArray[n2];
                Annotation[] annotationArray = ants = mth.getAnnotations();
                int n3 = ants.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation ant = annotationArray[n4];
                    if (ant.annotationType().equals(FunctionType.class)) {
                        FunctionType ft = (FunctionType)ant;
                        String functionName = ft.functionName();
                        if (ft.namingConflict()) {
                            SQLConverter.addWAFunctionName(functionName);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        private void createFunctions() {
            for (String functionDef : this.functionDefinitions) {
                Try.catching(() -> LoadJet.this.exec(functionDef, true)).orElse(e -> Logger.logWarning(LoggerMessageEnum.FAILED_TO_CREATE_FUNCTION, functionDef, e.toString()));
            }
            this.functionDefinitions.clear();
        }

        private void createSwitch() {
            List<DataType> dtypes = List.of(DataType.BINARY, DataType.BOOLEAN, DataType.SHORT_DATE_TIME, DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.MONEY, DataType.NUMERIC, DataType.COMPLEX_TYPE, DataType.MEMO);
            for (DataType dtype : dtypes) {
                String type = " " + TypesMap.map2hsqldb(dtype) + " ";
                int i = 1;
                while (i < 10) {
                    StringBuilder header = new StringBuilder("CREATE FUNCTION SWITCH(  ");
                    StringBuilder body = new StringBuilder("(CASE ");
                    String comma = "";
                    int j = 0;
                    while (j < i) {
                        body.append("  WHEN B").append(j).append(" THEN V").append(j);
                        header.append(comma).append("B").append(j).append(" BOOLEAN ,").append("V").append(j).append(type);
                        comma = ",";
                        ++j;
                    }
                    body.append(" END)");
                    header.append(") RETURNS").append(type).append(" RETURN").append((CharSequence)body);
                    Try.catching(() -> LoadJet.this.exec(header.toString(), true)).orElse(e -> Logger.logWarning(LoggerMessageEnum.FAILED_TO_CREATE_FUNCTION, header.toString(), e.toString()));
                    ++i;
                }
            }
        }

        private String getAggregate(String _functionName, String _type) {
            return "CREATE AGGREGATE FUNCTION " + _functionName + "(IN val " + _type + ", IN flag BOOLEAN, INOUT register " + _type + ", INOUT counter INT) RETURNS " + _type + " NO SQL LANGUAGE JAVA EXTERNAL NAME 'CLASSPATH:net.ucanaccess.converters.FunctionsAggregate." + _functionName + "'";
        }

        private void loadMappedFunctions() throws SQLException {
            this.addFunctions(Functions.class, true);
            this.addAggregates();
            this.createFunctions();
        }
    }

    private static final class LogsFlusher {
        private LogsFlusher() {
        }

        private void dumpList(List<String> logs) {
            this.dumpList(logs, false);
        }

        private void dumpList(List<String> logs, boolean cr) {
            String comma = "";
            StringBuilder sb = new StringBuilder();
            String crs = cr ? System.lineSeparator() : "";
            for (String log : logs) {
                sb.append(comma).append(log).append(crs);
                comma = ", ";
            }
            Logger.log(sb.toString());
            logs.clear();
        }
    }

    private final class TablesLoader {
        private static final int HSQL_FK_ALREADY_EXISTS = -5528;
        private static final int HSQL_UK_ALREADY_EXISTS = -5522;
        private static final int HSQL_NOT_NULL = -10;
        private static final int HSQL_FK_VIOLATION = -177;
        private static final int HSQL_UK_VIOLATION = -104;
        private static final String SYSTEM_SCHEMA = "SYS";
        private static final int DEFAULT_STEP = 2000;
        private final List<String> unresolvedTables = new ArrayList<String>();
        private final List<String> calculatedFieldsTriggers = new ArrayList<String>();
        private final List<String> loadingOrder = new LinkedList<String>();
        private final Set<Column> alreadyIndexed = new LinkedHashSet<Column>();
        private final Set<String> readOnlyTables = new LinkedHashSet<String>();

        private TablesLoader() {
        }

        private String commaSeparated(List<? extends Index.Column> columns, boolean escape) throws SQLException {
            String comma = "";
            StringBuilder sb = new StringBuilder(" (");
            for (Index.Column column : columns) {
                String cl = escape ? LoadJet.this.escapeIdentifier(column.getColumn().getName()) : column.getColumn().getName();
                sb.append(comma).append(cl);
                comma = ",";
            }
            return sb.append(") ").toString();
        }

        private String schema(String name, boolean systemTable) {
            if (systemTable) {
                return "SYS." + name;
            }
            return name;
        }

        private DataType getReturnType(Column _col) throws IOException {
            if (_col.getProperties().get("Expression") == null || _col.getProperties().get("ResultType") == null) {
                return null;
            }
            byte pos = (Byte)_col.getProperties().get("ResultType").getValue();
            return DataType.fromByte((byte)pos);
        }

        private String getHsqldbColumnType(Column _col) throws IOException {
            Object htype;
            DataType dtyp = _col.getType();
            DataType rtyp = this.getReturnType(_col);
            boolean calcType = false;
            if (rtyp != null) {
                dtyp = rtyp;
                calcType = true;
            }
            if (dtyp.equals((Object)DataType.TEXT)) {
                short ln = LoadJet.this.ff1997 ? _col.getLength() : _col.getLengthInUnits();
                htype = "VARCHAR(" + ln + ")";
            } else if (dtyp.equals((Object)DataType.NUMERIC) && (_col.getScale() > 0 || calcType)) {
                htype = calcType ? "NUMERIC(100 ,4)" : "NUMERIC(" + (_col.getPrecision() > 0 ? (byte)_col.getPrecision() : (byte)100) + "," + _col.getScale() + ")";
            } else if (dtyp.equals((Object)DataType.FLOAT)) {
                if (calcType) {
                    htype = "NUMERIC(" + (_col.getPrecision() > 0 ? (byte)_col.getPrecision() : (byte)100) + ",7)";
                } else {
                    Object dps = null;
                    PropertyMap.Property dpso = _col.getProperties().get("DecimalPlaces");
                    if (dpso != null) {
                        dps = _col.getProperties().get("DecimalPlaces").getValue();
                    }
                    byte dp = dps == null ? (byte)7 : ((Byte)dps < 0 ? (byte)7 : (byte)((Byte)dps));
                    htype = "NUMERIC(" + (_col.getPrecision() > 0 ? (byte)_col.getPrecision() : (byte)100) + "," + dp + ")";
                }
            } else {
                htype = TypesMap.map2hsqldb(dtyp);
            }
            return htype;
        }

        private String getCalculatedFieldTrigger(String _ntn, Column _col, boolean _isCreate) throws IOException, SQLException {
            DataType dt = this.getReturnType(_col);
            String fun = null;
            if (this.isNumeric(dt)) {
                fun = "formulaToNumeric";
            } else if (this.isBoolean(dt)) {
                fun = "formulaToBoolean";
            } else if (this.isDate(dt)) {
                fun = "formulaToDate";
            } else if (this.isTextual(dt)) {
                fun = "formulaToText";
            }
            String call = fun == null ? "%s" : fun + "(%s,'" + dt.name() + "')";
            String ecl = this.procedureEscapingIdentifier(_col.getName()).replace("%", "%%");
            return _isCreate ? "CREATE TRIGGER expr%d before insert ON " + _ntn + " REFERENCING NEW AS newrow FOR EACH ROW  BEGIN  ATOMIC  SET newrow." + ecl + " = " + call + "; END " : "CREATE TRIGGER expr%d before update ON " + _ntn + " REFERENCING NEW  AS newrow OLD AS OLDROW FOR EACH ROW BEGIN ATOMIC IF %s THEN  SET newrow." + ecl + " = " + call + "; ELSEIF newrow." + ecl + " <> oldrow." + ecl + " THEN SIGNAL SQLSTATE '45000' SET MESSAGE_TEXT = '" + Logger.getMessage(LoggerMessageEnum.TRIGGER_UPDATE_CF_ERR, new Object[0]) + _col.getName().replace("%", "%%") + "';  END IF ; END ";
        }

        private boolean isNumeric(DataType dt) {
            return this.typeGroup(dt, DataType.NUMERIC, DataType.MONEY, DataType.DOUBLE, DataType.FLOAT, DataType.LONG, DataType.INT, DataType.BYTE);
        }

        private boolean isDate(DataType dt) {
            return this.typeGroup(dt, DataType.SHORT_DATE_TIME);
        }

        private boolean isBoolean(DataType dt) {
            return this.typeGroup(dt, DataType.BOOLEAN);
        }

        private boolean isTextual(DataType dt) {
            return this.typeGroup(dt, DataType.MEMO, DataType.TEXT);
        }

        private boolean typeGroup(DataType dt, DataType ... gr) {
            DataType[] dataTypeArray = gr;
            int n = gr.length;
            int n2 = 0;
            while (n2 < n) {
                DataType el = dataTypeArray[n2];
                if (el.equals((Object)dt)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void createSyncrTable(Table t, boolean systemTable) throws SQLException, IOException {
            this.createSyncrTable(t, systemTable, true);
        }

        private void createSyncrTable(Table _t, boolean _systemTable, boolean _constraints) throws SQLException, IOException {
            String tn = _t.getName();
            if ("DUAL".equalsIgnoreCase(tn)) {
                SQLConverter.setDualUsedAsTableName(true);
            }
            StringBuilder check = new StringBuilder();
            String ntn = SQLConverter.preEscapingIdentifier(tn);
            int seq = LoadJet.this.metadata.newTable(tn, ntn, ObjectType.TABLE);
            ntn = SQLConverter.completeEscaping(ntn);
            ntn = SQLConverter.checkLang(ntn, LoadJet.this.conn);
            ntn = this.schema(ntn, _systemTable);
            StringBuilder sbC = new StringBuilder("CREATE CACHED TABLE ").append(ntn).append("(");
            String comma = "";
            for (Column col : _t.getColumns()) {
                String expr;
                if ("USER".equalsIgnoreCase(col.getName())) {
                    Logger.logWarning(LoggerMessageEnum.USER_AS_COLUMNNAME, _t.getName());
                }
                if ((expr = this.getExpression(col)) != null && _constraints) {
                    String tgrI = this.getCalculatedFieldTrigger(ntn, col, true);
                    String tgrU = this.getCalculatedFieldTrigger(ntn, col, false);
                    this.calculatedFieldsTriggers.add(String.format(tgrI, NAMING_COUNTER.getAndIncrement(), SQLConverter.convertFormula(expr)));
                    String uc = this.getUpdateConditions(col);
                    if (uc.length() > 0) {
                        this.calculatedFieldsTriggers.add(String.format(tgrU, NAMING_COUNTER.getAndIncrement(), uc, SQLConverter.convertFormula(expr)));
                    }
                }
                String cn = SQLConverter.preEscapingIdentifier(col.getName());
                String colType = col.getType().name();
                if (col.isAutoNumber()) {
                    ColumnImpl cli = (ColumnImpl)col;
                    ColumnImpl.AutoNumberGenerator ang = cli.getAutoNumberGenerator();
                    if (ang.getType().equals((Object)DataType.LONG)) {
                        colType = "COUNTER";
                    }
                } else if (col.isHyperlink()) {
                    colType = "HYPERLINK";
                }
                LoadJet.this.metadata.newColumn(col.getName(), cn, colType, seq);
                if (expr != null && _constraints) {
                    LoadJet.this.metadata.calculatedField(_t.getName(), col.getName());
                }
                cn = SQLConverter.completeEscaping(cn);
                cn = SQLConverter.checkLang(cn, LoadJet.this.conn);
                sbC.append(comma).append(cn).append(" ").append(this.getHsqldbColumnType(col));
                if (DataType.FLOAT.equals((Object)col.getType())) {
                    check.append(", check (3.4028235E+38>=").append(cn).append(" AND -3.4028235E+38<=").append(cn).append(")");
                }
                PropertyMap pm = col.getProperties();
                Object required = pm.getValue("Required");
                if (_constraints && required instanceof Boolean && ((Boolean)required).booleanValue()) {
                    sbC.append(" NOT NULL ");
                }
                comma = ",";
            }
            sbC.append((CharSequence)check).append(")");
            LoadJet.this.exec(sbC.toString(), true);
        }

        private String getExpression(Column _col) throws IOException {
            PropertyMap map = _col.getProperties();
            PropertyMap.Property exprp = map.get("Expression");
            if (exprp != null) {
                Table tl = _col.getTable();
                String expr = SQLConverter.convertPowOperator((String)exprp.getValue());
                for (Column col : tl.getColumns()) {
                    expr = expr.replaceAll("\\[(?i)(" + Pattern.quote(col.getName()) + ")\\]", "newrow.$0");
                }
                return expr;
            }
            return null;
        }

        private String getUpdateConditions(Column _col) throws IOException, SQLException {
            Set<String> setu;
            PropertyMap map = _col.getProperties();
            PropertyMap.Property exprp = map.get("Expression");
            if (exprp != null && !(setu = SQLConverter.getFormulaDependencies(exprp.getValue().toString())).isEmpty()) {
                String or = "";
                StringBuilder cw = new StringBuilder();
                for (String dep : setu) {
                    dep = LoadJet.this.escapeIdentifier(dep);
                    cw.append(or).append("oldrow.").append(dep).append("<>").append("newrow.").append(dep);
                    or = " OR ";
                }
                return cw.toString();
            }
            return " FALSE ";
        }

        private String procedureEscapingIdentifier(String name) throws SQLException {
            return SQLConverter.procedureEscapingIdentifier(LoadJet.this.escapeIdentifier(name));
        }

        private void setDefaultValue(Column _col) throws SQLException, IOException {
            String tn = _col.getTable().getName();
            String ntn = LoadJet.this.escapeIdentifier(tn);
            ArrayList<String> arTrigger = new ArrayList<String>();
            this.setDefaultValue(_col, ntn, arTrigger);
            for (String trigger : arTrigger) {
                LoadJet.this.exec(trigger, true);
            }
        }

        private String defaultValue4SQL(Object defaulT, DataType dt) {
            if (defaulT == null) {
                return null;
            }
            Object default4SQL = SQLConverter.convertSQL(" " + String.valueOf(defaulT)).getSql();
            if (((String)default4SQL).trim().startsWith("=")) {
                default4SQL = ((String)default4SQL).trim().substring(1);
            }
            if (dt.equals((Object)DataType.BOOLEAN) && ("=yes".equalsIgnoreCase((String)default4SQL) || "yes".equalsIgnoreCase((String)default4SQL))) {
                default4SQL = "true";
            }
            if (dt.equals((Object)DataType.BOOLEAN) && ("=no".equalsIgnoreCase((String)default4SQL) || "no".equalsIgnoreCase((String)default4SQL))) {
                default4SQL = "false";
            }
            if (!(!dt.equals((Object)DataType.MEMO) && !dt.equals((Object)DataType.TEXT) || defaulT.toString().startsWith("\"") && defaulT.toString().endsWith("\""))) {
                default4SQL = "'" + ((String)default4SQL).replace("'", "''") + "'";
            }
            return default4SQL;
        }

        private void setDefaultValue(Column _col, String _ntn, List<String> _arTrigger) throws IOException, SQLException {
            PropertyMap pm = _col.getProperties();
            String ncn = this.procedureEscapingIdentifier(_col.getName());
            Object defaulT = pm.getValue("DefaultValue");
            if (defaulT != null) {
                String default4SQL = this.defaultValue4SQL(defaulT, _col.getType());
                String guidExp = "GenGUID()";
                if (!guidExp.equals(defaulT)) {
                    boolean defaultIsFunction;
                    boolean bl = defaultIsFunction = defaulT.toString().trim().endsWith(")") && defaulT.toString().indexOf(40) > 0;
                    if (defaultIsFunction) {
                        LoadJet.this.metadata.columnDef(_col.getTable().getName(), _col.getName(), defaulT.toString());
                    }
                    Object defFound = default4SQL;
                    boolean isNull = default4SQL.equalsIgnoreCase("null");
                    if (!isNull && (defFound = LoadJet.this.tryDefault(default4SQL)) == null) {
                        Logger.logWarning(LoggerMessageEnum.UNKNOWN_EXPRESSION, String.valueOf(defaulT), _col.getName(), _col.getTable().getName());
                    } else {
                        if (defFound != null && !defaultIsFunction) {
                            LoadJet.this.metadata.columnDef(_col.getTable().getName(), _col.getName(), defFound.toString());
                        }
                        if (_col.getType() == DataType.TEXT && defaulT.toString().startsWith("'") && defaulT.toString().endsWith("'") && defaulT.toString().length() > _col.getLengthInUnits()) {
                            Logger.logWarning(LoggerMessageEnum.DEFAULT_VALUES_DELIMETERS, String.valueOf(defaulT), _col.getName(), _col.getTable().getName(), "" + _col.getLengthInUnits());
                        }
                        _arTrigger.add("CREATE TRIGGER DEFAULT_TRIGGER" + NAMING_COUNTER.getAndIncrement() + " BEFORE INSERT ON " + _ntn + "  REFERENCING NEW ROW AS NEW FOR EACH ROW IF NEW." + ncn + " IS NULL THEN SET NEW." + ncn + "= " + default4SQL + " ; END IF");
                    }
                }
            }
        }

        private void setDefaultValues(Table t) throws SQLException, IOException {
            String tn = t.getName();
            String ntn = LoadJet.this.escapeIdentifier(tn);
            ArrayList<String> arTrigger = new ArrayList<String>();
            for (Column col : t.getColumns()) {
                this.setDefaultValue(col, ntn, arTrigger);
            }
            for (String trigger : arTrigger) {
                LoadJet.this.exec(trigger, true);
            }
        }

        private int countFKs() throws IOException {
            int i = 0;
            for (String tn : this.loadingOrder) {
                UcanaccessTable table = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                if (this.unresolvedTables.contains(tn)) continue;
                for (Index index : table.getIndexes()) {
                    IndexImpl idx = (IndexImpl)index;
                    if (!idx.isForeignKey() || idx.getReference().isPrimaryTable()) continue;
                    ++i;
                }
            }
            return i;
        }

        private boolean reorder() throws IOException {
            int maxIteration = this.countFKs() + 1;
            int i = 0;
            while (i < maxIteration) {
                boolean change = false;
                ArrayList<String> loadingOrder0 = new ArrayList<String>(this.loadingOrder);
                for (String tn : loadingOrder0) {
                    UcanaccessTable table = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                    if (this.unresolvedTables.contains(tn)) continue;
                    for (Index index : table.getIndexes()) {
                        IndexImpl idx = (IndexImpl)index;
                        if (!idx.isForeignKey() || idx.getReference().isPrimaryTable() || this.tryReorder((Index)idx)) continue;
                        change = true;
                    }
                }
                if (!change) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean tryReorder(Index idxi) throws IOException {
            int irt;
            IndexImpl idx = (IndexImpl)idxi;
            String ctn = idx.getTable().getName();
            String rtn = idx.getReferencedIndex().getTable().getName();
            int ict = this.loadingOrder.indexOf(ctn);
            if (ict < (irt = this.loadingOrder.indexOf(rtn))) {
                this.loadingOrder.remove(ctn);
                this.loadingOrder.add(irt, ctn);
                return false;
            }
            return true;
        }

        private void loadForeignKey(Index idxi, String ctn) throws IOException, SQLException {
            String ntn;
            IndexImpl idx = (IndexImpl)idxi;
            String rtn = idx.getReferencedIndex().getTable().getName();
            List cls = idx.getColumns();
            if (cls.size() == 1) {
                this.alreadyIndexed.add((Column)((IndexData.ColumnDescriptor)cls.get(0)).getColumn());
            }
            if ((ntn = LoadJet.this.escapeIdentifier(ctn)) == null) {
                return;
            }
            String nin = LoadJet.this.escapeIdentifier(ctn + "_" + idx.getName());
            String colsIdx = this.commaSeparated(cls, true);
            String colsIdxRef = this.commaSeparated(idx.getReferencedIndex().getColumns(), true);
            StringBuilder ci = new StringBuilder("ALTER TABLE ").append(ntn).append(" ADD CONSTRAINT ").append(nin);
            String nrt = LoadJet.this.escapeIdentifier(rtn);
            if (nrt == null) {
                return;
            }
            ci.append(" FOREIGN KEY ").append(colsIdx).append(" REFERENCES ").append(nrt).append(colsIdxRef);
            if (idx.getReference().isCascadeDeletes()) {
                ci.append(" ON DELETE CASCADE ");
            }
            if (idx.getReference().isCascadeUpdates()) {
                ci.append(" ON UPDATE CASCADE ");
            }
            try {
                LoadJet.this.exec(ci.toString(), true);
            }
            catch (SQLException _ex) {
                if (_ex.getErrorCode() == -5528) {
                    Logger.log(_ex.getMessage());
                }
                throw _ex;
            }
            LoadJet.this.loadedIndexes.add("FK on " + ntn + " Columns:" + this.commaSeparated(cls, false) + " References " + nrt + " Columns:" + this.commaSeparated(idx.getReferencedIndex().getColumns(), false));
        }

        /*
         * Unable to fully structure code
         */
        private void loadIndex(Index idx, String tn) throws SQLException {
            block12: {
                ntn = LoadJet.this.escapeIdentifier(tn);
                if (ntn == null) {
                    return;
                }
                nin = idx.getName();
                nin = LoadJet.this.escapeIdentifier(tn + "_" + nin);
                uk = idx.isUnique();
                pk = idx.isPrimaryKey();
                if (!uk && !pk && idx.getColumns().size() == 1 && this.alreadyIndexed.contains(col = ((Index.Column)idx.getColumns().get(0)).getColumn())) {
                    return;
                }
                if (uk && idx.getColumns().size() == 1 && (dt = (col = ((Index.Column)idx.getColumns().get(0)).getColumn()).getType()).equals((Object)DataType.COMPLEX_TYPE)) {
                    return;
                }
                ci = new StringBuilder("ALTER TABLE ").append(ntn);
                colsIdx = this.commaSeparated(idx.getColumns(), true);
                if (pk) {
                    ci.append(" ADD PRIMARY KEY ").append(colsIdx);
                } else if (uk) {
                    ci.append(" ADD CONSTRAINT ").append(nin).append(" UNIQUE ").append(colsIdx);
                } else {
                    ci = new StringBuilder("CREATE INDEX ").append(nin).append(" ON ").append(ntn).append(colsIdx);
                }
                try {
                    LoadJet.this.exec(ci.toString(), true);
                }
                catch (SQLException _ex) {
                    if (-5522 == _ex.getErrorCode()) {
                        return;
                    }
                    if (!idx.isUnique()) break block12;
                    ** for (cd : idx.getColumns())
                }
lbl-1000:
                // 1 sources

                {
                    if (!cd.getColumn().getType().equals((Object)DataType.COMPLEX_TYPE)) continue;
                    return;
                }
            }
            Logger.logWarning(_ex.getMessage());
            return;
            catch (Exception _ex) {
                Logger.logWarning(_ex.getMessage());
                return;
            }
            pre = pk != false ? "Primary Key " : (uk != false ? "Index Unique " : "Index");
            LoadJet.this.loadedIndexes.add(pre + " on " + tn + " Columns:" + this.commaSeparated(idx.getColumns(), false));
        }

        private void createTable(Table t) throws SQLException, IOException {
            this.createTable(t, false);
        }

        private void dropTable(Table t, boolean systemTable) throws SQLException {
            String tn = t.getName();
            String ntn = this.schema(LoadJet.this.escapeIdentifier(tn), systemTable);
            LoadJet.this.exec("DROP TABLE " + ntn + " CASCADE ", false);
            LoadJet.this.metadata.dropTable(tn);
        }

        private void makeTableReadOnly(Table t, boolean systemTable) throws SQLException {
            String tn = t.getName();
            this.readOnlyTables.add(t.getName());
            String ntn = this.schema(LoadJet.this.escapeIdentifier(tn), systemTable);
            LoadJet.this.exec("SET TABLE " + ntn + " READONLY TRUE ", false);
            LoadJet.this.loadedTables.add(tn + " READONLY");
        }

        private void recreate(Table _t, boolean _systemTable, Row _record, int _errorCode) throws SQLException, IOException {
            String type = "";
            switch (_errorCode) {
                case -177: {
                    type = "Foreign Key";
                    break;
                }
                case -10: {
                    type = "Not Null";
                    break;
                }
                case -104: {
                    type = "Unique";
                    break;
                }
            }
            Logger.logWarning(LoggerMessageEnum.CONSTRAINT, type, _t.getName(), _record.toString(), _t.getName());
            this.dropTable(_t, _systemTable);
            this.createSyncrTable(_t, _systemTable, false);
            if (_errorCode != -177) {
                this.loadTableFKs(_t.getName(), false);
            }
            this.loadTableData(_t, _systemTable);
            this.makeTableReadOnly(_t, _systemTable);
        }

        private void createTable(Table t, boolean systemTable) throws SQLException, IOException {
            String ntn;
            String tn = t.getName();
            if (tn.indexOf(32) > 0) {
                SQLConverter.addWhiteSpacedTableNames(tn);
            }
            if ((ntn = SQLConverter.escapeIdentifier(tn)) == null) {
                return;
            }
            this.createSyncrTable(t, systemTable);
        }

        private boolean hasAppendOnly(Table t) {
            for (Column c : t.getColumns()) {
                if (!c.isAppendOnly()) continue;
                return true;
            }
            return false;
        }

        private void loadTableData(Table t, boolean systemTable) throws IOException, SQLException {
            this.loadTableData(t, systemTable, false);
        }

        private void loadTableData(Table _t, boolean _systemTable, boolean _errorCheck) throws IOException, SQLException {
            TimeZone prevJackcessTimeZone = _t.getDatabase().getTimeZone();
            _t.getDatabase().setTimeZone(TimeZone.getTimeZone("UTC"));
            int step = _errorCheck ? 1 : 2000;
            int i = 0;
            try (Statement ps = null;){
                Iterator it = _t.iterator();
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    if (row == null) continue;
                    ArrayList<Object> values = new ArrayList<Object>();
                    if (ps == null) {
                        ps = this.sqlInsert(_t, (Map<String, Object>)row, _systemTable);
                    }
                    for (Map.Entry entry : row.entrySet()) {
                        values.add(this.value(entry.getValue(), _t, (String)entry.getKey(), row));
                    }
                    LoadJet.this.tablesLoader.execInsert((PreparedStatement)ps, values);
                    if (_errorCheck || i > 0 && i % step == 0 || !it.hasNext()) {
                        try {
                            ps.executeBatch();
                        }
                        catch (SQLException _ex) {
                            int ec = _ex.getErrorCode();
                            if (!_errorCheck && ec == -10) {
                                this.dropTable(_t, _systemTable);
                                this.createSyncrTable(_t, _systemTable, true);
                                this.loadTableData(_t, _systemTable, true);
                            }
                            if (ec == -10 || ec == -177 || ec == -104) {
                                if (ec == -177) {
                                    Logger.logWarning(_ex.getMessage());
                                }
                                this.recreate(_t, _systemTable, row, _ex.getErrorCode());
                            }
                            throw _ex;
                        }
                        if (_errorCheck) {
                            LoadJet.this.conn.rollback();
                        } else {
                            LoadJet.this.conn.commit();
                        }
                    }
                    ++i;
                }
                if (i != _t.getRowCount() && step != 1) {
                    Logger.logWarning(LoggerMessageEnum.ROW_COUNT, _t.getName(), String.valueOf(_t.getRowCount()), String.valueOf(i));
                }
            }
            _t.getDatabase().setTimeZone(prevJackcessTimeZone);
        }

        private void loadTableFKs(String tn, boolean autoref) throws IOException, SQLException {
            if (this.readOnlyTables.contains(tn)) {
                return;
            }
            Table t = LoadJet.this.dbIO.getTable(tn);
            UcanaccessTable table = new UcanaccessTable(t, tn);
            if (t != null) {
                for (Index index : table.getIndexes()) {
                    IndexImpl idx = (IndexImpl)index;
                    if (!idx.isForeignKey() || idx.getReference().isPrimaryTable()) continue;
                    boolean isAuto = idx.getTable().getName().equals(idx.getReferencedIndex().getTable().getName());
                    if ((!autoref || !isAuto) && (autoref || isAuto)) continue;
                    this.loadForeignKey((Index)idx, tn);
                }
            }
        }

        private void createCalculatedFieldsTriggers() {
            this.calculatedFieldsTriggers.forEach(t -> Try.catching(() -> LoadJet.this.exec((String)t, false)).orElse(e -> Logger.logWarning(e.getMessage())));
        }

        private void loadTableIndexesUK(String tn) throws IOException, SQLException {
            Table t = LoadJet.this.dbIO.getTable(tn);
            UcanaccessTable table = new UcanaccessTable(t, tn);
            if (t != null) {
                for (Index index : table.getIndexes()) {
                    if (index.isForeignKey() || !index.isPrimaryKey() && !index.isUnique()) continue;
                    this.loadIndex(index, tn);
                }
            }
        }

        private void loadTableIndexesNotUK(String tn) throws IOException, SQLException {
            Table t = LoadJet.this.dbIO.getTable(tn);
            UcanaccessTable table = new UcanaccessTable(t, tn);
            if (!LoadJet.this.skipIndexes && t != null) {
                for (Index index : table.getIndexes()) {
                    if (index.isForeignKey() || index.isPrimaryKey() || index.isUnique()) continue;
                    this.loadIndex(index, tn);
                }
            }
        }

        private void createTables() throws SQLException, IOException {
            LoadJet.this.metadata.createMetadata();
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                UcanaccessTable t = null;
                Table t2 = null;
                try {
                    t2 = LoadJet.this.dbIO.getTable(tn);
                    t = new UcanaccessTable(t2, tn);
                }
                catch (Exception _ex) {
                    Logger.logWarning(_ex.getMessage());
                    this.unresolvedTables.add(tn);
                }
                if (t2 == null || t == null || tn.startsWith("~")) continue;
                this.createTable(t);
                this.loadingOrder.add(t.getName());
            }
        }

        private void createIndexesUK() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableIndexesUK(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void createIndexesNotUK() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableIndexesNotUK(tn);
                LoadJet.this.conn.commit();
            }
        }

        private void createFKs() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                this.loadTableFKs(tn, false);
                LoadJet.this.conn.commit();
            }
        }

        private void createAutoFKs() throws SQLException, IOException {
            for (String tn : LoadJet.this.dbIO.getTableNames()) {
                if (this.unresolvedTables.contains(tn)) continue;
                try {
                    this.loadTableFKs(tn, true);
                }
                catch (SQLException _ex) {
                    UcanaccessTable t = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                    this.makeTableReadOnly(t, false);
                }
                LoadJet.this.conn.commit();
            }
        }

        private void loadTablesData() throws SQLException, IOException {
            for (String tn : this.loadingOrder) {
                if (this.unresolvedTables.contains(tn)) continue;
                UcanaccessTable t = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                this.loadTableData(t, false);
                LoadJet.this.conn.commit();
            }
        }

        private void createTriggers() throws IOException, SQLException {
            for (String tn : this.loadingOrder) {
                if (this.unresolvedTables.contains(tn) || this.readOnlyTables.contains(tn)) continue;
                UcanaccessTable t = new UcanaccessTable(LoadJet.this.dbIO.getTable(tn), tn);
                this.createSyncrTriggers(t);
            }
            this.createCalculatedFieldsTriggers();
        }

        private void createSystemTables() throws SQLException, IOException {
            if (LoadJet.this.sysSchema) {
                this.createSystemSchema();
                for (String tn : LoadJet.this.dbIO.getSystemTableNames()) {
                    UcanaccessTable t = null;
                    try {
                        t = new UcanaccessTable(LoadJet.this.dbIO.getSystemTable(tn), tn);
                        if (t == null) continue;
                        this.createTable(t, true);
                        this.loadTableData(t, true);
                        LoadJet.this.exec("SET TABLE " + this.schema(SQLConverter.escapeIdentifier(t.getName()), true) + " READONLY TRUE ", false);
                        LoadJet.this.exec("GRANT SELECT  ON " + this.schema(SQLConverter.escapeIdentifier(t.getName()), true) + " TO PUBLIC ", false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void loadTables() throws SQLException, IOException {
            this.createTables();
            this.createIndexesUK();
            boolean reorder = this.reorder();
            if (reorder) {
                this.createFKs();
            }
            this.createIndexesNotUK();
            this.loadTablesData();
            this.createTriggers();
            if (!reorder) {
                this.createFKs();
            }
            this.createAutoFKs();
            this.createSystemTables();
        }

        private void createSystemSchema() throws SQLException {
            LoadJet.this.exec("CREATE SCHEMA SYS AUTHORIZATION DBA", false);
        }

        private void createSyncrTriggers(Table t) throws SQLException, IOException {
            this.setDefaultValues(t);
            String ntn = LoadJet.this.escapeIdentifier(t.getName());
            LoadJet.this.triggersGenerator.synchronisationTriggers(ntn, LoadJet.hasAutoNumberColumn(t), this.hasAppendOnly(t));
            LoadJet.this.loadedTables.add(t.getName());
        }

        private PreparedStatement sqlInsert(Table t, Map<String, Object> row, boolean systemTable) throws SQLException {
            String tn = t.getName();
            String ntn = this.schema(LoadJet.this.escapeIdentifier(tn), systemTable);
            String comma = "";
            StringBuilder sbI = new StringBuilder(" INSERT INTO ").append(ntn).append(" (");
            StringBuilder sbE = new StringBuilder(" VALUES( ");
            Set<String> se = row.keySet();
            comma = "";
            for (String cn : se) {
                sbI.append(comma).append(LoadJet.this.escapeIdentifier(cn));
                sbE.append(comma).append(" ? ");
                comma = ",";
            }
            sbI.append(") ");
            sbE.append(")");
            sbI.append((CharSequence)sbE);
            return LoadJet.this.conn.prepareStatement(sbI.toString());
        }

        private Object value(Object value, Table table, String columnName, Row row) throws SQLException {
            if (value == null) {
                return null;
            }
            if (value instanceof Float) {
                if (value.equals(Float.valueOf(Float.NaN))) {
                    return value;
                }
                return new BigDecimal(value.toString());
            }
            if (value instanceof Date && !(value instanceof Timestamp)) {
                return LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.of("UTC"));
            }
            if (value instanceof ComplexValueForeignKey) {
                try {
                    return ComplexBase.convert((ComplexValueForeignKey)value);
                }
                catch (IOException _ex) {
                    throw new UcanaccessSQLException(_ex);
                }
            }
            if (value instanceof byte[] && BlobKey.hasPrimaryKey(table)) {
                BlobKey bk = new BlobKey(table, columnName, row);
                return bk.getBytes();
            }
            if (value instanceof Byte) {
                return SQLConverter.asUnsigned((Byte)value);
            }
            return value;
        }

        private void execInsert(PreparedStatement st, List<Object> values) throws SQLException {
            int i = 1;
            for (Object value : values) {
                st.setObject(i++, value);
            }
            st.addBatch();
        }
    }

    private final class TriggersLoader {
        private static final String DEFAULT_TRIGGERS_PACKAGE = "net.ucanaccess.triggers";

        private TriggersLoader() {
        }

        void loadTrigger(String tableName, String namePrefix, String when, String className) throws SQLException {
            String q0 = DBReference.is2xx() ? "" : " QUEUE 0  ";
            Object triggerName = namePrefix + "_" + tableName;
            triggerName = LoadJet.this.escapeIdentifier((String)triggerName);
            LoadJet.this.exec("CREATE TRIGGER " + (String)triggerName + "  " + when + " ON " + tableName + " FOR EACH ROW " + q0 + " CALL \"" + className + "\" ", true);
        }

        void loadTriggerNP(String tableName, String namePrefix, String when, String className) throws SQLException {
            this.loadTrigger(tableName, namePrefix, when, "net.ucanaccess.triggers." + className);
        }

        void synchronisationTriggers(String tableName, boolean hasAutoNumberColumn, boolean hasAutoAppendOnly) throws SQLException {
            this.loadTriggerNP(tableName, "genericInsert", "AFTER INSERT", "TriggerInsert");
            this.loadTriggerNP(tableName, "genericUpdate", "AFTER UPDATE", "TriggerUpdate");
            this.loadTriggerNP(tableName, "genericDelete", "AFTER DELETE", "TriggerDelete");
            if (hasAutoAppendOnly) {
                this.loadTriggerNP(tableName, "appendOnly", "BEFORE INSERT", "TriggerAppendOnly");
                this.loadTriggerNP(tableName, "appendOnly_upd", "BEFORE UPDATE", "TriggerAppendOnly");
            }
            if (hasAutoNumberColumn) {
                this.loadTriggerNP(tableName, "autonumber", "BEFORE INSERT", "TriggerAutoNumber");
                this.loadTriggerNP(tableName, "autonumber_validate", "BEFORE UPDATE", "TriggerAutoNumber");
            }
        }
    }

    private final class ViewsLoader {
        private static final int OBJECT_ALREADY_EXISTS = -5504;
        private static final int OBJECT_NOT_FOUND = -5501;
        private static final int UNEXPECTED_TOKEN = -5581;
        private Map<String, String> notLoaded = new HashMap<String, String>();
        private Map<String, String> notLoadedProcedure = new HashMap<String, String>();

        private ViewsLoader() {
        }

        private boolean loadView(Query _q) throws SQLException {
            return this.loadView(_q, null);
        }

        private void registerQueryColumns(Query _q, int _seq) throws SQLException {
            QueryImpl qi = (QueryImpl)_q;
            for (QueryImpl.Row row : qi.getRows()) {
                if (!QueryFormat.COLUMN_ATTRIBUTE.equals(row.attribute)) continue;
                String name = row.name1;
                if (name == null) {
                    String table;
                    List<String> result;
                    int beginIndex = Math.max(row.expression.lastIndexOf(91), row.expression.lastIndexOf(46));
                    if (beginIndex < 0 || beginIndex == row.expression.length() - 1 || row.expression.endsWith(")")) continue;
                    name = row.expression.substring(beginIndex + 1);
                    if (name.endsWith("]")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if (name.contentEquals("*") && (result = LoadJet.this.metadata.getColumnNames(table = row.expression.substring(0, beginIndex))) != null) {
                        for (String column : result) {
                            LoadJet.this.metadata.newColumn(column, SQLConverter.preEscapingIdentifier(column), null, _seq);
                        }
                    }
                }
                LoadJet.this.metadata.newColumn(name, SQLConverter.preEscapingIdentifier(name), null, _seq);
            }
        }

        private boolean loadView(Query q, String queryWKT) throws SQLException {
            String qnn = SQLConverter.preEscapingIdentifier(q.getName());
            if (qnn == null) {
                return false;
            }
            int seq = LoadJet.this.metadata.newTable(q.getName(), qnn, ObjectType.VIEW);
            this.registerQueryColumns(q, seq);
            qnn = SQLConverter.completeEscaping(qnn, false);
            qnn = SQLConverter.checkLang(qnn, LoadJet.this.conn, false);
            if (qnn.indexOf(32) > 0) {
                SQLConverter.addWhiteSpacedTableNames(q.getName());
            }
            String querySQL = queryWKT == null ? q.toSQLString() : queryWKT;
            Pivot pivot = null;
            boolean isPivot = q.getType().equals((Object)Query.Type.CROSS_TAB);
            if (isPivot && (!(pivot = new Pivot(LoadJet.this.conn)).parsePivot(querySQL) || (querySQL = pivot.toSQL(q.getName())) == null)) {
                this.notLoaded.put(q.getName(), "cannot load this query");
                return false;
            }
            querySQL = new DFunction(LoadJet.this.conn, querySQL).toSQL();
            StringBuilder sb = new StringBuilder("CREATE VIEW ").append(qnn).append(" AS ").append(querySQL);
            String v = null;
            try {
                v = SQLConverter.convertSQL(sb.toString(), true).getSql();
                if (v.trim().endsWith(";")) {
                    v = v.trim().substring(0, v.length() - 1);
                }
                LoadJet.this.exec(v, false);
                LoadJet.this.loadedQueries.add(q.getName());
                this.notLoaded.remove(q.getName());
                if (pivot != null) {
                    pivot.registerPivot(SQLConverter.preEscapingIdentifier(q.getName()));
                }
                return true;
            }
            catch (Exception _ex) {
                if (_ex instanceof SQLSyntaxErrorException) {
                    if (queryWKT == null && ((SQLSyntaxErrorException)_ex).getErrorCode() == -5504) {
                        return this.loadView(q, this.solveAmbiguous(querySQL));
                    }
                    SQLSyntaxErrorException sqle = (SQLSyntaxErrorException)_ex;
                    if (sqle.getErrorCode() == -5501 || sqle.getErrorCode() == -5581) {
                        ParametricQuery pq = new ParametricQuery(LoadJet.this.conn, (QueryImpl)q);
                        pq.setIssueWithParameterName(sqle.getErrorCode() == -5581);
                        pq.createSelect();
                        if (pq.loaded()) {
                            LoadJet.this.loadedQueries.add(q.getName());
                            this.notLoaded.remove(q.getName());
                            return true;
                        }
                    }
                }
                String cause = UcanaccessSQLException.explainCause(_ex);
                this.notLoaded.put(q.getName(), ": " + cause);
                if (!LoadJet.this.err) {
                    Logger.log("Error occured at the first loading attempt of " + q.getName());
                    Logger.log("Converted view was :" + v);
                    Logger.log("Error message was :" + _ex.getMessage());
                    LoadJet.this.err = true;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        private String solveAmbiguous(String sql) {
            try {
                sql = sql.replaceAll("[\n\r]", " ");
                Pattern pt = Pattern.compile("(.*)[\n\r\\s]*(?i)SELECT([\n\r\\s].*[\n\r\\s])(?i)FROM([\n\r\\s])(.*)");
                Matcher mtc = pt.matcher(sql);
                if (mtc.find()) {
                    void var10_14;
                    String select = mtc.group(2);
                    String pre = mtc.group(1) == null ? "" : mtc.group(1);
                    String[] splitted = select.split(",", -1);
                    StringBuilder sb = new StringBuilder(pre).append(" select ");
                    LinkedList<Object> lkl = new LinkedList<Object>();
                    String[] stringArray = splitted;
                    int n = splitted.length;
                    boolean n2 = false;
                    while (var10_14 < n) {
                        String s = stringArray[var10_14];
                        int j = s.lastIndexOf(46);
                        Pattern aliasPt = Pattern.compile("[\\s\n\r]+(?i)AS[\\s\n\r]+");
                        boolean alias = aliasPt.matcher(s).find();
                        if (j < 0 || alias) {
                            lkl.add(s);
                        } else {
                            String k = s.substring(j + 1);
                            if (lkl.contains(k)) {
                                int idx = lkl.indexOf(k);
                                String old = (String)lkl.get(lkl.indexOf(k));
                                lkl.remove(old);
                                lkl.add(idx, splitted[idx] + " AS [" + splitted[idx].trim() + "]");
                                lkl.add(s + " AS [" + s.trim() + "]");
                            } else {
                                lkl.add(k);
                            }
                        }
                        ++var10_14;
                    }
                    String comma = "";
                    for (String string : lkl) {
                        sb.append(comma).append(string);
                        comma = ",";
                    }
                    sb.append(" FROM ").append(mtc.group(4));
                    return sb.toString();
                }
                return sql;
            }
            catch (Exception _ex) {
                return sql;
            }
        }

        private void loadViews() throws SQLException {
            List lq = null;
            ArrayList<Query> procedures = new ArrayList<Query>();
            try {
                lq = LoadJet.this.dbIO.getQueries();
                Iterator it = lq.iterator();
                while (it.hasNext()) {
                    Query q = (Query)it.next();
                    if (q.getType().equals((Object)Query.Type.SELECT) || q.getType().equals((Object)Query.Type.UNION) || q.getType().equals((Object)Query.Type.CROSS_TAB)) continue;
                    procedures.add(q);
                    it.remove();
                }
                this.queryPorting(lq);
            }
            catch (Exception _ex) {
                this.notLoaded.put("", "");
            }
            this.loadProcedures(procedures);
        }

        private void loadProcedures(List<Query> procedures) {
            for (Query q : procedures) {
                ParametricQuery pq = new ParametricQuery(LoadJet.this.conn, (QueryImpl)q);
                if (q.getType().equals((Object)Query.Type.DATA_DEFINITION)) continue;
                pq.createProcedure();
                if (pq.loaded()) {
                    LoadJet.this.loadedProcedures.add(pq.getSignature());
                    continue;
                }
                String msg = pq.getException() == null ? "" : pq.getException().getMessage();
                this.notLoadedProcedure.put(q.getName(), msg);
            }
        }

        private void queryPorting(List<Query> lq) throws SQLException {
            ArrayList<String> arn = new ArrayList<String>();
            for (Query q : lq) {
                arn.add(q.getName().toLowerCase());
            }
            boolean heavy = false;
            while (!lq.isEmpty()) {
                ArrayList<Query> arq = new ArrayList<Query>();
                for (Query q : lq) {
                    String qtxt = null;
                    boolean qryGot = true;
                    try {
                        qtxt = q.toSQLString().toLowerCase();
                    }
                    catch (Exception _ignored) {
                        qryGot = false;
                    }
                    boolean foundDep = false;
                    if (qryGot && !heavy) {
                        for (String name : arn) {
                            if (!qtxt.contains(name)) continue;
                            foundDep = true;
                            break;
                        }
                    }
                    if (!qryGot || foundDep || !this.loadView(q)) continue;
                    arq.add(q);
                    arn.remove(q.getName().toLowerCase());
                }
                if (arq.isEmpty()) {
                    if (heavy) break;
                    heavy = true;
                }
                lq.removeAll(arq);
            }
            Pivot.clearPrepared();
        }
    }
}

