/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.resourcesearch.ResourceSearch;
import com.oracle.bmc.resourcesearch.model.ResourceType;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ResourceSearchPaginators {
    private final ResourceSearch client;

    public ResourceSearchPaginators(ResourceSearch client) {
        this.client = client;
    }

    public Iterable<ListResourceTypesResponse> listResourceTypesResponseIterator(final ListResourceTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListResourceTypesRequest.Builder>(){
            final /* synthetic */ ResourceSearchPaginators this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ListResourceTypesRequest.Builder get() {
                return ListResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceTypesResponse, String>(){

            @Override
            public String apply(ListResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceTypesRequest.Builder>, ListResourceTypesRequest>(){

            @Override
            public ListResourceTypesRequest apply(RequestBuilderAndToken<ListResourceTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceTypesRequest, ListResourceTypesResponse>(){

            @Override
            public ListResourceTypesResponse apply(ListResourceTypesRequest request) {
                return ResourceSearchPaginators.this.client.listResourceTypes(request);
            }
        });
    }

    public Iterable<ResourceType> listResourceTypesRecordIterator(final ListResourceTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListResourceTypesRequest.Builder>(){
            final /* synthetic */ ResourceSearchPaginators this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ListResourceTypesRequest.Builder get() {
                return ListResourceTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListResourceTypesResponse, String>(){

            @Override
            public String apply(ListResourceTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListResourceTypesRequest.Builder>, ListResourceTypesRequest>(){

            @Override
            public ListResourceTypesRequest apply(RequestBuilderAndToken<ListResourceTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListResourceTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListResourceTypesRequest, ListResourceTypesResponse>(){

            @Override
            public ListResourceTypesResponse apply(ListResourceTypesRequest request) {
                return ResourceSearchPaginators.this.client.listResourceTypes(request);
            }
        }, (Function)new Function<ListResourceTypesResponse, List<ResourceType>>(){

            @Override
            public List<ResourceType> apply(ListResourceTypesResponse response) {
                return response.getItems();
            }
        });
    }
}

