/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.xml.navigator.Descriptor;
import oracle.dbtools.xml.navigator.FolderElement;
import oracle.xml.parser.v2.XMLNode;

public abstract class FolderOwner
extends Descriptor {
    private static final String CONNECTION_TYPE = "connType";
    private static final String INCLUDES_SYNONYMS = "includesSyns";
    private static final String ELEMENT_FOLDER = "folder";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    private static final String ATTRIBUTE_REQUIRES_PARENT = "requiresParent";
    private static final String ATTRIBUTE_TREEONLY = "treeonly";
    private static final String REQUIRED_LICENSES = "requiredLicenses";
    private double weight = Double.NEGATIVE_INFINITY;
    private boolean includeSynonyms;
    private boolean treeOnly;
    private boolean requiresParent;
    private List<FolderElement> folders;
    private String dbType;
    private String category;
    private Set<String> requiredLicences;

    FolderOwner(XMLNode node) {
        super(node);
        XMLNode[] folderDescs;
        this.treeOnly = FolderOwner.getBooleanValue("", ATTRIBUTE_TREEONLY, node);
        this.requiresParent = FolderOwner.getBooleanValue("", ATTRIBUTE_REQUIRES_PARENT, node);
        this.includeSynonyms = FolderOwner.getBooleanValue("", INCLUDES_SYNONYMS, node);
        this.dbType = FolderOwner.getAttributeValue("", CONNECTION_TYPE, node);
        this.category = FolderOwner.getAttributeValue("", "category", node);
        this.requiredLicences = FolderOwner.parseSet(node, REQUIRED_LICENSES);
        String weight = FolderOwner.getAttributeValue("", ATTRIBUTE_WEIGHT, node);
        if (weight != null) {
            try {
                this.weight = Double.parseDouble(weight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((folderDescs = FolderOwner.getElements(ELEMENT_FOLDER, node)).length > 0) {
            this.folders = new ArrayList<FolderElement>();
            for (XMLNode folder : folderDescs) {
                this.folders.add(new FolderElement(folder));
            }
        }
    }

    public final double getWeight() {
        return this.weight;
    }

    public final boolean isIncludeSynonyms() {
        return this.includeSynonyms;
    }

    public final boolean isTreeOnly() {
        return this.treeOnly;
    }

    public final boolean isRequiresParent() {
        return this.requiresParent;
    }

    public final List<FolderElement> getFolders() {
        return FolderOwner.wrapList(this.folders);
    }

    public final String getDatabaseType() {
        return this.dbType;
    }

    public final String getCategory() {
        return this.category;
    }

    public Set<String> getRequiredLicences() {
        return FolderOwner.wrapSet(this.requiredLicences);
    }
}

