/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public class InputOutputStreams {
    private static final int BUFFER_SIZE = 65536;
    private static final EmptyStream EMPTY_STREAM = new EmptyStream();
    private static final InputOutputStreams INSTANCE = new InputOutputStreams();
    private static final NullOutputStream NULL_OUTPUT_STREAM = new NullOutputStream();
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static final InputOutputStreams instance() {
        return INSTANCE;
    }

    private InputOutputStreams() {
    }

    public byte[] asByteArray(InputStream is) throws IOException {
        ReadableByteChannel source = Channels.newChannel(is);
        return this.asByteArray(source);
    }

    public byte[] asByteArray(ReadableByteChannel source) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            WritableByteChannel destination = Channels.newChannel(os);
            this.copy(source, destination);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public InputStream asInputStream(byte[] bytes) {
        if (bytes.length == 0) {
            return EMPTY_STREAM;
        }
        return new ByteArrayInputStream(bytes);
    }

    public InputStream asInputStream(CharSequence text) throws IOException {
        if (null == text) {
            return EMPTY_STREAM;
        }
        return this.asInputStream(text.toString().getBytes(UTF_8));
    }

    public long copy(InputStream is, OutputStream os) throws IOException {
        if (is != null && os != null) {
            ReadableByteChannel source = Channels.newChannel(is);
            WritableByteChannel destination = Channels.newChannel(os);
            return this.copy(source, destination);
        }
        return -1L;
    }

    public long copy(Readable source, Appendable destination) throws IOException {
        long length = 0L;
        CharBuffer buffer = CharBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            destination.append(buffer, 0, buffer.limit());
            length += (long)buffer.limit();
            buffer.clear();
        }
        return length;
    }

    public long copy(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                length += (long)destination.write(buffer);
            }
            buffer.clear();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destination.write(buffer);
        }
        return length;
    }

    public OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public Reader reader(InputStream content) {
        return new InputStreamReader(content, UTF_8);
    }

    public InputStream uncloseable(InputStream stream) {
        return new Uncloseable(stream);
    }

    public Writer writer(OutputStream out) {
        return new OutputStreamWriter(out, UTF_8);
    }

    private static final class EmptyStream
    extends InputStream {
        private EmptyStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private static final class Uncloseable
    extends FilterInputStream {
        Uncloseable(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

