/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.utils.SQLExceptionListener;

public final class SQLExceptionListenerRegistry {
    private static List<SQLExceptionListener> _listeners = new ArrayList<SQLExceptionListener>();

    public static void addListener(SQLExceptionListener l) {
        _listeners.add(l);
    }

    public static void removeListener(SQLExceptionListener l) {
        _listeners.remove(l);
    }

    public static final boolean listenForError(String connName, String sql, Exception e) {
        SQLExceptionListener l;
        boolean handled = false;
        if (!(e instanceof SQLException)) {
            return false;
        }
        Iterator<SQLExceptionListener> iterator = _listeners.iterator();
        while (iterator.hasNext() && !(handled = (l = iterator.next()).handleSQLError(connName, (SQLException)e))) {
        }
        return handled;
    }
}

