/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.db.QueryDB;
import oracle.dbtools.raptor.query.db.QueryItem;

public final class QueryCache {
    private static int MAX_CACHE_SIZE = 5000;
    private static Cache<String, List<Query>> _queries = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE).build();

    public static Query getQuery(String id) {
        QueryItem qi = QueryDB.getDatabase().findSharedQuery(id);
        if (qi != null) {
            return new Query(qi.getPk());
        }
        return null;
    }

    public static synchronized void putQuery(String id, List<Query> qList) {
        _queries.put((Object)id, qList);
    }

    public static List<Query> getQueries(String id) {
        return (List)_queries.getIfPresent((Object)id);
    }
}

