/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraTemporalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPTZ;

public class OraTIMESTAMPTZFormat
extends OraTemporalDatumFormat {
    private static final int REGIONIDBIT = 128;
    private static final byte OFFSET_HOUR = 20;
    private static final byte OFFSET_MINUTE = 60;
    private static final String[] digit = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public OraTIMESTAMPTZFormat(String pattern, OraLocaleInfo localeInfo) throws ParseException {
        super(pattern, localeInfo, null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraTIMESTAMPTZFormat && super.equals(object);
    }

    public String format(TIMESTAMPTZ date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(TIMESTAMPTZ date, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer result = this.formatTemporalDatum(OraTIMESTAMPTZ.getInstance(date), toAppendTo, pos);
        int indexGMT = result.indexOf("GMT");
        if (indexGMT >= 0 && result.length() - indexGMT >= 9 && (result.charAt(indexGMT + 3) == '+' || result.charAt(indexGMT + 3) == '-') && result.charAt(indexGMT + 4) >= '0' && result.charAt(indexGMT + 4) <= '9' && result.charAt(indexGMT + 5) >= '0' && result.charAt(indexGMT + 5) <= '9' && result.charAt(indexGMT + 6) == ':' && result.charAt(indexGMT + 7) >= '0' && result.charAt(indexGMT + 7) <= '9' && result.charAt(indexGMT + 8) >= '0' && result.charAt(indexGMT + 8) <= '9') {
            result.delete(indexGMT, indexGMT + 3);
        }
        return result;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj instanceof TIMESTAMPTZ) {
            return this.format((TIMESTAMPTZ)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException(Messages.getString("OraTIMESTAMPTZFormat.70"));
    }

    public TIMESTAMPTZ parse(String text, ParsePosition pos) {
        OraTIMESTAMPTZ temporalDatum = (OraTIMESTAMPTZ)this.parseTemporalDatum(text, pos, UTC, true);
        return temporalDatum != null ? temporalDatum.getDatum() : null;
    }

    @Override
    protected OraTemporalDatum getTemporalDatum(Calendar calendar, int nanos) {
        return OraTIMESTAMPTZ.getInstance(calendar, nanos).setSessionTimeZone(this.getSessionTimeZone());
    }
}

