/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.datetime;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.datetime.Messages;

public class DateTransformer
implements Transformer<String, Date> {
    private final String dateFmtStr;

    public DateTransformer(String dateFmtStr) {
        if (null == dateFmtStr || dateFmtStr.isBlank()) {
            throw new IllegalArgumentException("Parameter dateFmtStr cannot be empty.");
        }
        this.dateFmtStr = dateFmtStr;
    }

    @Override
    public Date transform(String rawValue, TransformContext context, Environment environment) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFmtStr);
            String dateStr = rawValue.trim().replaceAll("^\"|\"$", "");
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            context.addError(Messages.getString(Messages.Key.DATE_FORMAT_ERROR, environment.getLocale()));
            return null;
        }
    }

    @Override
    public String getFormat(Locale locale) {
        return this.dateFmtStr;
    }
}

