/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.basic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class ChainedTransformer<R, T>
implements Transformer<R, T> {
    private final List<Transformer<Object, Object>> transformers;

    public ChainedTransformer(Transformer<?, ?> ... transformers) {
        if (transformers.length < 2) {
            throw new IllegalArgumentException("can't chain less than two transformers");
        }
        this.transformers = Arrays.asList(transformers);
    }

    @Override
    public T transform(R rawValue, TransformContext context, Environment environment) {
        Object value = rawValue;
        ArrayList errors = new ArrayList();
        TransformContext chainContext = this.createChainContext(errors::add);
        for (int t = 0; t < this.transformers.size() - 1; ++t) {
            Transformer<Object, Object> transformer = this.transformers.get(t);
            value = transformer.transform(value, chainContext, environment);
            if (!errors.isEmpty()) break;
        }
        if (errors.isEmpty()) {
            Transformer<Object, Object> transformer = this.transformers.get(this.transformers.size() - 1);
            value = transformer.transform(value, context, environment);
        } else {
            for (String error : errors) {
                context.addError(error);
            }
        }
        return (T)value;
    }

    private TransformContext createChainContext(final Consumer<String> errors) {
        return new TransformContext(){

            @Override
            public void addError(String error) {
                if (errors != null) {
                    errors.accept(error);
                }
            }

            @Override
            public void addCompletion(String completion) {
            }

            @Override
            public boolean requiresCompletions() {
                return false;
            }
        };
    }
}

