/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.tokenizer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.AbstractTokenizer;

public class SQLPLUSTokenizer
extends AbstractTokenizer {
    private static final Pattern LINE_PATTERN = Pattern.compile("(?:('(?:[^']|'')*')|(\\\"(?:[^\\\"]|\\\"\\\")*\\\")|[=:]|([^\\s'\\\"=:]+))");
    private static final Pattern ESCAPES_SINGLE_PATTERN = Pattern.compile("''");
    private static final Pattern ESCAPES_DOUBLE_PATTERN = Pattern.compile("\"\"");

    @Override
    protected void findMatches(String line, AbstractTokenizer.MatchRegistry registry) {
        Matcher lineMatcher = LINE_PATTERN.matcher(line);
        while (lineMatcher.find()) {
            String reducedValue;
            String wordMatch = lineMatcher.group(0);
            Pattern escapesPattern = null;
            if (wordMatch.length() > 1) {
                char first = wordMatch.charAt(0);
                if (first == '\'') {
                    escapesPattern = ESCAPES_SINGLE_PATTERN;
                } else if (first == '\"') {
                    escapesPattern = ESCAPES_DOUBLE_PATTERN;
                }
            }
            int start = lineMatcher.start(0);
            int end = lineMatcher.end(0);
            if (escapesPattern != null) {
                Matcher escapesMatcher = escapesPattern.matcher(wordMatch);
                StringBuilder sbuf = new StringBuilder();
                int charNo = 0;
                while (escapesMatcher.find()) {
                    String escapesMatch = escapesMatcher.group();
                    int escapesStart = escapesMatcher.start();
                    int escapesEnd = escapesMatcher.end();
                    switch (escapesMatch) {
                        case "''": {
                            sbuf.append(wordMatch.substring(charNo, escapesStart));
                            sbuf.append("'");
                            break;
                        }
                        case "\"\"": {
                            sbuf.append(wordMatch.substring(charNo, escapesStart));
                            sbuf.append("\"");
                        }
                    }
                    charNo = escapesEnd;
                }
                sbuf.append(wordMatch.substring(charNo));
                reducedValue = sbuf.toString();
            } else {
                reducedValue = wordMatch;
            }
            registry.addMatch(reducedValue, wordMatch, start, end);
        }
    }
}

