/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AttributeBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;

public final class ParameterBuilder
extends AttributeBuilder<ParameterBuilder> {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();
    private final Id id;

    public ParameterBuilder name(String name) {
        this.namePropertiesBuilder.setName(name);
        return this;
    }

    public ParameterBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public ParameterBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    public <T> Parameter<T> build() {
        ParameterImpl parameter = new ParameterImpl(this, this.namePropertiesBuilder.build(this.id, false));
        this.validate(parameter);
        return parameter;
    }

    protected ParameterBuilder(Id id) {
        this.id = id;
    }

    private static class ParameterImpl<T>
    extends AttributeBuilder.AttributeImpl<T>
    implements Parameter<T> {
        private final Id id;
        private final String name;
        private final Optional<String> helpId;

        private ParameterImpl(ParameterBuilder builder, NamePropertiesBuilder.NameProperties nameProperties) {
            super(builder);
            this.id = builder.id;
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
        }

        @Override
        public Id getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public Syntax getSyntax() {
            return new Syntax("<" + this.getName().toLowerCase() + ">", false);
        }
    }
}

