/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AttributeContainer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Rule;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

class ContainerObjectsBuilder {
    private Grammar<?> grammar;
    private final List<AttributeContainer> containers = new ArrayList<AttributeContainer>();
    private final List<Option<?>> options = new ArrayList();
    private final List<Parameter<?>> parameters = new ArrayList();
    private final List<Type> nestedTypes = new ArrayList<Type>();
    private final List<HelpContainer> helpContainers = new ArrayList<HelpContainer>();
    private final List<Factory.AttributeRef> attributeRefs = new ArrayList<Factory.AttributeRef>();

    ContainerObjectsBuilder() {
    }

    void addContainer(AttributeContainer container) {
        this.containers.add(container);
    }

    void setGrammar(Grammar<?> grammar) {
        this.grammar = grammar;
    }

    void addOption(Option<?> option) {
        this.options.add(option);
    }

    void addParameter(Parameter<?> parameter) {
        this.parameters.add(parameter);
    }

    void addNestedType(Type nestedType) {
        this.nestedTypes.add(nestedType);
    }

    void addHelpContainer(HelpContainer helpContainer) {
        this.helpContainers.add(helpContainer);
    }

    void addAttributeRef(Factory.AttributeRef attributeRef) {
        this.attributeRefs.add(attributeRef);
    }

    void addHelpContainerFor(Object forObject) {
        this.addHelpContainerFor(forObject, "Help");
    }

    void addHelpContainerFor(Object forObject, String bundleName) {
        StringBuilder buff = new StringBuilder();
        buff.append(forObject.getClass().getPackageName()).append(".").append(bundleName);
        this.helpContainers.add(new HelpBundleBuilder(buff.toString()).classLoader(forObject.getClass().getClassLoader()).build());
    }

    ContainerObjects build() {
        for (AttributeContainer container : this.containers) {
            this.options.addAll(container.getOptions());
            this.parameters.addAll(container.getParameters());
            this.helpContainers.addAll(container.getHelpContainers());
        }
        Map<String, MutexGroupMetadata> mutexGroupsMetadata = this.buildMutexGroupsMetadata();
        return new ContainerObjects(this.grammar, Collections.unmodifiableList(this.options), Collections.unmodifiableList(this.parameters), Collections.unmodifiableList(this.nestedTypes), Collections.unmodifiableList(this.helpContainers), Collections.unmodifiableMap(mutexGroupsMetadata));
    }

    void validate(Type type) {
        StringBuilder errorBuff = new StringBuilder();
        HashSet<Id> idSet = new HashSet<Id>();
        HashSet<String> helpIdSet = new HashSet<String>();
        this.validateHelpId(errorBuff, helpIdSet, type.getHelpId());
        HashSet<String> synonymSet = new HashSet<String>();
        for (Option<?> option : this.options) {
            this.validateId(errorBuff, idSet, option.getId());
            this.validateHelpId(errorBuff, helpIdSet, option.getHelpId());
            this.validateSynonyms(errorBuff, synonymSet, option.getSynonyms().get());
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (Parameter parameter : this.parameters) {
            this.validateId(errorBuff, idSet, parameter.getId());
            this.validateHelpId(errorBuff, helpIdSet, parameter.getHelpId());
            this.validateSynonym(errorBuff, nameSet, parameter.getName());
        }
        synonymSet = new HashSet();
        for (Type type2 : this.nestedTypes) {
            this.validateId(errorBuff, idSet, type2.getId());
            this.validateHelpId(errorBuff, helpIdSet, type2.getHelpId());
            this.validateSynonyms(errorBuff, synonymSet, type2.getSynonyms().get());
        }
        if (this.grammar != null) {
            nameSet = new HashSet();
            for (Rule rule : this.grammar.getRules()) {
                this.validateId(errorBuff, idSet, rule.getId());
                this.validateSynonym(errorBuff, nameSet, rule.getName());
                this.validateHelpId(errorBuff, helpIdSet, rule.getHelpId());
                rule.getExpression().visitNamedExpressions(expression -> this.validateHelpId(errorBuff, helpIdSet, expression.getHelpId(), false));
            }
        }
        this.validateMutuallyExclusiveGroups(errorBuff);
        if (errorBuff.length() > 0) {
            throw new IllegalArgumentException("Invalid parser Type definition '" + type.getName() + "':-\n" + errorBuff.toString());
        }
    }

    private void validateSynonyms(StringBuilder errorBuff, Set<String> synonymSet, Set<String> synonyms) {
        for (String synonym : synonyms) {
            this.validateSynonym(errorBuff, synonymSet, synonym);
        }
    }

    private void validateId(StringBuilder errorBuff, Set<Id> idSet, Id id) {
        if (!idSet.add(id)) {
            this.addValidationError(errorBuff, "duplicate ID", id.toString());
        }
    }

    private void validateSynonym(StringBuilder errorBuff, Set<String> synonymSet, String synonym) {
        if (!synonymSet.add(synonym)) {
            this.addValidationError(errorBuff, "duplicate synonym", synonym);
        }
    }

    private void validateHelpId(StringBuilder errorBuff, Set<String> helpIdSet, Optional<String> helpIdOptional) {
        this.validateHelpId(errorBuff, helpIdSet, helpIdOptional, true);
    }

    private void validateHelpId(StringBuilder errorBuff, Set<String> helpIdSet, Optional<String> helpIdOptional, boolean add) {
        if (helpIdOptional.isPresent()) {
            String helpId = helpIdOptional.get();
            boolean contains = add ? !helpIdSet.add(helpId) : helpIdSet.contains(helpId);
            if (contains) {
                this.addValidationError(errorBuff, "duplicate help ID", helpId);
            }
        }
    }

    private void validateMutuallyExclusiveGroups(StringBuilder errorBuff) {
        HashSet<Id> groupReferences = new HashSet<Id>(this.attributeRefs.size());
        for (Factory.AttributeRef attributeRef : this.attributeRefs) {
            groupReferences.add(attributeRef.getRuleId());
        }
        for (Type type : this.nestedTypes) {
            if (!groupReferences.contains(type.getId())) continue;
            this.addValidationError(errorBuff, "You can not use nested types in mutually exclusive groups", type.getName());
        }
        for (Option option : this.options) {
            groupReferences.remove(option.getId());
        }
        for (Parameter parameter : this.parameters) {
            groupReferences.remove(parameter.getId());
        }
        if (!groupReferences.isEmpty()) {
            String invalidReferences = groupReferences.stream().map(Id::getName).collect(Collectors.joining(", "));
            this.addValidationError(errorBuff, "Mutual exclusivity group contains references to non-existent attributes", invalidReferences);
        }
    }

    private void addValidationError(StringBuilder errorBuff, String tag, String item) {
        if (errorBuff.length() > 0) {
            errorBuff.append("\n");
        }
        errorBuff.append("  ").append(tag).append(": ").append(item);
    }

    private Map<String, MutexGroupMetadata> buildMutexGroupsMetadata() {
        if (this.attributeRefs.isEmpty()) {
            return new HashMap<String, MutexGroupMetadata>(0);
        }
        HashMap<String, MutexGroupMetadata> mutexGroupsMetadata = new HashMap<String, MutexGroupMetadata>();
        HashMap<Id, List> idToGroupNames = new HashMap<Id, List>(this.attributeRefs.size());
        HashMap<String, Boolean> groupRequiredStatus = new HashMap<String, Boolean>();
        HashMap<String, Set> groupToAllAttributeIds = new HashMap<String, Set>();
        for (Factory.AttributeRef attributeRef : this.attributeRefs) {
            Id key = attributeRef.getRuleId();
            String groupName = attributeRef.getGroupName();
            idToGroupNames.computeIfAbsent(key, k -> new ArrayList()).add(groupName);
            groupRequiredStatus.put(groupName, attributeRef.isRequired());
            groupToAllAttributeIds.computeIfAbsent(groupName, k -> new HashSet()).add(key);
        }
        for (Map.Entry entry : groupToAllAttributeIds.entrySet()) {
            String groupName = (String)entry.getKey();
            boolean required = (Boolean)groupRequiredStatus.get(groupName);
            Set attributeIds = (Set)entry.getValue();
            mutexGroupsMetadata.put(groupName, new MutexGroupMetadata(groupName, required, attributeIds));
        }
        return mutexGroupsMetadata;
    }

    static class ContainerObjects {
        private final Grammar<?> grammar;
        private final List<Option<?>> options;
        private final List<Parameter<?>> parameters;
        private final List<Type> nestedTypes;
        private final List<HelpContainer> helpContainers;
        private final Map<String, MutexGroupMetadata> mutexGroupsMetadata;

        Grammar<?> getGrammar() {
            return this.grammar;
        }

        List<Option<?>> getOptions() {
            return this.options;
        }

        List<Parameter<?>> getParameters() {
            return this.parameters;
        }

        List<Type> getNestedTypes() {
            return this.nestedTypes;
        }

        List<HelpContainer> getHelpContainers() {
            return this.helpContainers;
        }

        Map<String, MutexGroupMetadata> getMutexGroupsMetadata() {
            return this.mutexGroupsMetadata;
        }

        private ContainerObjects(Grammar<?> grammar, List<Option<?>> options, List<Parameter<?>> parameters, List<Type> nestedTypes, List<HelpContainer> helpContainers, Map<String, MutexGroupMetadata> mutexGroupsMetadata) {
            this.grammar = grammar;
            this.options = options;
            this.parameters = parameters;
            this.nestedTypes = nestedTypes;
            this.helpContainers = helpContainers;
            this.mutexGroupsMetadata = mutexGroupsMetadata;
        }
    }

    static class MutexGroupMetadata {
        private final String groupName;
        private final boolean required;
        private final Set<Id> attributeIds;

        public MutexGroupMetadata(String groupName, boolean required, Set<Id> attributeIds) {
            this.groupName = groupName;
            this.required = required;
            this.attributeIds = Collections.unmodifiableSet(new HashSet<Id>(attributeIds));
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Set<Id> getAttributeIds() {
            return this.attributeIds;
        }
    }
}

