/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.validators;

import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;

public class BooleanValidator
extends AbstractValidatorService<Boolean> {
    @Override
    public Boolean getParameter(String parm) throws ParameterFailedValidationException {
        try {
            if (parm.toLowerCase().equals("true") || parm.toLowerCase().equals("false")) {
                return Boolean.valueOf(parm);
            }
            throw new ParameterFailedValidationException(ParmResources.format("BAD_PARM_VALUE", parm, this.pName, "Boolean"));
        }
        catch (Exception e) {
            if (e instanceof ParameterFailedValidationException) {
                throw e;
            }
            throw new ParameterFailedValidationException(ParmResources.format("BAD_PARM_VALUE", parm, this.pName, "Boolean"));
        }
    }

    @Override
    public String parmToString() {
        return Boolean.toString((Boolean)this.parmValue);
    }

    @Override
    public List<Boolean> StringToTypeList(String stringList) {
        try {
            String[] tempArray;
            for (String bool : tempArray = stringList.split(",")) {
                this.allowedValues.add(Boolean.parseBoolean(bool.trim()));
            }
            return this.allowedValues;
        }
        catch (Exception e) {
            return null;
        }
    }
}

