/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.Help;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.AbstractCommandConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.SortMap;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.StringWrapper;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;

public class CommandHelp {
    private final Function<String, String> help;
    private final ScriptRunnerContext _ctx;
    private final String _set;
    private final AbstractCommandConstants constants;
    private final String on = "!$";
    private final String yellow = "\u001b[33m";
    private final String off = "$!";
    private final String reset = "\u001b[0m";
    private final String sep = System.lineSeparator();
    private final String spacer = "    ";

    public CommandHelp(ScriptRunnerContext ctx, AbstractCommandConstants constants) {
        this._ctx = ctx;
        this.constants = constants;
        this.help = constants.getHelpMap();
        this._set = constants.getParameterSetName();
    }

    public CommandHelp(ScriptRunnerContext ctx, Class<? extends AbstractCommandConstants> constantsClass) throws CommandHelpClassException {
        this._ctx = ctx;
        try {
            this.constants = constantsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.help = this.constants.getHelpMap();
            this._set = this.constants.getParameterSetName();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CommandHelpClassException(ParmResources.getString("HELP_ERROR"), e);
        }
    }

    private String baseUsage(boolean showUsage) {
        StringBuilder sb = new StringBuilder();
        if (showUsage) {
            sb.append(this.sep + "  " + ParmResources.getString("USAGE") + this.sep);
        }
        sb.append("  !$" + this.constants.getBaseCommandName() + "$!");
        if (this.constants.getBaseCommandShortName() != null) {
            sb.append("|!$" + this.constants.getBaseCommandShortName() + "$!");
        }
        sb.append(" ");
        return sb.toString();
    }

    private String getCommandExample(String command) {
        StringBuilder sb = new StringBuilder();
        sb.append("Example(s): \n");
        sb.append(StringWrapper.wrapString(this.help.apply(this.constants.getConstantName(command + "_EX")), this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    "));
        sb.append(this.sep);
        String replace = sb.toString();
        replace = replace.replaceAll("\\!\\$", "\u001b[33m");
        replace = replace.replaceAll("\\$\\!", "\u001b[0m");
        return replace;
    }

    public String getCommandHelp() {
        StringBuilder sb = new StringBuilder();
        String command = this._ctx.getParameterInstance().getParameterAsString(this._set, CommandParserConstants.COMMAND);
        if (command != null) {
            if (CommandParserConstants.HELP.equals(command)) {
                if (this._ctx.getParameterInstance().getParameterAsBoolean(this._set, CommandParserConstants.SYNTAX).booleanValue()) {
                    return this.getCommandSyntax(command);
                }
                if (this._ctx.getParameterInstance().getParameterAsBoolean(this._set, CommandParserConstants.EXAMPLE).booleanValue()) {
                    if (command.equals(CommandParserConstants.HELP)) {
                        return this.getCommandExample(this.constants.getBaseCommandName());
                    }
                    return this.getCommandExample(command);
                }
                if (this.constants.getCommandModel().size() > 1) {
                    return this.getCommandsList();
                }
                command = this.constants.getBaseCommandName();
            } else if (this._ctx.getParameterInstance().getParameterAsBoolean(this._set, CommandParserConstants.HELP).booleanValue()) {
                if (this._ctx.getParameterInstance().getParameterAsBoolean(this._set, CommandParserConstants.SYNTAX).booleanValue()) {
                    return this.getCommandSyntax(command);
                }
                if (this._ctx.getParameterInstance().getParameterAsBoolean(this._set, CommandParserConstants.EXAMPLE).booleanValue()) {
                    return this.getCommandExample(command);
                }
            }
        }
        sb.append(this.getCommandUsage(command));
        Map<String, StandardParameter> params = this.constants.getCommandModel().get(command);
        params = this.constants.getCommandModel().get(command) != null && params instanceof LinkedHashMap ? this.constants.getCommandModel().get(command) : this.sortByValue(this.constants.getCommandModel().get(command));
        if (params == null || params.size() == 0) {
            return sb.toString();
        }
        sb.append("    " + ParmResources.getString("PARAMETERS") + this.sep);
        for (String param : params.keySet()) {
            StandardParameter sp = params.get(param);
            if (!sp.isPositional()) {
                sb.append("!$    -" + param + "$!");
                String shortParam = this.constants.getShortParam(param);
                if (ModelUtil.hasLength(shortParam)) {
                    sb.append(" | !$-" + shortParam + "$!");
                }
            } else {
                sb.append("!$    " + param + "$!");
            }
            if (params.get(param).isRequired()) {
                sb.append("!$ [" + ParmResources.getString("REQUIRED_SYNTAX") + "]$!");
            }
            if (this.constants.showDefaultInHelp() && params.get(param).getDefault() != null) {
                sb.append(" [" + ParmResources.getString("DEFAULT_SYNTAX") + ":" + params.get(param).getDefault() + "]");
            }
            if (params.get(param).getAllowed() != null) {
                sb.append(StringWrapper.wrapString(" {" + params.get(param).getAllowed().replaceAll(",", "|") + "}", this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    ", false));
            } else {
                sb.append(this.sep);
            }
            String baseKey = param + "_P";
            String cmdKey = command + "_" + baseKey;
            String resolvedName = this.constants.getConstantName(cmdKey);
            String helpText = this.help.apply(resolvedName);
            if (CommandHelp.isHelpMissing(resolvedName, helpText)) {
                helpText = this.help.apply(this.constants.getConstantName(baseKey));
            }
            sb.append(StringWrapper.wrapString(helpText, this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    "));
            sb.append(this.sep);
        }
        String replace = sb.toString();
        replace = replace.replaceAll("\\!\\$", "\u001b[33m");
        replace = replace.replaceAll("\\$\\!", "\u001b[0m");
        return replace;
    }

    private static boolean isHelpMissing(String resolvedName, String helpText) {
        return !ModelUtil.hasLength(helpText) || ("!" + resolvedName + "!").equalsIgnoreCase(helpText);
    }

    private String getCommandsList() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.baseUsage(true) + ParmResources.getString("COMMAND_SYNTAX") + " {" + ParmResources.getString("PARAMETER_SYNTAX") + "}" + this.sep);
            sb.append(this.baseUsage(false)).append("!$ help$!|!$he $!").append("[!$-" + CommandParserConstants.EXAMPLE + "$!|!$-" + CommandParserConstants.EXAMPLE_S + "$!]" + this.sep);
            sb.append(this.baseUsage(false)).append("!$ help$!|!$he $!").append(ParmResources.getString("COMMAND_SYNTAX")).append(" [!$-" + CommandParserConstants.SYNTAX + "$!|!$-" + CommandParserConstants.SYNTAX_S + "$!] [!$-" + CommandParserConstants.EXAMPLE + "$!|!$-" + CommandParserConstants.EXAMPLE_S + "$!]" + this.sep);
            sb.append(this.sep + "  " + ParmResources.format("USAGE_DETAIL", this.constants.getBaseCommandName()) + this.sep + this.sep);
            sb.append("  " + ParmResources.getString("COMMAND") + this.sep);
            Map<String, Map<String, StandardParameter>> sortedMap = this.constants.getCommandModel() instanceof LinkedHashMap ? this.constants.getCommandModel() : new TreeMap<String, Map<String, StandardParameter>>(this.constants.getCommandModel());
            for (String command : sortedMap.keySet()) {
                String short_name = this.constants.getShortCommand(command);
                sb.append("    !$" + command + "$!");
                if (short_name != null) {
                    sb.append("|!$" + short_name + "$!");
                }
                sb.append(this.sep);
                sb.append(StringWrapper.wrapString(this.help.apply(this.constants.getConstantName(command)), this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    "));
                sb.append(this.sep);
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return ParmResources.getString("NO_HELP");
        }
        String replace = sb.toString();
        replace = replace.replaceAll("\\!\\$", "\u001b[33m");
        replace = replace.replaceAll("\\$\\!", "\u001b[0m");
        return replace;
    }

    private String getCommandSyntax(String command) {
        StringBuilder sb = new StringBuilder();
        sb.append("Syntax: !$\n");
        if (this.constants.getBaseCommandName() != null) {
            sb.append(this.constants.getBaseCommandName() + "$!|!$" + this.constants.getBaseCommandShortName());
        }
        if (this.constants.getCommandModel().size() > 1) {
            sb.append(" " + command + "$!");
            try {
                if (this.constants.getShortCommand(command) != null) {
                    sb.append("|!$" + this.constants.getShortCommand(command) + "$!");
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().toString()).log(Level.INFO, this.getClass().toString(), e);
            }
        }
        Map<String, StandardParameter> params = this.constants.getCommandModel().get(command);
        if (this.constants.getCommandModel().get(command) != null && params instanceof LinkedHashMap) {
            params = this.constants.getCommandModel().get(command);
        } else if (params != null && params.size() > 0) {
            params = this.sortByValue(this.constants.getCommandModel().get(command));
        }
        if (params != null && params.size() != 0) {
            for (String param : params.keySet()) {
                StandardParameter sp = params.get(param);
                if (!sp.isPositional()) {
                    sb.append(" [!$-" + param + "$!");
                    String shortParam = this.constants.getShortParam(param);
                    if (ModelUtil.hasLength(shortParam)) {
                        sb.append("|!$-" + shortParam + "$!");
                    }
                } else {
                    sb.append(" <!$" + param + "$!");
                }
                if (params.get(param).isRequired()) {
                    sb.append(" {" + ParmResources.getString("REQUIRED_SYNTAX") + "}");
                }
                if (this.constants.showDefaultInHelp() && params.get(param).getDefault() != null) {
                    sb.append(" (" + ParmResources.getString("DEFAULT_SYNTAX") + ":" + params.get(param).getDefault() + ")");
                }
                if (params.get(param).getAllowed() != null) {
                    sb.append(" {" + params.get(param).getAllowed().replaceAll(",", "|") + "}");
                }
                if (!sp.isPositional()) {
                    sb.append("]");
                    continue;
                }
                sb.append(">");
            }
        } else {
            sb.append(" " + ParmResources.getString("COMMAND_SYNTAX")).append(" [!$-" + CommandParserConstants.SYNTAX + "$!|!$-" + CommandParserConstants.SYNTAX_S + "$!] [!$-" + CommandParserConstants.EXAMPLE + "$!|!$-" + CommandParserConstants.EXAMPLE_S + "$!]" + this.sep);
        }
        String replace = StringWrapper.wrapString(sb.toString(), this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    ");
        replace = replace.replaceAll("\\!\\$", "\u001b[33m");
        replace = replace.replaceAll("\\$\\!", "\u001b[0m");
        return replace + this.sep;
    }

    private String getCommandUsage(String command) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sep + "  " + ParmResources.getString("USAGE") + this.sep);
        sb.append("  !$");
        if (this.constants.getBaseCommandName() != null) {
            sb.append(this.constants.getBaseCommandName() + "$!|!$" + this.constants.getBaseCommandShortName());
        }
        if (this.constants.getCommandModel().size() > 0) {
            if (!command.equals(this.constants.getBaseCommandName()) && !command.equals(this.constants.getBaseCommandShortName())) {
                sb.append(" " + command + "$!");
                try {
                    if (this.constants.getShortCommand(command) != null) {
                        sb.append("|!$" + this.constants.getShortCommand(command) + "$!");
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().toString()).log(Level.INFO, this.getClass().toString(), e);
                }
            }
        } else {
            sb.append("$!");
        }
        if (this.constants.getCommandModel().get(command) != null && this.constants.getCommandModel().get(command).size() > 0) {
            sb.append(" " + ParmResources.getString("PARAMETER_SYNTAX"));
        }
        sb.append(this.sep);
        sb.append(StringWrapper.wrapString(this.help.apply(this.constants.getConstantName(command)), this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    "));
        if (!this.help.apply(this.constants.getConstantName(command + "_US")).equals("!" + this.constants.getConstantName(command + "_US") + "!")) {
            sb.append(this.sep);
            sb.append(StringWrapper.wrapString(this.help.apply(this.constants.getConstantName(command + "_US")), this._ctx.getIntegerProperty("script.runner.setlinesize", 80), "    "));
        }
        sb.append(this.sep);
        String replace = sb.toString();
        replace = replace.replaceAll("\\!\\$", "\u001b[33m");
        replace = replace.replaceAll("\\$\\!", "\u001b[0m");
        return replace;
    }

    private Map<String, StandardParameter> sortByValue(Map<String, StandardParameter> hm) {
        LinkedList<Map.Entry<String, StandardParameter>> list = new LinkedList<Map.Entry<String, StandardParameter>>(hm.entrySet());
        Collections.sort(list, new SortMap());
        LinkedHashMap<String, StandardParameter> temp = new LinkedHashMap<String, StandardParameter>();
        for (Map.Entry entry : list) {
            temp.put((String)entry.getKey(), (StandardParameter)entry.getValue());
        }
        return temp;
    }
}

