/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowUsercmd
implements IShowCommand {
    private static final String[] SHOWUSERCMD = new String[]{"user"};

    @Override
    public String[] getShowAliases() {
        return SHOWUSERCMD;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowUsercmd(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowUsercmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx != null && ctx.getProperty("script.runner.PRELIM_AUTH") != null && Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE)).booleanValue()) {
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", "SYS")));
            } else if (conn == null) {
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", "")));
            } else {
                ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", this.userNoDualUsed(conn))));
            }
            ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic("\n"));
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String userNoDualUsed(Connection conn) {
        retVal = null;
        if (conn != null && conn instanceof OracleConnection) {
            stmt = null;
            amILocked = LockManager.lock(conn);
            try {
                if (!amILocked) ** GOTO lbl48
                stmt = conn.prepareCall(new StringBuffer("DECLARE \n").append("CHECKONE VARCHAR2(1000):=NULL; \n").append("BEGIN \n").append(" BEGIN \n").append("   CHECKONE:=USER; \n").append(" EXCEPTION \n").append(" WHEN OTHERS THEN \n").append("  CHECKONE :=NULL; \n").append(" END; \n").append(" :CHECKFORONE:=CHECKONE; \n").append("END;").toString());
                stmt.registerOutParameter(1, 12);
                stmt.executeUpdate();
                retVal = stmt.getString(1);
                if (!stmt.wasNull()) ** GOTO lbl48
                retVal = null;
            }
            catch (Exception e) {
                retVal = null;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        Logger.ignore(this.getClass(), e);
                    }
                }
                if (amILocked) {
                    LockManager.unlock(conn);
                }
            }
        } else if (conn != null && conn.getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            stmt = null;
            amILocked = LockManager.lock(conn);
            try {
                if (amILocked && (rset = (stmt = conn.prepareStatement("select sys_context('USERENV', 'SESSION_USER') from dual")).executeQuery()).next()) {
                    retVal = rset.getString(1);
                }
            }
            catch (Exception e) {
                retVal = null;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        Logger.ignore(this.getClass(), e);
                    }
                }
                if (amILocked) {
                    LockManager.unlock(conn);
                }
            }
        }
        if (retVal == null) {
            retVal = "NULL";
        }
        return retVal;
    }
}

