/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowInstance
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline {
    String sql = "select     s.username username,     i.instance_name instance_name,     i.host_name host_name,     to_char(s.sid) sid,     (select substr(banner, instr(banner, 'Release ')+8,10) from v$version where rownum = 1) version,    to_char(startup_time, 'YYYYMMDD') startup_day from     v$session s,    v$instance i,    v$process p where     s.paddr = p.addr and     sid = (select sid from v$mystat where rownum = 1)";

    @Override
    public String[] getShowAliases() {
        return new String[]{"instance"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        try {
            String username = conn.getMetaData().getUserName();
            if ("SYS".equalsIgnoreCase(username) || "SYSTEM".equalsIgnoreCase(username)) {
                ctx.write("Instance \"local\"" + Show.m_lineSeparator);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DBUtil dbUtil = DBUtil.getInstance(conn);
        List<List<?>> results = dbUtil.executeReturnListofList(this.sql, null);
        try {
            if (conn instanceof OracleConnection) {
                if (results != null && results.size() == 2) {
                    for (int i = 0; i < results.get(0).size(); ++i) {
                        ctx.write(results.get(0).get(i).toString() + " " + results.get(1).get(i).toString() + "\n");
                    }
                } else {
                    ctx.write("Instance \"local\"" + Show.m_lineSeparator);
                }
            } else {
                ctx.write("Instance \"local\"" + Show.m_lineSeparator);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

