/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.util.Properties;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnectPlugin;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Krb5CCNameProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Krb5ConfigProperty;

public class KerberosConnectPlugin
extends AbstractConnectPlugin {
    private static final String KRB5_CONF = "java.security.krb5.conf";

    public KerberosConnectPlugin(ConnectorArgs args) {
        super(args);
    }

    @Override
    public Properties getAdditionalProperties() {
        Properties filteredProps = new Properties();
        String krb5_config = this.properties.getValueOf(Krb5ConfigProperty.KRB5_CONFIG);
        String krb5ccname = this.properties.getValueOf(Krb5CCNameProperty.KRB5CCNAME);
        String currConf = System.getProperty(KRB5_CONF);
        if (currConf == null || currConf.equals("")) {
            if (krb5_config != null && !krb5_config.equals("")) {
                System.setProperty(KRB5_CONF, krb5_config);
            } else {
                String confEnv = System.getenv("KRB5_CONFIG");
                if (confEnv != null && !confEnv.equals("")) {
                    System.setProperty(KRB5_CONF, confEnv);
                } else {
                    System.clearProperty(KRB5_CONF);
                }
            }
        }
        filteredProps.put("oracle.net.authentication_services", "(KERBEROS5)");
        filteredProps.put("oracle.net.kerberos5_mutual_authentication", Boolean.TRUE);
        if (krb5ccname != null && !krb5ccname.equals("")) {
            filteredProps.put("oracle.net.kerberos5_cc_name", krb5ccname);
        } else {
            String ccEnv = System.getenv("KRB5CCNAME");
            if (ccEnv != null && !ccEnv.equals("")) {
                filteredProps.put("oracle.net.kerberos5_cc_name", ccEnv);
            }
        }
        return filteredProps;
    }
}

