/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.AbstractConnectionProcessor;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.DisconnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class DisconnectCommand
extends CommandListener
implements IHelp {
    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ArrayList errorMessages = new ArrayList();
        Parser parser = new Parser(this.createType(), ctx.getEnvironment());
        Optional<ParsedCommand> parsedCommand = parser.parse(SQLPLUSUtil.cleanCommand(cmd).getSql(), errorMessages::add);
        if (parsedCommand.isPresent()) {
            DisconnectCommandProcessor processor = new DisconnectCommandProcessor(ctx, cmd);
            processor.disconnect(conn, cmd);
        }
        for (String errorMessage : errorMessages) {
            ctx.write(errorMessage + "\n");
        }
        return true;
    }

    @Override
    public String getCommand() {
        return "disconnect";
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        HelpPages helpPages = new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).addHelpContainerFor(this).addPages(new CommandPageAssemblers(this.createType(), new Type[0])).build();
        return helpPages.get(pagePath);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }

    private Type createType() {
        return Factory.type(TypeId.DISCONNECT).name("disc'onnect").build();
    }

    private class DisconnectCommandProcessor
    extends AbstractConnectionProcessor {
        DisconnectCommandProcessor(ScriptRunnerContext ctx, ISQLCommand cmd) {
            super(ctx, cmd);
        }

        void disconnect(Connection conn, ISQLCommand cmd) {
            ConnectionContext connectionContext = this.ctx.getService(ConnectionContext.class);
            ConnectorType currentConnectorType = connectionContext.getCurrentConnectorType();
            if (currentConnectorType != null) {
                this.processDisconnect(conn, cmd, currentConnectorType);
            }
            connectionContext.setCurrentConnectorType(null);
            this.ctx.setCurrentConnection(null);
        }

        private void processDisconnect(Connection connection, ISQLCommand cmd, ConnectorType connectorType) {
            if (connection != null && !SQLPLUSUtil.isConnectionClosed(connection)) {
                if (this.ctx.getProperty("script.runner.PRELIM_AUTH") == null || ((Boolean)this.ctx.getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.FALSE)) {
                    this.disconnectMessage(connection, this.ctx);
                    SQLPLUSUtil.commitConnection(connection);
                }
                this.disposeConnection(connection, connectorType.createDisconnector(DisconnectorArgs.create(connection, this.ctx, cmd)));
            }
            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), "");
            this.ctx.putProperty("script.runner.sqlplus.nolog", true);
        }

        private void disconnectMessage(Connection conn, ScriptRunnerContext src) {
            if (conn != null && !SQLPLUSUtil.isConnectionClosed(conn)) {
                String localOVersion = src.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
                if (src.getProperty("script.runner.sqlplus.silent") == null ^ src.getProperty("script.runner.sqlcl.optionx") != null) {
                    src.write(ScriptRunnerDbArb.format("DISCONNECTED_FROM", localOVersion) + "\n");
                    try {
                        src.getOutputStream().flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static enum TypeId implements Id
    {
        DISCONNECT;

    }
}

