/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeColumnDetails;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeException;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeJDBCToOracle;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableCreationInfo;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableDetails;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeUtil;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.CopyToOracleHint;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class BridgeTableDef {
    String _tableName = null;
    String _targetTableName = null;
    String _targetConnName = null;
    String _query = null;
    ArrayList<String> _queries = new ArrayList();
    String _sourceConnName = null;
    Connection _targetConn = null;
    Connection _sourceConn = null;
    Connection _defaultConn = null;
    boolean _isAppend = false;
    boolean _isReplace = false;
    boolean _isTruncate = false;
    boolean _isSkip = false;
    boolean _ZeroLengthStringToSpace = true;
    ScriptRunnerContext m_ctx = null;
    boolean _db12cFeatures = false;
    final int batchSize = 1000;
    public static final String BRIDGEREPLACEKEY = "BRIDGEREPLACEKEY";

    public BridgeTableDef(String tableName, Connection targetConn, String query, Connection sourceConn, boolean isAppend, boolean isReplace, boolean isTruncate, boolean isSkip) {
        this._tableName = tableName;
        this._query = query;
        this._isAppend = isAppend;
        this._isReplace = isReplace;
        this._isTruncate = isTruncate;
        this._isSkip = isSkip;
        this._targetConn = targetConn;
        this._sourceConn = sourceConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BridgeTableCreationInfo createTable() throws BridgeException {
        BridgeTableCreationInfo result = new BridgeTableCreationInfo(this.getTableName());
        this.initializeConnections();
        ResultSet rs = null;
        DBUtil sourceDBUtil = null;
        CopyToOracleHint hint = null;
        boolean moveData = true;
        try {
            this.lockConnections(this.getSourceConnection(), this.getTargetConnection());
            this.initializeConnection(this.getTargetConnection());
            sourceDBUtil = DBUtil.getInstance(this.getSourceConnection());
            this.processDynamicSQLToInlineList();
            boolean isLoop = this.processLoopSQLToMultipleQueries();
            boolean isOracle = this.isOracle(this.getSourceConnection());
            if (this._isTruncate) {
                this.truncate(this.getTargetTableName());
            }
            for (String query : this.getQueries()) {
                block26: {
                    try {
                        if (this.isInterupted()) {
                            throw new InterruptedException();
                        }
                        hint = new CopyToOracleHint(query);
                        query = hint.queryWithoutHint();
                        rs = this.getResultSet(sourceDBUtil, query);
                        BridgeTableDetails tableDetails = this.createTableDetails(rs.getMetaData(), this.getSourceConnection().getMetaData(), isOracle, hint);
                        boolean tableCreated = false;
                        ArrayList<String> autoColumns = new ArrayList();
                        if (this.isInterupted()) {
                            throw new InterruptedException();
                        }
                        try {
                            this.createTableAction(tableDetails);
                            tableCreated = true;
                        }
                        catch (Exception e) {
                            if (this._isSkip) {
                                moveData = false;
                                result.tableAlreadyExist(true);
                            }
                            if (!this._isAppend && !this._isTruncate) throw e;
                            moveData = true;
                            result.tableAlreadyExist(true);
                        }
                        if (tableCreated) {
                            autoColumns = this.autoColumnsCalculate(tableDetails, rs);
                        }
                        if (moveData) {
                            int numRows = this.insertData(tableDetails, rs);
                            result.setNumRows(numRows);
                            this.commitData(this._targetConn);
                            result.setCommit(true);
                        }
                        if (tableDetails.hasConstraints()) {
                            try {
                                this.createConstraints(tableDetails);
                            }
                            catch (SQLException e) {
                                result.setConstraintException(e);
                            }
                        }
                        if (!tableCreated) break block26;
                        this.addAutonumber(autoColumns);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rs);
                        throw throwable;
                        return result;
                    }
                }
                DBUtil.closeResultSet(rs);
            }
        }
        catch (IOException | InterruptedException | SQLException | BridgeException e) {
            try {
                Connection targetConn = this.getTargetConnection();
                if (targetConn == null) {
                    throw new BridgeException(MessageFormat.format(Messages.getString("BRIDGE_TABLE_CREATION_FAILED_NO_CONNECTION"), this.getTableFullName(hint)) + " \n" + e.getLocalizedMessage());
                }
                this.rollbackChanges(targetConn);
                throw new BridgeException(MessageFormat.format(Messages.getString("BRIDGE_TABLE_CREATION_FAILED_AND_ROLLBACK_OK"), this.getTableFullName(hint)) + " \n" + e.getLocalizedMessage(), e);
            }
            catch (SQLException rbException) {
                throw new BridgeException(MessageFormat.format(Messages.getString("BRIDGE_TABLE_CREATION_FAILED_AND_ROLLBACK_FAILED"), this.getTableFullName(hint)) + " \n" + e.getLocalizedMessage(), e);
            }
        }
        finally {
            try {
                DBUtil.closeResultSet(rs);
            }
            catch (Throwable t) {
                throw new BridgeException(Messages.getString("BRIDGE_TABLE_CREATION_FAILED_TO_CLOSE_RS"), t);
            }
            this.unlockConnections(this.getSourceConnection(), this.getTargetConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> autoColumnsCalculate(BridgeTableDetails tableDetails, ResultSet rs) {
        ArrayList<BridgeColumnDetails> oracleColumns = tableDetails.getColumnDetails();
        ArrayList<String> autoColumns = new ArrayList<String>();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < oracleColumns.size(); ++i) {
                if (!oracleColumns.get(i).getTargetDataTypeStr().toUpperCase(Locale.US).startsWith("NUMBER") || !rsmd.isAutoIncrement(i + 1)) continue;
                autoColumns.add(this.createValidIdentifier(rsmd.getColumnName(i + 1), "part"));
            }
        }
        catch (SQLException se) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("BRIDGE_ERROR_FOR_LOG"), se);
        }
        return autoColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAutonumber(ArrayList<String> autoColumns) throws SQLException {
        String autoTableName = this.getTargetTableName();
        CallableStatement stmt = null;
        if (!this.isOracle(this._targetConn)) {
            return;
        }
        for (String thisColumn : autoColumns) {
            try {
                stmt = this._targetConn.prepareCall("Declare \n  pragma autonomous_transaction; \n  e_already_exists EXCEPTION; \n  PRAGMA EXCEPTION_INIT (e_already_exists, -955); \n  e_trig_already_exists EXCEPTION; \n  PRAGMA EXCEPTION_INIT (e_trig_already_exists, -4081); \n  tablel varchar2(100):= :b1; \n  columnl varchar2(100) := :b2; \n  eimmediate varchar2(4000 byte) := NULL; \n  postfix varchar2(100) := NULL; \n  seqname varchar2(200) := NULL; \n  trigname varchar2(200) := NULL; \n  seqcreated boolean := false; \n  trigcreated boolean := false; \n  outputl varchar2(200) := 'OK'; \n  FUNCTION truncateStringByteSize(p_work VARCHAR2, p_bsize NUMBER) RETURN VARCHAR2 \n  IS \n    v_work VARCHAR2(4000); \n    v_bsize NUMBER(10); \n  BEGIN \n    IF LENGTHB(p_work) <= p_bsize THEN \n      return p_work; \n    END IF; \n    v_work := p_work; \n    v_work := SUBSTRB(v_work, 1, p_bsize); \n    WHILE INSTRC(p_work, v_work , 1, 1) <> 1 LOOP -- a character has been cut in half or in 2/3 or 3/4 by substrb (multibyte can have up to 4 bytes)  \n    --note each left over corrupt byte can be a single character \n      BEGIN \n        v_bsize := LENGTHB(v_work); \n        v_work := SUBSTRB(v_work, 1, v_bsize-1); \n      END; \n    END LOOP;  \n    return v_work; \n  END; \n  FUNCTION get_name(p_work VARCHAR2, p_suffix VARCHAR2) RETURN VARCHAR2 \n  IS \n    p_maxlen NUMBER(38,0) := 30; \n    v_suflen NUMBER := LENGTHB(p_suffix); \n    v_truncamount NUMBER; \n  BEGIN \n    IF LENGTHB(p_work) < p_maxlen - v_suflen THEN \n      RETURN p_work || p_suffix; \n    END IF; \n    v_truncamount := LENGTHB(p_work) + v_suflen - p_maxlen; \n    RETURN truncateStringByteSize(p_work, LENGTHB(p_work)-v_truncamount) || p_suffix; \n  END get_name; \nbegin \n  for n in 0 .. 100 \n  loop \n    begin \n      if (n=0)  \n      then \n        postfix:='_'||'SEQ'; \n      else \n        postfix:='_'||n||'SEQ'; \n      end if; \n      seqname:=get_name(tablel || '_' || columnl ,postfix); \n      eimmediate := 'CREATE SEQUENCE  ' || seqname || chr(10) ||  \n      '  MINVALUE 1 MAXVALUE 999999999999999999999999 INCREMENT BY 1  NOCYCLE'; \n      -- thesequencewithseqnamein; \n      execute immediate eimmediate; \n      seqcreated := true; \n      --just skip already exists 3exception  \n    Exception  \n      when  e_already_exists then \n      null; \n    end; \n    if (seqcreated = true)  \n    then \n      for t in 0 .. 100 \n        loop \n        begin \n        if (t=0)  \n        then \n          postfix:='_'||'TRIG'; \n        else \n          postfix:='_'||t||'TRIG'; \n        end if; \n        trigname:=get_name(tablel||'_'||columnl,postfix); \n        --execute immediate  \n        eimmediate := \n'CREATE TRIGGER '||trigname||' BEFORE INSERT OR UPDATE ON ' || tablel || chr(10) || \n'FOR EACH ROW' || chr(10) || \n'DECLARE ' || chr(10) || \n'v_newVal NUMBER(12) := 0;' || chr(10) || \n'v_incval NUMBER(12) := 0;' || chr(10) || \n'BEGIN' || chr(10) || \n'  IF INSERTING AND :new.'|| columnl ||' IS NULL THEN' || chr(10) || \n'    SELECT  '||seqname||'.NEXTVAL INTO v_newVal FROM DUAL;' || chr(10) || \n'    -- If this is the first time this table have been inserted into (sequence == 1)' || chr(10) || \n'    IF v_newVal = 1 THEN ' || chr(10) || \n'      --get the max indentity value from the table' || chr(10) || \n'      SELECT NVL(max('||columnl||'),0) INTO v_newVal FROM '||tablel||';' || chr(10) || \n'      v_newVal := v_newVal + 1;' || chr(10) || \n'      --set the sequence to that value' || chr(10) || \n'      LOOP' || chr(10) || \n'           EXIT WHEN v_incval>=v_newVal;' || chr(10) || \n'           SELECT '||seqname||'.nextval INTO v_incval FROM dual;' || chr(10) || \n'      END LOOP;' || chr(10) || \n'    END IF;' || chr(10) || \n'   -- assign the value from the sequence to emulate the identity column' || chr(10) || \n'   :new.'||columnl||' := v_newVal;' || chr(10) || \n'  END IF;' || chr(10) || \n'END;'; \n        execute immediate eimmediate; \n        trigcreated := true; \n        exit; \n        --just skip already exists 3exception  \n        Exception  \n          when  e_already_exists then \n          null; \n          when e_trig_already_exists then \n            null; \n        end; \n      END LOOP;   \n      exit; \n    end if; \n  end loop; \n  if (seqcreated = false) \n  then  \n    outputl:= 'create sequence '||seqname||' failed:'; \n  end if; \n  if (trigcreated = false) \n  then \n    if (outputl = 'OK') \n    then \n      outputl := null; \n    end if; \n    outputl:= outputl || 'create trigger '||trigname||' failed'; \n  end if; \n  :op := outputl; \nend; ");
                stmt.setString(1, autoTableName);
                stmt.setString(2, thisColumn);
                stmt.registerOutParameter(3, 12);
                stmt.executeUpdate();
                String amIOK = stmt.getString(3);
                if (amIOK != null && amIOK.equals("OK")) continue;
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, amIOK == null ? "null" : amIOK);
            }
            catch (SQLException se) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(Messages.getString("AUTO_NUMBER_ERROR"), this._targetConn.getSchema(), autoTableName.toUpperCase(), se.getLocalizedMessage()));
            }
            finally {
                if (stmt == null) continue;
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void truncate(String tableName) {
        DBUtil.getInstance(this._targetConn).execute("TRUNCATE TABLE " + tableName);
    }

    private Object getTableFullName(CopyToOracleHint hint) {
        String sourceName = null;
        if (hint != null) {
            sourceName = hint.getFullName();
        }
        if (sourceName == null) {
            sourceName = this.getTableName();
        }
        return sourceName;
    }

    private void createConstraints(BridgeTableDetails tableDetails) throws SQLException {
        DBUtil dbUtil = DBUtil.getInstance(this._targetConn);
        String constraintSQL = tableDetails.getConstraintDDL();
        dbUtil.execute(constraintSQL);
        SQLException sqlex = dbUtil.getLastException();
        if (sqlex != null) {
            throw sqlex;
        }
    }

    private ResultSet getResultSet(DBUtil sourceDBUtil, String query) throws SQLException {
        return this.querySource(sourceDBUtil, query);
    }

    private void rollbackChanges(Connection conn) throws SQLException {
        conn.rollback();
    }

    private void lockConnections(Connection sourceConnection, Connection targetConnection) throws BridgeException {
        if (!LockManager.lock(targetConnection)) {
            throw new BridgeException(Messages.getString("BRIDGE_TARGET_CONNECTION_LOCK_FAILED"));
        }
        if (!LockManager.lock(sourceConnection)) {
            throw new BridgeException(Messages.getString("BRIDGE_SOURCE_CONNECTION_LOCK_FAILED"));
        }
    }

    private void unlockConnections(Connection sourceConnection, Connection targetConnection) {
        if (sourceConnection != null) {
            LockManager.unlock(sourceConnection);
        }
        if (targetConnection != null) {
            LockManager.unlock(targetConnection);
        }
    }

    private void initializeConnection(Connection conn) throws SQLException {
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
    }

    private void initializeConnections() {
        if (this._targetConn == null) {
            this._targetConn = this.getDefaultConn();
        }
        if (this._sourceConn == null) {
            this._sourceConn = this.getDefaultConn();
        }
    }

    private void commitData(Connection targetConn) throws SQLException {
        if (!this.isTempTable()) {
            targetConn.commit();
        }
    }

    private String createValidIdentifier(String columnName, String string) {
        return BridgeUtil.createValidIdentifier(columnName, string);
    }

    private boolean isOracle(Connection conn) {
        try {
            return conn != null && conn.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") != -1;
        }
        catch (SQLException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processLoopSQLToMultipleQueries() throws SQLException {
        boolean isLoop;
        block4: {
            String query;
            block3: {
                isLoop = false;
                query = this.getQuerySQL();
                int start = this.getQuerySQL().toLowerCase().indexOf("{");
                int end = this.getQuerySQL().indexOf("}");
                if (start == -1) break block3;
                isLoop = true;
                String dynamicSQL = this.getQuerySQL().substring(start + 1, end);
                ResultSet rs = null;
                DBUtil dbutil = null;
                try {
                    dbutil = DBUtil.getInstance(this.getTargetConnection());
                    rs = dbutil.executeOracleQuery(dynamicSQL, null);
                    int type = rs.getMetaData().getColumnType(1);
                    StringBuffer sb = new StringBuffer();
                    while (rs.next()) {
                        if (type != 12) continue;
                        String find = "{" + dynamicSQL + "}";
                        int replaceIndexStart = this.getQuerySQL().indexOf(find);
                        int replaceIndexEnd = replaceIndexStart + find.length();
                        StringBuffer replacesb = new StringBuffer(this.getQuerySQL());
                        replacesb.delete(replaceIndexStart, replaceIndexEnd);
                        replacesb.insert(replaceIndexStart, rs.getString(1));
                        String newQuery = replacesb.toString();
                        newQuery = this.processBinds(rs, newQuery);
                        this._queries.add(newQuery);
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rs);
                    throw throwable;
                }
                DBUtil.closeResultSet(rs);
                break block4;
            }
            this._queries.add(query);
        }
        return isLoop;
    }

    private String processBinds(ResultSet rs, String newQuery) throws SQLException {
        int columNum = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= columNum; ++i) {
            String aliasName = rs.getMetaData().getColumnLabel(i);
            if (!aliasName.toLowerCase().startsWith("sqldev")) continue;
            newQuery = BridgeTableDef.replace(newQuery, ":" + aliasName, rs.getString(i));
        }
        return newQuery;
    }

    public static String replace(String aInput, String aOldPattern, String aNewPattern) {
        if (aOldPattern.equals("")) {
            throw new IllegalArgumentException(Messages.getString("BRIDGE_TABLE_ILLEGAL_ARG"));
        }
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = aInput.indexOf(aOldPattern, startIdx)) >= 0) {
            result.append(aInput.substring(startIdx, idxOld));
            result.append(aNewPattern);
            startIdx = idxOld + aOldPattern.length();
        }
        result.append(aInput.substring(startIdx));
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int insertData(BridgeTableDetails tableDetails, ResultSet rs) throws SQLException, IOException, BridgeException, InterruptedException {
        int count = 0;
        boolean targetConnAutoCommit = false;
        ResultSetMetaData md = rs.getMetaData();
        String insertSQL = this.getInsertSQL(md);
        Statement ps = null;
        try {
            ps = this._targetConn.prepareCall(insertSQL);
            targetConnAutoCommit = this.turnOffAutoCommit((PreparedStatement)ps);
            while (rs.next()) {
                if (this.isInterupted()) {
                    throw new InterruptedException();
                }
                ArrayList<Blob> blobs = new ArrayList<Blob>();
                ArrayList<Clob> clobs = new ArrayList<Clob>();
                ArrayList<Object> binds = this.getNextBinds(rs, tableDetails, blobs, clobs);
                DBUtil.bind((PreparedStatement)ps, binds);
                ps.addBatch();
                if (++count % 1000 == 0 || blobs.size() > 0 || clobs.size() > 0) {
                    ps.executeBatch();
                }
                for (Blob b : blobs) {
                    try {
                        ((BLOB)b).freeTemporary();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                for (Clob c : clobs) {
                    try {
                        ((CLOB)c).freeTemporary();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            ps.executeBatch();
            this.resetAutoCommit((PreparedStatement)ps, targetConnAutoCommit);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    this.saveError(Level.WARNING, "Failed to close PreparedStatement after inserting data", e);
                }
            }
        }
        return count;
    }

    private void resetAutoCommit(PreparedStatement ps, boolean targetConnAutoCommit) {
        if (ps instanceof OraclePreparedStatement) {
            try {
                if (!this.isTempTable()) {
                    this._targetConn.commit();
                }
            }
            catch (SQLException e) {
                this.saveError(Level.SEVERE, "failed to reset the commit preference. could not commit", e);
            }
            try {
                this._targetConn.setAutoCommit(targetConnAutoCommit);
            }
            catch (SQLException e) {
                this.saveError(Level.SEVERE, "failed to reset the commit preference", e);
            }
        }
    }

    private boolean turnOffAutoCommit(PreparedStatement ps) throws SQLException {
        boolean currentAutoCommit = false;
        if (ps instanceof OraclePreparedStatement) {
            currentAutoCommit = this._targetConn.getAutoCommit();
            this._targetConn.setAutoCommit(false);
        }
        return currentAutoCommit;
    }

    private String getInsertSQL(ResultSetMetaData md) throws SQLException {
        int count = md.getColumnCount();
        int[] columnType = new int[count];
        String[] columnTypeName = new String[count + 1];
        StringBuffer sbInsert = new StringBuffer("INSERT INTO " + this.getTargetTableName() + " VALUES (");
        for (int i = 1; i <= count; ++i) {
            sbInsert.append(":bindname" + i + ",");
            columnType[i - 1] = md.getColumnType(i);
            columnTypeName[i - 1] = md.getColumnTypeName(i);
        }
        sbInsert.deleteCharAt(sbInsert.length() - 1);
        sbInsert.append(")");
        return sbInsert.toString();
    }

    private ArrayList<Object> getNextBinds(ResultSet rs, BridgeTableDetails tableDetails, ArrayList<Blob> blobs, ArrayList<Clob> clobs) throws SQLException, IOException {
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();
        ArrayList<Object> binds = new ArrayList<Object>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            Object o = rs.getObject(i);
            if (o == null) {
                binds.add(o);
                continue;
            }
            if (this.isOracle(this._targetConn)) {
                if (o instanceof BigInteger) {
                    NUMBER oNUM = new NUMBER((BigInteger)o);
                    binds.add(oNUM);
                    continue;
                }
                if ((tableDetails.getColumnDetails().get(i - 1).getDataTypeJDBC() == -4 || tableDetails.getColumnDetails().get(i - 1).getTargetDataTypeStr().startsWith("BLOB")) && o instanceof byte[]) {
                    binds.add(this.bindByte(o, blobs, clobs));
                    continue;
                }
                if (o instanceof Blob) {
                    binds.add(this.binbBlob(o, blobs, clobs));
                    continue;
                }
                if ((tableDetails.getColumnDetails().get(i - 1).getDataTypeJDBC() == -1 || tableDetails.getColumnDetails().get(i - 1).getTargetDataTypeStr().startsWith("CLOB")) && o instanceof String) {
                    binds.add(this.bindStringToClob(o, blobs, clobs));
                    continue;
                }
                if (o instanceof Clob) {
                    binds.add(this.bindClobToClob(o, blobs, clobs));
                    continue;
                }
                if (tableDetails.getColumnDetails().get(i - 1).getDataTypeJDBC() == -9) {
                    binds.add(this.maybeSpace(o.toString()));
                    continue;
                }
                if (tableDetails.getColumnDetails().get(i - 1).getDataTypeJDBC() == -15) {
                    binds.add(this.maybeSpace(this.rtrim(o.toString())));
                    continue;
                }
                if (tableDetails.getColumnDetails().get(i - 1).getDataTypeJDBC() == 1) {
                    binds.add(this.maybeSpace(this.rtrim(o.toString())));
                    continue;
                }
                if (tableDetails.getColumnDetails().get(i - 1).getDataTypeJDBC() == 12) {
                    binds.add(this.maybeSpace(o.toString()));
                    continue;
                }
                binds.add(o);
                continue;
            }
            binds.add(o);
        }
        return binds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Clob bindClobToClob(Object o, ArrayList<Blob> blobs, ArrayList<Clob> clobs) throws SQLException, IOException {
        CLOB c = null;
        BufferedReader binp = null;
        BufferedWriter bwr = null;
        Reader inp = null;
        Writer wr = null;
        int BUFFERSIZE = 2048;
        try {
            c = CLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
            clobs.add((Clob)c);
            c.open(1);
            inp = ((Clob)o).getCharacterStream();
            binp = new BufferedReader(inp);
            char[] myc = new char[BUFFERSIZE];
            wr = c.setCharacterStream(1L);
            int lastRead = 0;
            bwr = new BufferedWriter(wr);
            while ((lastRead = binp.read(myc, 0, myc.length)) != -1) {
                bwr.write(myc, 0, lastRead);
            }
            bwr.flush();
            this.close(inp);
            this.close(wr);
            this.close(binp);
            this.close(bwr);
        }
        catch (Throwable throwable) {
            this.close(inp);
            this.close(wr);
            this.close(binp);
            this.close(bwr);
            throw throwable;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Clob bindStringToClob(Object o, ArrayList<Blob> blobs, ArrayList<Clob> clobs) throws SQLException, IOException {
        CLOB c = null;
        BufferedWriter bwr = null;
        Writer wr = null;
        try {
            c = CLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
            clobs.add((Clob)c);
            c.open(1);
            wr = c.setCharacterStream(1L);
            boolean lastRead = false;
            bwr = new BufferedWriter(wr);
            bwr.write((String)o);
            bwr.flush();
            this.close(wr);
            this.close(bwr);
        }
        catch (Throwable throwable) {
            this.close(wr);
            this.close(bwr);
            throw throwable;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob binbBlob(Object o, ArrayList<Blob> blobs, ArrayList<Clob> clobs) throws SQLException, IOException {
        BLOB b = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        InputStream inp = null;
        OutputStream os = null;
        int BUFFERSIZE = 2048;
        try {
            b = BLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
            blobs.add((Blob)b);
            b.open(1);
            inp = ((Blob)o).getBinaryStream();
            bis = new BufferedInputStream(inp);
            byte[] buffer = new byte[BUFFERSIZE];
            os = b.setBinaryStream(1L);
            int lastRead = 0;
            bos = new BufferedOutputStream(os);
            while ((lastRead = bis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, lastRead);
            }
            bos.flush();
            this.close(inp);
            this.close(os);
            this.close(bis);
            this.close(bos);
        }
        catch (Throwable throwable) {
            this.close(inp);
            this.close(os);
            this.close(bis);
            this.close(bos);
            throw throwable;
        }
        return b;
    }

    public void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            this.saveError(Level.WARNING, "PROBLEM CLOSING", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Blob bindByte(Object o, ArrayList<Blob> blobs, ArrayList<Clob> clobs) throws SQLException, IOException {
        BLOB b = null;
        BufferedOutputStream bos = null;
        OutputStream os = null;
        try {
            b = BLOB.createTemporary((Connection)this._targetConn, (boolean)false, (int)10);
            blobs.add((Blob)b);
            b.open(1);
            byte[] buffer = (byte[])o;
            os = b.setBinaryStream(1L);
            bos = new BufferedOutputStream(os);
            bos.write(buffer, 0, buffer.length);
            bos.flush();
            this.close(os);
            this.close(bos);
        }
        catch (Throwable throwable) {
            this.close(os);
            this.close(bos);
            throw throwable;
        }
        return b;
    }

    private String maybeSpace(String in) {
        if (!this._ZeroLengthStringToSpace) {
            return in;
        }
        if (in == null) {
            return in;
        }
        if (in.equals("")) {
            return " ";
        }
        return in;
    }

    private String rtrim(String myline) {
        String retVal = null;
        if (myline == null || myline.equals("")) {
            retVal = myline;
        } else {
            boolean truncate = false;
            int i = 0;
            for (i = myline.length() - 1; i > 0 && myline.charAt(i) == ' '; --i) {
            }
            retVal = myline.substring(0, i + 1);
        }
        return retVal;
    }

    private BridgeTableDetails createTableDetails(ResultSetMetaData md, DatabaseMetaData databaseMetaData, boolean isOracle, CopyToOracleHint hint) throws SQLException {
        String primaryKeyDDL;
        String tableType;
        String tableHeader;
        BridgeTableDetails tableDetails = new BridgeTableDetails();
        tableDetails.isOracle(isOracle);
        if (this.isTempTable()) {
            tableHeader = "CREATE GLOBAL TEMPORARY TABLE ";
            tableType = " on commit delete rows ";
        } else {
            tableHeader = "CREATE TABLE ";
            tableType = " ";
        }
        StringBuffer sb = new StringBuffer(tableHeader + this.getTargetTableName() + "(");
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            int displaysize;
            String colName = md.getColumnName(i);
            colName = this.createValidIdentifier(colName, "part");
            int dataTypeJDBC = md.getColumnType(i);
            int precision = md.getPrecision(i);
            int scale = md.getScale(i);
            if (!isOracle && (displaysize = md.getColumnDisplaySize(i)) > precision) {
                precision = displaysize;
            }
            String dataType = BridgeJDBCToOracle.map(isOracle, precision, scale, dataTypeJDBC, this.getDb12cFeatures());
            tableDetails.addColumn(new BridgeColumnDetails(dataType.toUpperCase(), precision, scale, dataTypeJDBC));
            String amINull = " NULL ";
            if (md.isNullable(i) == 0) {
                amINull = " NOT NULL ";
            }
            sb.append(colName + " " + dataType + amINull + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        sb.append(tableType);
        String createTableSQL = sb.toString();
        if (hint.isCopyToOracle() && (primaryKeyDDL = this.createPrimaryKeyDDL(this._sourceConn.getMetaData(), hint.getCatalog(), hint.getSchema(), hint.getTable())) != null) {
            tableDetails.setPKeyDDL(primaryKeyDDL);
        }
        tableDetails.setDDL(createTableSQL);
        return tableDetails;
    }

    private String createPrimaryKeyDDL(DatabaseMetaData dbMetadata, String catalog, String schema, String tableName) {
        try {
            ResultSet rsKey = dbMetadata.getPrimaryKeys(catalog, schema, tableName);
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            sb.append("(");
            while (rsKey.next()) {
                String primaryKey = rsKey.getString("COLUMN_NAME");
                sb.append(primaryKey);
                if (first) {
                    first = false;
                    continue;
                }
                sb.append(",");
            }
            sb.append(")");
            if (first) {
                return null;
            }
            return "ALTER TABLE " + tableName + " ADD PRIMARY KEY" + sb.toString();
        }
        catch (SQLException e) {
            this.saveError(Level.WARNING, "Failed to generate Primary Key DDL", e);
            return null;
        }
    }

    private void createTableAction(BridgeTableDetails tableDetails) throws SQLException {
        DBUtil dbUtil = DBUtil.getInstance(this._targetConn);
        String createTableSQL = tableDetails.getDDL();
        if (this._isReplace) {
            String dropTableSQL = "DROP TABLE " + this.getTargetTableName();
            try {
                dbUtil.execute(dropTableSQL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._isTruncate) {
            String truncateTableSQL = "TRUNCATE TABLE " + this.getTargetTableName();
            try {
                dbUtil.execute(truncateTableSQL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SQLException sqlex = dbUtil.getLastException();
        dbUtil.execute(createTableSQL);
        sqlex = dbUtil.getLastException();
        if (sqlex != null) {
            throw sqlex;
        }
    }

    private String getTargetTableName() {
        if (this._targetTableName == null) {
            this._targetTableName = this.createValidIdentifier(this.getTableName(), "object");
        }
        if (this._targetTableName != null && this._targetTableName.startsWith("#")) {
            return this._targetTableName.substring(1);
        }
        return this._targetTableName;
    }

    private boolean isTempTable() {
        this.getTargetTableName();
        return this._targetTableName != null && this._targetTableName.startsWith("#");
    }

    private ResultSet querySource(DBUtil sourceDBUtil, String query) throws SQLException {
        SQLException e;
        ResultSet rs = null;
        rs = sourceDBUtil.executeQuery(query, new HashMap());
        if (rs == null && (e = sourceDBUtil.getLastException()) != null) {
            throw e;
        }
        return rs;
    }

    private String getQuerySQL() {
        return this._query;
    }

    private void setQuerySQL(String query) {
        this._query = query;
    }

    private Connection getDefaultConn() {
        return this._defaultConn;
    }

    public void setDefaultConn(Connection conn) {
        this._defaultConn = conn;
    }

    public void drop() {
        DBUtil.getInstance(this._targetConn).execute("DROP TABLE " + this.getTargetTableName());
    }

    public void setDb12cFeatures(boolean db12cFeaturesIn) {
        this._db12cFeatures = db12cFeaturesIn;
    }

    public boolean getDb12cFeatures() {
        return this._db12cFeatures;
    }

    public void setScriptRunnerContext(ScriptRunnerContext ctx) {
        this.m_ctx = ctx;
    }

    private boolean isInterupted() {
        if (this.m_ctx != null) {
            return this.m_ctx.getExited();
        }
        return false;
    }

    public Connection getTargetConnection() {
        return this._targetConn;
    }

    public Connection getSourceConnection() {
        return this._sourceConn;
    }

    private ArrayList<String> getQueries() {
        return this._queries;
    }

    private String getTableName() {
        return this._tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDynamicSQLToInlineList() throws SQLException {
        int start = this.getQuerySQL().indexOf("({");
        int end = this.getQuerySQL().indexOf("}");
        if (start != -1) {
            ResultSet rs;
            block6: {
                String dynamicSQL = this.getQuerySQL().substring(start + 2, end);
                rs = null;
                DBUtil dbutil = null;
                try {
                    dbutil = DBUtil.getInstance(this.getTargetConnection());
                    rs = dbutil.executeOracleQuery(dynamicSQL, null);
                    int type = rs.getMetaData().getColumnType(1);
                    StringBuffer sb = new StringBuffer();
                    while (rs.next()) {
                        if (type == 12 || type == 1) {
                            sb.append("'" + rs.getString(1) + "',");
                            continue;
                        }
                        sb.append(rs.getString(1) + ",");
                    }
                    if (sb.length() > 0) {
                        sb.deleteCharAt(sb.length() - 1);
                        String find = "{" + dynamicSQL + "}";
                        int replaceIndexStart = this.getQuerySQL().indexOf(find);
                        int replaceIndexEnd = replaceIndexStart + find.length();
                        StringBuffer replacesb = new StringBuffer(this.getQuerySQL());
                        replacesb.delete(replaceIndexStart, replaceIndexEnd);
                        replacesb.insert(replaceIndexStart, sb.toString());
                        this.setQuerySQL(replacesb.toString());
                        break block6;
                    }
                    this.saveError(Level.SEVERE, "Dynamic SQL returned no rows", null);
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rs);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rs);
        }
    }

    private void saveError(Level level, String customMsg, Throwable t) {
        Logger.getLogger(this.getClass().getName()).log(level, customMsg, t.getLocalizedMessage());
    }
}

