/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.util.Service;

@Restricted(level=Restricted.Level.R4)
public class TransparentGateway
extends CommandListener {
    private Set<String> links;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static HashMap<Connection, Boolean> autoDbLinksAtConnection = new HashMap();

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.cleanLinks(conn, ctx);
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (!Boolean.TRUE.equals(autoDbLinksAtConnection.get(conn))) {
            return;
        }
        if (cmd.getStmtType() != SQLCommand.StmtType.G_C_SQL && cmd.getStmtType() != SQLCommand.StmtType.G_C_PLSQL) {
            return;
        }
        String sql = cmd.getSql();
        if (sql.indexOf(64) < 0) {
            return;
        }
        List src = Lexer.parse((String)sql);
        boolean linkIsNext = false;
        int adjustPos = 0;
        for (LexerToken t : src) {
            String token = t.content;
            if ("@".equals(token)) {
                linkIsNext = true;
                continue;
            }
            if (linkIsNext) {
                String scrambled = token.toUpperCase();
                if (token.charAt(0) == '\"') {
                    token = token.substring(1, token.length() - 1);
                    scrambled = Service.into2chars((String)token);
                    sql = cmd.getSql();
                    cmd.setSql(sql.substring(0, t.begin + adjustPos) + scrambled + sql.substring(t.end + adjustPos));
                    adjustPos = scrambled.length() - (t.end - t.begin);
                }
                for (String candidateConn : ConnectionResolver.getConnectionNames()) {
                    Properties connectionInfo = ConnectionResolver.getConnectionInfo(candidateConn);
                    String connName = (String)connectionInfo.get("ConnName");
                    if (connName == null) {
                        connName = candidateConn.substring(candidateConn.indexOf("%23") + 3);
                    }
                    if (!token.equalsIgnoreCase(connName)) continue;
                    try {
                        Object pwd;
                        Statement stmt = conn.createStatement();
                        String key = "sid";
                        Object sidValue = connectionInfo.get(key);
                        if (sidValue == null) {
                            key = "serviceName";
                            sidValue = connectionInfo.get(key);
                            key = "service_name";
                            if (sidValue == null) {
                                return;
                            }
                        }
                        if ((pwd = connectionInfo.get("password")) == null) {
                            JPasswordField field = new JPasswordField(10);
                            int action = JOptionPane.showConfirmDialog(null, field, MessageFormat.format("", token), 2);
                            if (action < 0) {
                                return;
                            }
                            pwd = new String(field.getPassword());
                        }
                        boolean linkExists = false;
                        String user = Service.handleMixedCase((String)((String)connectionInfo.get("user")));
                        Object hostname = connectionInfo.get("hostname");
                        Object port = connectionInfo.get("port");
                        String searchLink = "select 'USER='||username||host from user_db_links where db_link like '" + scrambled + ".%' or db_link = '" + scrambled + "'";
                        String candidate = DBUtil.getInstance(conn).executeReturnOneCol(searchLink);
                        if (candidate != null) {
                            linkExists = true;
                            List src1 = Lexer.parse((String)candidate);
                            String u = null;
                            String h = null;
                            String p = null;
                            String s = null;
                            for (LexerToken t1 : src1) {
                                if ("=".equals(t1.content)) continue;
                                if ("".equals(u)) {
                                    u = Service.handleMixedCase((String)t1.content);
                                    continue;
                                }
                                if ("".equals(h)) {
                                    h = t1.content;
                                    continue;
                                }
                                if ("".equals(p)) {
                                    p = t1.content;
                                    continue;
                                }
                                if ("".equals(s)) {
                                    s = t1.content;
                                    continue;
                                }
                                if ("USER".equals(t1.content)) {
                                    u = "";
                                    continue;
                                }
                                if ("HOST".equals(t1.content)) {
                                    h = "";
                                    continue;
                                }
                                if ("PORT".equals(t1.content)) {
                                    p = "";
                                    continue;
                                }
                                if (!key.toUpperCase().equals(t1.content)) continue;
                                s = "";
                            }
                            System.out.println(u + " " + h + " " + p + " " + s + " ");
                            if (!(user.equals(u) && hostname.equals(h) && port.equals(p) && sidValue.equals(s))) {
                                this.log_error(ctx, MessageFormat.format("", scrambled));
                            }
                        }
                        if (linkExists) continue;
                        String cs = "CREATE DATABASE LINK " + scrambled + " \nCONNECT TO " + user + " IDENTIFIED BY " + String.valueOf(pwd) + " \nUSING '(DESCRIPTION =(ADDRESS_LIST =(ADDRESS = (PROTOCOL = TCP)(HOST = " + String.valueOf(hostname) + ")(PORT = " + String.valueOf(port) + ")))(CONNECT_DATA = (" + key.toUpperCase() + " = " + String.valueOf(sidValue) + "))) '";
                        stmt.execute(cs);
                        this.links.add(scrambled);
                        this.log_info(ctx, MessageFormat.format(Messages.getString("TransparentGateway.8"), scrambled));
                    }
                    catch (Exception e) {
                        this.log_error(ctx, MessageFormat.format("", e.getMessage()));
                    }
                }
            }
            linkIsNext = false;
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        try {
            if (Boolean.TRUE.equals(autoDbLinksAtConnection.get(conn)) && conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.cleanLinks(conn, ctx);
    }

    private synchronized void cleanLinks(Connection conn, ScriptRunnerContext ctx) {
        if (this.links != null) {
            for (String link : this.links) {
                try {
                    Statement stmt = conn.createStatement();
                    String sql = "DROP DATABASE LINK " + link;
                    stmt.execute(sql);
                    this.log_info(ctx, MessageFormat.format(Messages.getString("TransparentGateway.9"), link));
                }
                catch (SQLException e) {
                    try {
                        if (e.getErrorCode() == 2018) {
                            this.log_error(ctx, MessageFormat.format(Messages.getString("TransparentGateway.10"), e.getMessage()));
                            continue;
                        }
                        this.log_error(ctx, e.getMessage());
                    }
                    catch (Exception e1) {
                        this.log_error(ctx, MessageFormat.format("", e1.getMessage()));
                    }
                }
                catch (Exception e) {
                    this.log_error(ctx, e.getMessage());
                }
            }
        }
        this.links = new HashSet<String>();
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        List src;
        String sql = cmd.getSql();
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setautodblink") && 2 < (src = Lexer.parse((String)sql)).size() && "set".equals(((LexerToken)src.get((int)0)).content.toLowerCase()) && ((LexerToken)src.get((int)1)).content.toLowerCase().startsWith("autodblink")) {
            String state = ((LexerToken)src.get((int)2)).content.toLowerCase();
            this.log_info(ctx, "autodblink =" + state);
            if ("on".equals(state)) {
                autoDbLinksAtConnection.put(conn, Boolean.TRUE);
            } else if ("off".equals(state)) {
                autoDbLinksAtConnection.put(conn, Boolean.FALSE);
            }
            return true;
        }
        return false;
    }

    private void log_error(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, msg);
        }
    }

    private void log_info(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, msg);
        }
    }
}

