/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.app.Literals2Binds;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.BindPrinter;
import oracle.dbtools.raptor.newscriptrunner.ExecutePathCheckReturn;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.newscriptrunner.PathException;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.util.Pair;
import oracle.jdbc.OracleConnection;

public class SQLPLUS
extends SQLCommandRunner {
    private static String SPECIALBINDFORALIASNULLS = "SPECIALBINDFORALIASNULLS";
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private String directory = null;
    private ScriptExecutor _runner = null;

    public SQLPLUS(ISQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    @Override
    public void interrupt() {
        if (this._runner != null) {
            this._runner.interrupt();
        }
    }

    private void runGoToLine(String sql) {
        int lineNo = -1;
        try {
            lineNo = Integer.parseInt(sql.split("\\s+")[0]);
        }
        catch (NumberFormatException e) {
            this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SQLPLUS.1"), sql));
            this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), MessageFormat.format(Messages.getString("SQLPLUS.1"), sql), sql);
        }
        if (this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().linesInBuffer() > 0 && lineNo >= 0) {
            this.getScriptRunnerContext().write(this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().list(lineNo, false));
        } else {
            this.getScriptRunnerContext().write("\nSP2-0223: No lines in SQL Buffer.");
            this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), "SP2-0223: No lines in SQL Buffer.", this.cmd.getSql());
        }
    }

    public void run() {
        String sql = this.cmd.getSql().trim();
        if (sql.endsWith(";") && sql.length() > 1) {
            this.cmd.setSql(sql.substring(0, sql.length() - 1));
        }
        if (this.cmd.isSqlPlusSetCmd()) {
            this.runSetPlus();
        }
        switch (this.cmd.getStmtSubType()) {
            case G_S_UNKNOWN: {
                try {
                    if (!this.runAliases()) {
                        if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
                            if (this.justANumber(sql)) {
                                this.runGoToLine(sql);
                            } else if (this.cmd.getSQLOrig().length() < 10) {
                                this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("SQLPLUS_UNKNOWN"), this.cmd.getSQLOrig()));
                                this.getScriptRunnerContext().addUnknown();
                            } else {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_BEGINING2", this.cmd.getSQLOrig().substring(0, 10) + "..."));
                                this.getScriptRunnerContext().addUnknown();
                            }
                        } else if (this.justANumber(sql)) {
                            this.runGoToLine(sql);
                        } else {
                            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("UNKNOWN_COMMAND"), this.getScriptRunnerContext()) + "\n");
                            this.getScriptRunnerContext().addUnknown();
                            this.cmd.setFail();
                            if (this.cmd.getSQLOrig().contains("\u200b")) {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ORIGINAL_TEXT_CONTAINED", "Unicode u200B"));
                            }
                        }
                        this.cmd.setProperty("EXECUTEFAILED", "EXECUTEFAILED");
                    }
                }
                catch (ArgumentQuoteException aqe) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("QUOTEMISMATCH", aqe.getMessage()), this.getScriptRunnerContext()));
                    this.doWhenever(false);
                }
                if (!this.getScriptRunnerContext().isMaxUnknown()) break;
                this.getScriptRunnerContext().write(Messages.getString("SQLPLUS.3"));
                this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.3"), this.cmd.getSql());
                this.getScriptRunnerContext().resetUnknown();
                break;
            }
            case G_S_EXECUTE: {
                this.runExecute();
                break;
            }
            case G_S_VARIABLE: {
                this.runVariable();
                break;
            }
            case G_S_PRINT: {
                this.runPrint();
                break;
            }
            case G_S_DOC_PLUS: 
            case G_S_PROMPT: {
                this.runPrompt();
                break;
            }
            case G_S_START: 
            case G_S_AT: 
            case G_S_ATNESTED: {
                this.runExecuteFile();
                break;
            }
            case G_S_EXIT: 
            case G_S_QUIT: {
                this.runQuit();
                break;
            }
            case G_S_WHENEVER: {
                this.runWhenever();
                break;
            }
            case G_S_DEFINE: {
                this.runDefine();
                break;
            }
            case G_S_UNDEFINE: {
                this.runUndefine();
                break;
            }
            case G_S_ACCEPT: {
                break;
            }
            case G_S_COLUMN: {
                this.runColumn();
                break;
            }
            case G_S_PASSWORD: {
                this.runPassword();
                break;
            }
            case G_S_SET_CONSTRAINT: 
            case G_S_SET_ROLE: {
                break;
            }
            case G_S_COMMENT_PLUS: {
                break;
            }
            case G_S_SLASH: {
                this.runBuffer();
                break;
            }
            case G_S_RUN: {
                if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                    this.getScriptRunnerContext().write(this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe().list(false));
                }
                this.runBuffer();
                break;
            }
            case G_S_ROLLBACK_PLUS: {
                try {
                    this.conn.rollback();
                    this.report(this.getScriptRunnerContext(), "Rollback complete.");
                    break;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean justANumber(String sql) {
        Pattern pattern = Pattern.compile("^(-?\\d+.*)");
        return pattern.matcher(sql).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuffer() {
        if (this.conn != null && !SQLPLUSUtil.isConnectionClosed(this.conn) && this.getScriptRunnerContext().getSQLPlusBuffer() != null) {
            IBuffer buf = this.getScriptRunnerContext().getSQLPlusBuffer().getBufferSafe();
            if (buf.getBufferString().trim().length() > 0) {
                String toRun = "";
                if (buf.getLine(buf.size()).trim().equals(".")) {
                    toRun = buf.getBuffer().trim();
                    toRun = toRun.substring(0, toRun.length() - 1);
                } else {
                    toRun = buf.getBuffer();
                }
                this._runner = new ScriptExecutor(toRun, this.conn);
                this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                Boolean oldInSlash = (Boolean)this.getScriptRunnerContext().getProperty("script.runner.isslashstatement");
                if (oldInSlash == null) {
                    oldInSlash = Boolean.FALSE;
                }
                try {
                    this.getScriptRunnerContext().putProperty("script.runner.isslashstatement", Boolean.TRUE);
                    this._runner.run();
                }
                finally {
                    this.getScriptRunnerContext().putProperty("script.runner.isslashstatement", oldInSlash);
                }
            }
            this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("SQLPLUS_BUFFER_EMPTY"));
            try {
                this.getScriptRunnerContext().getOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void runSetPlus() {
        this.cmd.setSql(this.cmd.getSql().toLowerCase());
        String[] retVal = SQLPLUSUtil.nextWordAndRest(this.cmd.getSql());
        if (retVal != null) {
            if (this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                StringTokenizer st = new StringTokenizer(this.cmd.getSql());
                if (st.countTokens() >= 2) {
                    st.nextToken();
                    String token = st.nextToken();
                    if (token.length() < 10) {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_SET_COMMAND", token));
                    } else {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_UNKNOWN_SET_COMMAND_BEGINNING", token.substring(0, 10) + "..."));
                    }
                    this.cmd.setFail();
                }
            } else if (this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_OBSOLETE)) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("SQLPLUS_COMMAND_OBSOLETE", new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig()));
            } else if ((retVal = SQLPLUSUtil.nextWordAndRest(retVal[1])) != null) {
                String command = retVal[0];
                if ((retVal[0].equals("def") || retVal[0].equals("defi") || retVal[0].equals("defin") || retVal[0].equals("define") || retVal[0].equals("verify") || retVal[0].equals("ver") || retVal[0].equals("scan")) && (retVal = SQLPLUSUtil.nextWordAndRest(retVal[1])) != null) {
                    String setChar = retVal[0];
                    boolean quoted = false;
                    String originalSetChar = setChar;
                    if (setChar.startsWith("'") && setChar.endsWith("'") && setChar.length() == 3) {
                        setChar = setChar.substring(1, 2);
                        quoted = true;
                    }
                    if (setChar.startsWith("\"") && setChar.endsWith("\"") && setChar.length() == 3) {
                        setChar = setChar.substring(1, 2);
                        quoted = true;
                    }
                    if (setChar.equals("on")) {
                        if (command.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(true);
                            this.getScriptRunnerContext().setSubstitutionChar('&');
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(true);
                        return;
                    }
                    if (setChar.equals("off")) {
                        if (command.startsWith("def")) {
                            this.getScriptRunnerContext().setSubstitutionOn(false);
                            return;
                        }
                        this.getScriptRunnerContext().setScanOn(false);
                        return;
                    }
                    if (!(setChar.length() != 1 || Character.isWhitespace(setChar.charAt(0)) || Character.isLetterOrDigit(setChar.charAt(0)) || command.equals("scan") || setChar.charAt(0) == '\"' && !quoted || setChar.charAt(0) == '\'' && !quoted || originalSetChar.equals("\"\"\"") || originalSetChar.equals("'''"))) {
                        this.getScriptRunnerContext().setSubstitutionOn(true);
                        this.getScriptRunnerContext().setSubstitutionChar(setChar.charAt(0));
                        return;
                    }
                    String errorReport = ScriptRunnerDbArb.format("INVALID_NAME_COMMAND", "set " + command);
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), errorReport, this.getScriptRunnerContext()));
                    return;
                }
            }
        }
    }

    private void runColumn() {
    }

    private void runUndefine() {
        this.cmd.setSql(SQLPLUSUtil.removeDashNewline(this.cmd, this.cmd.getSql()));
        String[] stringArray = SQLPLUSUtil.nextWordAndRest(this.cmd.getSql());
        if (!stringArray[1].trim().equals("")) {
            String theRest = stringArray[1].trim();
            Map<String, String> m = this.getScriptRunnerContext().getMap();
            while (!theRest.trim().equals("")) {
                stringArray = SQLPLUSUtil.nextWordAndRest(theRest);
                String localVarName = stringArray[0].toUpperCase();
                theRest = stringArray[1];
                m.remove(localVarName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDefine() {
        String[] stringArray;
        if (this.cmd.getProperty("STRIPPED_CONTINUATION") == null) {
            this.cmd.setSql(ScriptUtils.checkforContinuationChars(this.cmd.getSql()));
        }
        if ((stringArray = SQLPLUSUtil.nextWordAndRest(this.cmd.getSql()))[1].trim().equals("")) {
            for (ScriptRunnerContext.SqlplusVariable valueVar : ScriptRunnerContext.SqlplusVariable.values()) {
                String value = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(valueVar.toString(), valueVar);
                String nextKey = valueVar.toString();
                this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  \"" + value + "\" (CHAR)");
            }
            Map<String, String> m = this.getScriptRunnerContext().getMap();
            Set<String> s = m.keySet();
            Map<String, String> map = m;
            synchronized (map) {
                for (String nextKey : s) {
                    boolean isBF2;
                    boolean printedAlready = true;
                    try {
                        ScriptRunnerContext.SqlplusVariable.valueOf(nextKey.toUpperCase());
                    }
                    catch (IllegalArgumentException iae) {
                        printedAlready = false;
                    }
                    if (printedAlready) continue;
                    String value = m.get(nextKey);
                    boolean isDigit = value.equals("") ? false : Pattern.matches("^\\d*$", value);
                    boolean isBF1 = value.equals("") ? false : Pattern.matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?)([0-9]+)?$|^[+-][iI][nN][fF]$", value);
                    boolean bl = isBF2 = value.equals("") ? false : Pattern.matches("^[-+]?[0-9]*\\.[0-9]+([eE][-+]?[0-9]+)?$|^[+-][iI][nN][fF]$", value);
                    if (isBF1 || isBF2) {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  " + value + " (BINARY_FLOAT)");
                        continue;
                    }
                    if (isDigit) {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  " + value + " (NUMBER)");
                        continue;
                    }
                    this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + " =  \"" + value + "\" (CHAR)");
                }
            }
        }
        String localSubName = "";
        if (stringArray[1].indexOf("=") == -1) {
            Map<String, String> m = this.getScriptRunnerContext().getMap();
            String nextKey = stringArray[1].trim().toUpperCase();
            String value = m.get(nextKey);
            Map<String, String> svt = this.getScriptRunnerContext().getSubVarTypeMap();
            String dataType = svt.get(nextKey);
            if (value == null || nextKey.equals(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString()) || nextKey.equals(ScriptRunnerContext.SqlplusVariable._DATE.toString())) {
                boolean found = true;
                ScriptRunnerContext.SqlplusVariable valueVar = null;
                try {
                    valueVar = ScriptRunnerContext.SqlplusVariable.valueOf(nextKey);
                }
                catch (IllegalArgumentException iae) {
                    found = false;
                }
                if (found) {
                    value = this.getScriptRunnerContext().doPromptReplaceSqlplusVar(nextKey.toString(), valueVar);
                }
            }
            if (value == null) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("UNDEFINED_SYMBOL", nextKey.toLowerCase(Locale.US)));
            } else {
                int maxvarlen = 15;
                int keyLen = nextKey.length();
                int pad = 0;
                StringBuffer spacePad = new StringBuffer();
                if (keyLen < maxvarlen) {
                    pad = maxvarlen - keyLen;
                    for (int j = 0; j < pad; ++j) {
                        spacePad.append(" ");
                    }
                } else {
                    spacePad.append("");
                }
                boolean forceChar = false;
                for (ScriptRunnerContext.SqlplusVariable valueVar : ScriptRunnerContext.SqlplusVariable.values()) {
                    if (!valueVar.equals(nextKey.toUpperCase())) continue;
                    forceChar = true;
                    break;
                }
                if (forceChar || nextKey.equals(value) && (nextKey.equals(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString()) || nextKey.equals(ScriptRunnerContext.SqlplusVariable._USER.toString()))) {
                    this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = \"\" (CHAR)");
                } else if (dataType != null && dataType.length() > 0) {
                    if (dataType.equalsIgnoreCase("CHAR") || dataType.equalsIgnoreCase("VARCHAR") || dataType.equalsIgnoreCase("VARCHAR2")) {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = \"" + value + "\" (" + dataType + ")");
                    } else {
                        this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = " + value + " (" + dataType + ")");
                    }
                } else {
                    this.report(this.getScriptRunnerContext(), "DEFINE " + nextKey + spacePad.toString() + " = \"" + value + "\" (CHAR)");
                }
            }
        } else {
            localSubName = stringArray[1].substring(0, stringArray[1].indexOf("=")).trim().toUpperCase();
            String setValue = "";
            boolean errorOut = false;
            if (stringArray[1].indexOf("=") != stringArray[1].length() - 1) {
                setValue = stringArray[1].substring(stringArray[1].indexOf("=") + 1).trim();
                if (setValue.startsWith("\"")) {
                    setValue = this.getDefineValue(Character.valueOf('\"'), setValue);
                } else if (setValue.startsWith("'")) {
                    setValue = this.getDefineValue(Character.valueOf('\''), setValue);
                }
                if (setValue != null) {
                    Map<String, String> map = this.getScriptRunnerContext().getMap();
                    map.put(localSubName, setValue);
                } else {
                    errorOut = true;
                }
            }
            if (errorOut) {
                String errorReport = ScriptRunnerDbArb.getString("DEFINE_REQUIRES_VALUE");
                if (setValue == null) {
                    errorReport = ScriptRunnerDbArb.getString("DEFINE_INVALID");
                }
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), errorReport, this.getScriptRunnerContext()));
            }
        }
    }

    String getDefineValue(Character specialCharacter, String containsSpecial) {
        int lastEscaped = -1;
        String retString = null;
        String extra = containsSpecial + " ";
        StringBuilder retVal = new StringBuilder("");
        char last = ' ';
        char current = ' ';
        char next = ' ';
        for (int i = 1; i < containsSpecial.length(); ++i) {
            last = current;
            current = containsSpecial.charAt(i);
            next = extra.charAt(i + 1);
            if (!specialCharacter.equals(Character.valueOf(current))) {
                retVal.append(current);
                if (i != containsSpecial.length() - 1) continue;
                retVal = null;
                continue;
            }
            if ((!specialCharacter.equals(Character.valueOf(last)) || lastEscaped == i - 1) && specialCharacter.equals(Character.valueOf(current)) && !specialCharacter.equals(Character.valueOf(next))) break;
            if ((!specialCharacter.equals(Character.valueOf(last)) || lastEscaped == i - 1) && specialCharacter.equals(Character.valueOf(current)) && specialCharacter.equals(Character.valueOf(next))) {
                lastEscaped = i + 1;
                continue;
            }
            if (specialCharacter.equals(Character.valueOf(last)) && specialCharacter.equals(Character.valueOf(current)) && lastEscaped != i - 1) {
                retVal.append(current);
                if (i != containsSpecial.length() - 1) continue;
                retVal = null;
                continue;
            }
            retVal = null;
            break;
        }
        retString = containsSpecial.length() == 1 ? null : (retVal == null ? null : retVal.toString());
        return retString;
    }

    private void runWhenever() {
        boolean showUsage = false;
        String SUCCESS = "SUCCESS";
        String FAILURE = "FAILURE";
        String WARNING = "WARNING";
        String removeComments = this.cmd.getSql().toUpperCase();
        String stripped = ScriptUtils.stripFirstN(removeComments, 9999, this.cmd.getProperty("STRIPPED_CONTINUATION") == null, true, true);
        if (stripped == null) {
            showUsage = true;
        } else {
            removeComments = stripped;
        }
        boolean localMatchFound = false;
        boolean localSqlError = false;
        int localFlags = 0;
        if (!showUsage) {
            String cmdUpper = removeComments;
            if (cmdUpper.length() > 1 && (cmdUpper.endsWith(";") || cmdUpper.endsWith("/"))) {
                cmdUpper = cmdUpper.substring(0, cmdUpper.length() - 1);
            }
            String[] stringArray = SQLPLUSUtil.nextWordAndRest(cmdUpper);
            if (!showUsage && stringArray != null && !stringArray[1].equals("")) {
                String nextWord = stringArray[0];
                String theRest = stringArray[1];
                if ((stringArray = SQLPLUSUtil.nextWordAndRest(theRest)) != null && !stringArray[1].equals("")) {
                    nextWord = stringArray[0];
                    theRest = stringArray[1];
                    if (nextWord.equals("SQLERROR") || nextWord.equals("OSERROR")) {
                        localSqlError = nextWord.equals("SQLERROR");
                        stringArray = SQLPLUSUtil.nextWordAndRest(theRest);
                        if (stringArray != null) {
                            nextWord = stringArray[0];
                            theRest = stringArray[1];
                            if (nextWord.equals("CONTINUE") || nextWord.equals("EXIT")) {
                                localFlags = nextWord.equals("EXIT") ? 4 : 0;
                                if (theRest == null || theRest.equals("")) {
                                    theRest = "";
                                } else {
                                    int value = 1;
                                    boolean wasSQLCODE = false;
                                    try {
                                        stringArray = SQLPLUSUtil.nextWordAndRest(theRest);
                                        if (stringArray != null) {
                                            nextWord = stringArray[0];
                                            if (nextWord.equals("SUCCESS") || nextWord.equals("FAILURE") || nextWord.equals("WARNING")) {
                                                switch (nextWord) {
                                                    case "SUCCESS": {
                                                        value = 0;
                                                        break;
                                                    }
                                                    case "WARNING": {
                                                        value = 1;
                                                        break;
                                                    }
                                                    case "FAILURE": {
                                                        value = 2;
                                                        break;
                                                    }
                                                    default: {
                                                        value = 1;
                                                        break;
                                                    }
                                                }
                                            } else if (nextWord.equals("SQL.SQLCODE")) {
                                                wasSQLCODE = true;
                                                value = 2;
                                            } else {
                                                value = nextWord.equals("SQL.OSCODE") ? 2 : Integer.parseInt(nextWord);
                                            }
                                            theRest = stringArray[1];
                                            if (theRest == null) {
                                                theRest = "";
                                            }
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        value = 1;
                                    }
                                    this.getScriptRunnerContext().putProperty("script.runner.exit_int_whenever", value);
                                    this.getScriptRunnerContext().putProperty("script.runner.exit_int_whenever.wassqlcode", wasSQLCODE);
                                }
                                String action = "NONE";
                                String[] arrayWords = theRest.trim().split("\\s+");
                                if (localFlags == 4) {
                                    action = "COMMIT";
                                }
                                if (arrayWords != null) {
                                    int count = 0;
                                    for (String word : arrayWords) {
                                        if (localFlags != 4) {
                                            if (++count > 1) {
                                                showUsage = true;
                                                break;
                                            }
                                            if (word.equals("NONE")) {
                                                action = word;
                                                break;
                                            }
                                        } else if (++count > 1) {
                                            showUsage = true;
                                            break;
                                        }
                                        if (!word.equals("COMMIT") && !word.equals("ROLLBACK") && !word.equals("NONE")) continue;
                                        action = word;
                                        break;
                                    }
                                }
                                localFlags = action.equals("COMMIT") ? (localFlags |= 1) : (action.equals("ROLLBACK") ? (localFlags |= 2) : (localFlags |= 0));
                                localMatchFound = true;
                            }
                        }
                    }
                }
            }
        }
        if (localMatchFound && !showUsage) {
            if (localSqlError) {
                this.getScriptRunnerContext().setSqlError(localFlags);
            } else {
                this.getScriptRunnerContext().setOsError(localFlags);
            }
        } else {
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), Messages.getString("WHENEVER"), this.getScriptRunnerContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPassword() {
        if (this.getScriptRunnerContext().getCurrentConnection() != null && this.getScriptRunnerContext().getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            this.getScriptRunnerContext().write("Not supported for nucleo connection\n");
            return;
        }
        Boolean haveILocked = false;
        Statement s = null;
        ResultSet rs = null;
        try {
            if (this.getScriptRunnerContext().getBaseConnection() == null) {
                if (this.getScriptRunnerContext() != null && this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.getScriptRunnerContext().getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                    this.report(this.getScriptRunnerContext(), Messages.getString("SQLPLUS.18"));
                    this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.18"), this.cmd.getSql());
                    this.report(this.getScriptRunnerContext(), Messages.getString("SQLPLUS.19"));
                    this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), Messages.getString("SQLPLUS.19"), this.cmd.getSql());
                } else {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
                }
                this.doWhenever(true);
            } else {
                if (this.conn == null) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("NOT_CONNECTED"));
                    return;
                }
                haveILocked = LockManager.lock(this.getScriptRunnerContext().getBaseConnection());
                if (haveILocked.booleanValue()) {
                    Pair<String, String> passwords;
                    String splitString = null;
                    String toprocess = this.cmd.getSql().replaceAll("^\\s+", "");
                    if (toprocess.split("\\s+").length > 1) {
                        splitString = toprocess.replaceFirst("^[^\\s]+\\s*", "").trim();
                    }
                    s = this.conn.createStatement();
                    rs = s.executeQuery("Select user from dual");
                    rs.next();
                    String currentUserid = rs.getString(1);
                    rs.close();
                    s.close();
                    String alterUserId = null;
                    if (splitString != null && !splitString.equals("")) {
                        alterUserId = splitString;
                        alterUserId = alterUserId.startsWith("\"") && alterUserId.endsWith("\"") && alterUserId.length() > 2 ? alterUserId.substring(1, alterUserId.length() - 1) : alterUserId.toUpperCase();
                    }
                    if (alterUserId == null) {
                        alterUserId = currentUserid;
                    }
                    if ((passwords = this.getScriptRunnerContext().getPasswordFieldsProvider().passwordGetPassword(this.getScriptRunnerContext(), currentUserid, alterUserId)) != null) {
                        s = this.conn.createStatement();
                        s.execute("alter user \"" + alterUserId + "\" identified by \"" + (String)passwords.first() + "\" replace \"" + (String)passwords.second() + "\"");
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("PASSWORD_CHANGED"));
                    } else {
                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
                        this.doWhenever(true);
                    }
                }
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 65066) {
                this.report(this.getScriptRunnerContext(), e.getMessage());
            } else {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("PDBPASSWORDERROR"));
            }
            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("FAILED_TO_ALTER_USER"));
            this.doWhenever(true);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
            if (haveILocked.booleanValue()) {
                LockManager.unlock(this.getScriptRunnerContext().getBaseConnection());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQuit() {
        block60: {
            String[] allExitArgs;
            String localSql;
            block59: {
                localSql = this.cmd.getLoweredTrimmedSQL().toUpperCase();
                if (localSql.endsWith(";")) {
                    localSql = localSql.substring(0, localSql.length() - 1).trim();
                }
                if (this.conn != null && !SQLPLUSUtil.isConnectionClosed(this.conn) && this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH") != null && !((Boolean)this.getScriptRunnerContext().getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.TRUE)) {
                    if (localSql.endsWith("ROLLBACK")) {
                        try {
                            this.conn.rollback();
                        }
                        catch (SQLException e) {
                            if (!(this.conn instanceof OracleConnection) || DBUtil.isOracleConnectionAlive(this.conn)) {
                                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), this.getScriptRunnerContext()));
                            }
                            break block59;
                        }
                    }
                    try {
                        if (this.getScriptRunnerContext().getProperty("script.runner.exitcommit") != null && this.getScriptRunnerContext().getProperty("script.runner.exitcommit").equals("OFF")) {
                            this.conn.rollback();
                        } else {
                            this.conn.commit();
                        }
                    }
                    catch (SQLException e) {
                        if (this.conn instanceof OracleConnection && !DBUtil.isOracleConnectionAlive(this.conn)) break block59;
                        this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("ERROR_ON", "Rollback"), this.getScriptRunnerContext()));
                    }
                }
            }
            this.getScriptRunnerContext().setExited(true);
            String exitArgs = "";
            if (localSql.length() > 2) {
                exitArgs = localSql.substring(4).trim();
                exitArgs = exitArgs.replaceAll("ROLLBACK", "").replaceAll("COMMIT", "");
            }
            if ((allExitArgs = exitArgs.trim().split("\\s+"))[0].toUpperCase().equals("FAILURE")) {
                this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
            } else if (allExitArgs.length > 1) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
            } else {
                try {
                    String val;
                    if (allExitArgs[0].startsWith(":")) {
                        String bindName = exitArgs.substring(1).trim();
                        Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
                        Object object = m;
                        synchronized (object) {
                            Bind b = m.get(bindName.toUpperCase());
                            if (b != null) {
                                String value = b.getValue();
                                if (value != null && !value.equals("") && !value.equalsIgnoreCase("infinity") && !value.equalsIgnoreCase("nan") && value.length() > 0 && Character.isDigit(value.charAt(0))) {
                                    allExitArgs[0] = value;
                                } else {
                                    allExitArgs[0] = "1";
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("INTERNAL_NUMBER_ERROR"));
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
                                }
                            } else {
                                allExitArgs[0] = "1";
                                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
                            }
                        }
                    }
                    if (allExitArgs[0] != null && (allExitArgs[0].toUpperCase().equals("SQLCODE") || allExitArgs[0].toUpperCase().equals("SQL.SQLCODE"))) {
                        String sqlCodeString = (String)this.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode");
                        int codeNum = 0;
                        if (sqlCodeString != null) {
                            try {
                                String firstLine = sqlCodeString.split("\n")[0].trim();
                                codeNum = firstLine.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(firstLine.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
                            }
                            catch (NumberFormatException e) {
                                codeNum = -1;
                            }
                            catch (PatternSyntaxException e) {
                                codeNum = -1;
                            }
                        }
                        allExitArgs[0] = String.valueOf(codeNum);
                    }
                    if ((val = allExitArgs[0]) != null) {
                        val = val.trim().toUpperCase();
                    }
                    if (!(allExitArgs[0] == null || val.equals("SUCCESS") || val.equals("FAILURE") || val.equals("WARNING") || val.equals("COMMIT") || val.equals("ROLLBACK") || val.startsWith("/*") || val.startsWith("--") || val.equals(""))) {
                        try {
                            Double.parseDouble(allExitArgs[0]);
                            DecimalFormat format = new DecimalFormat();
                            format.setDecimalSeparatorAlwaysShown(false);
                            Double d = Double.parseDouble(allExitArgs[0]);
                            if (d > 2.147483647E9 || d < 1.0) {
                                this.getScriptRunnerContext().putProperty("script.runner.exit_int", 0);
                                break block60;
                            }
                            int is = new BigDecimal(d).setScale(0, RoundingMode.HALF_DOWN).intValue();
                            this.getScriptRunnerContext().putProperty("script.runner.exit_int", is);
                        }
                        catch (NumberFormatException e) {
                            int i = 0;
                            Map<String, String> m = this.getScriptRunnerContext().getMap();
                            Set<String> s = m.keySet();
                            Map<String, String> map = m;
                            synchronized (map) {
                                Iterator<String> it = s.iterator();
                                boolean found = false;
                                while (it.hasNext()) {
                                    String nextKey = it.next();
                                    if (!val.equals(nextKey)) continue;
                                    try {
                                        String value = m.get(nextKey);
                                        try {
                                            i = Integer.parseInt(value);
                                            found = true;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                        }
                                    }
                                    catch (IllegalArgumentException value) {}
                                }
                                if (val.equalsIgnoreCase("sqlcode") || val.equalsIgnoreCase("sql.sqlcode")) {
                                    String sqlCodeString = (String)this.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode");
                                    int codeNum = 0;
                                    if (sqlCodeString != null) {
                                        try {
                                            String firstLine = sqlCodeString.split("\n")[0].trim();
                                            codeNum = firstLine.matches("^[^\\-]*\\-[0-9]+.*$") ? Integer.parseInt(firstLine.replaceAll("^[^\\-]*\\-([0-9]+).*$", "$1")) : -1;
                                        }
                                        catch (NumberFormatException e1) {
                                            codeNum = -1;
                                        }
                                        catch (PatternSyntaxException e2) {
                                            codeNum = -1;
                                        }
                                        this.getScriptRunnerContext().putProperty("script.runner.exit_int", codeNum);
                                        found = true;
                                    }
                                }
                                if (!found) {
                                    i = 1;
                                    this.report(this.getScriptRunnerContext(), MessageFormat.format("EXIT_JUNK", exitArgs != null ? exitArgs.trim() : exitArgs));
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.get("EXIT_JUNK2"));
                                }
                            }
                            this.getScriptRunnerContext().putProperty("script.runner.exit_int", i);
                        }
                        break block60;
                    }
                    int value = 0;
                    switch (val) {
                        case "WARNING": {
                            value = 2;
                            break;
                        }
                        case "FAILURE": {
                            value = 1;
                            break;
                        }
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.exit_int", value);
                }
                catch (Exception e) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("EXIT_VALUE_NOT_CALCULATED", exitArgs));
                    this.getScriptRunnerContext().putProperty("script.runner.exit_int", 1);
                }
            }
        }
        if (this.getScriptRunnerContext().getProperty("Spool.out.buffer") != null) {
            this.getScriptRunnerContext().stopSpool();
        }
        if (this.conn != null) {
            SQLPLUSUtil.disconnect(this.conn, this.getScriptRunnerContext(), this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    ExecutePathCheckReturn checkPath(boolean tryUrlAsDir, boolean multiplePath, boolean noPrefix, String prefixString, URL prefixURL, String inputFile, String encodingOverride, PathException lastException) {
        ExecutePathCheckReturn retVal;
        block72: {
            InputStream is;
            BufferedReader reader;
            block68: {
                block69: {
                    block66: {
                        retVal = new ExecutePathCheckReturn();
                        reader = null;
                        is = null;
                        int NOPREFIX = 1;
                        int PREFIXSTRING = 2;
                        int PREFIXURL = 3;
                        int state = 0;
                        if (noPrefix) {
                            state = NOPREFIX;
                        } else if (prefixString != null) {
                            state = PREFIXSTRING;
                        } else if (prefixURL != null) {
                            state = PREFIXURL;
                        } else {
                            if (lastException != null) {
                                retVal.setLastException(lastException);
                            }
                            return retVal;
                        }
                        if (state == PREFIXURL) {
                            URL returnURL;
                            if (prefixURL != null && (returnURL = this.joinUrl(tryUrlAsDir, prefixURL, (String)inputFile)) != null && SQLPLUSUtil.haveIBytes(returnURL)) {
                                URLConnection uc = null;
                                InputStream isInner = null;
                                try {
                                    uc = returnURL.openConnection();
                                    isInner = uc.getInputStream();
                                    inputFile = returnURL.toString();
                                }
                                catch (IOException e) {
                                    returnURL = null;
                                }
                                finally {
                                    if (isInner != null) {
                                        try {
                                            isInner.close();
                                        }
                                        catch (IOException e) {}
                                    }
                                }
                                retVal.setUrl(returnURL);
                            }
                        } else {
                            Object setting = null;
                            setting = state == NOPREFIX ? inputFile : prefixString;
                            if (setting != null && !((String)setting).equals("")) {
                                String[] pathArray = new String[]{setting};
                                if (multiplePath) {
                                    pathArray = ((String)setting).split(File.pathSeparator);
                                }
                                boolean prependHttp = false;
                                boolean prependFtp = false;
                                Object matchedInputFile = null;
                                for (Object singlePath : pathArray) {
                                    if (singlePath == null) continue;
                                    if (File.pathSeparator.equals(":")) {
                                        if (prependHttp) {
                                            singlePath = "http:" + (String)singlePath;
                                        }
                                        if (prependFtp) {
                                            singlePath = "ftp:" + (String)singlePath;
                                        }
                                        prependHttp = false;
                                        prependHttp = false;
                                        if (((String)singlePath).toLowerCase().equals("http")) {
                                            prependHttp = true;
                                            continue;
                                        }
                                        if (((String)singlePath).toLowerCase().equals("ftp")) {
                                            prependFtp = true;
                                            continue;
                                        }
                                        prependHttp = false;
                                        prependHttp = false;
                                    }
                                    if (FileUtils.startsWithHttpOrFtp((String)singlePath)) {
                                        Object path = state != NOPREFIX ? (((String)singlePath).endsWith("\\") || ((String)singlePath).endsWith("/") ? (String)singlePath + (String)inputFile : (String)singlePath + "/" + (String)inputFile) : singlePath;
                                        if (FileUtils.haveIBytes((String)path, this.getScriptRunnerContext())) {
                                            matchedInputFile = path;
                                            break;
                                        }
                                        path = state != NOPREFIX ? (((String)singlePath).endsWith("\\") || ((String)singlePath).endsWith("/") ? (String)singlePath + (String)inputFile : (String)singlePath + "\\" + (String)inputFile) : singlePath;
                                        if (!FileUtils.haveIBytesRaw((String)path)) continue;
                                        matchedInputFile = ((String)path).replace("/", "\\");
                                        break;
                                    }
                                    Object combined = null;
                                    combined = ((String)singlePath).endsWith("\\") || ((String)singlePath).endsWith("/") ? (String)singlePath + (String)inputFile : (String)singlePath + "/" + (String)inputFile;
                                    if (state == NOPREFIX) {
                                        combined = singlePath;
                                    }
                                    if (new File(((String)combined).replace("/", "\\")).exists()) {
                                        matchedInputFile = ((String)combined).replace("/", "\\");
                                        break;
                                    }
                                    if (!new File(((String)combined).replace("\\", "/")).exists()) continue;
                                    matchedInputFile = ((String)combined).replace("\\", "/");
                                    break;
                                }
                                if (matchedInputFile == null) break block66;
                                if (FileUtils.startsWithHttpOrFtp(matchedInputFile) && (FileUtils.haveIBytes(matchedInputFile, this.getScriptRunnerContext()) || FileUtils.haveIBytesRaw(matchedInputFile))) {
                                    block67: {
                                        ((String)matchedInputFile).replace("/", "\\");
                                        if (this.getScriptRunnerContext().getProperty("script.runner.hhtp.proxy") != null) {
                                            try {
                                                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getScriptRunnerContext().getProperty("script.runner.hhtp.proxy.host").toString(), Integer.parseInt(this.getScriptRunnerContext().getProperty("script.runner.hhtp.proxy.port").toString())));
                                                HttpURLConnection connection = (HttpURLConnection)new URL((String)matchedInputFile).openConnection(proxy);
                                                is = connection.getInputStream();
                                            }
                                            catch (Exception e) {
                                                if ("SQLcl".equals(SQLPLUSUtil.getProductName())) {
                                                    is = this.getInputStream((String)matchedInputFile);
                                                    break block67;
                                                }
                                                this.write(ScriptRunnerDbArb.getString("SQLPLUS_PROXY_ERROR"));
                                            }
                                        } else {
                                            is = this.getInputStream((String)matchedInputFile);
                                        }
                                    }
                                    if (is != null) {
                                        inputFile = matchedInputFile;
                                        reader = new BufferedReader(new InputStreamReader(is, encodingOverride));
                                        retVal.setOutputFile((String)inputFile);
                                    }
                                    break block66;
                                }
                                inputFile = matchedInputFile;
                                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)inputFile), encodingOverride));
                                retVal.setOutputFile((String)inputFile);
                            }
                        }
                    }
                    if (reader != null) break block68;
                    if (is == null) break block69;
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                    }
                }
                if (retVal.getLastException() != null) {
                    if (lastException != null) {
                        retVal.setLastException(lastException);
                    } else {
                        retVal.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", inputFile)));
                    }
                }
                break block72;
            }
            retVal.setLiveReader(reader);
            break block72;
            catch (Exception e) {
                block70: {
                    block71: {
                        try {
                            retVal.setLastException(new PathException(e));
                            if (reader != null) break block70;
                            if (is == null) break block71;
                        }
                        catch (Throwable throwable) {
                            if (reader == null) {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException ioe) {
                                        LOGGER.log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                                    }
                                }
                                if (retVal.getLastException() != null) {
                                    if (lastException != null) {
                                        retVal.setLastException(lastException);
                                    } else {
                                        retVal.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", inputFile)));
                                    }
                                }
                            } else {
                                retVal.setLiveReader(reader);
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {
                            LOGGER.log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                        }
                    }
                    if (retVal.getLastException() != null) {
                        if (lastException != null) {
                            retVal.setLastException(lastException);
                        } else {
                            retVal.setLastException(new PathException(ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", inputFile)));
                        }
                    }
                }
                retVal.setLiveReader(reader);
            }
        }
        return retVal;
    }

    public ExecutePathCheckReturn checkMultiplePaths(ISQLCommand cmd) {
        this.cmd = cmd;
        return this.checkMultiplePaths();
    }

    public ExecutePathCheckReturn checkMultiplePaths() {
        ExecutePathCheckReturn retVal;
        String arguments;
        String preAppendInputFile;
        block66: {
            String unQuotedFile;
            boolean found;
            int i;
            String localSql;
            URL topURL;
            URL baseURL;
            String encodingOverride;
            block68: {
                block67: {
                    preAppendInputFile = "";
                    arguments = null;
                    retVal = null;
                    encodingOverride = this.getScriptRunnerContext().getEncoding();
                    baseURL = (URL)this.getScriptRunnerContext().getProperty("script.runner.base.url");
                    if (this.getScriptRunnerContext().getTopLevel()) {
                        this.getScriptRunnerContext().putProperty("script.runner.topbase.url", baseURL);
                    }
                    topURL = (URL)this.getScriptRunnerContext().getProperty("script.runner.topbase.url");
                    boolean callFile = false;
                    localSql = "";
                    i = 0;
                    if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_START) {
                        localSql = this.cmd.getSql();
                        if ((localSql = localSql.trim()).toLowerCase().equals("start")) {
                            this.report(this.getScriptRunnerContext(), "");
                        } else {
                            found = false;
                            for (i = 0; i < localSql.length(); ++i) {
                                char nextChar = localSql.charAt(i);
                                if (!Character.isWhitespace(nextChar) && nextChar != '\'' && nextChar != '\"') continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                localSql = localSql.substring(i).trim();
                                callFile = true;
                            }
                        }
                    } else if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_AT) {
                        if (this.cmd.getSql().trim().startsWith("@@")) {
                            this.cmd.setStmtId(SQLCommand.StmtSubType.G_S_ATNESTED);
                        } else {
                            localSql = this.cmd.getSql();
                            if ((localSql = localSql.trim()).length() == 1) {
                                this.report(this.getScriptRunnerContext(), "");
                            } else {
                                if ((localSql = localSql.substring(1).trim()).startsWith("~")) {
                                    localSql = localSql.replaceFirst("~", System.getProperty("user.home"));
                                }
                                callFile = true;
                            }
                        }
                    }
                    if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_ATNESTED) {
                        localSql = this.cmd.getSql();
                        if ((localSql = localSql.trim()).length() != 2) {
                            localSql = localSql.substring(2).trim();
                            callFile = true;
                        }
                    }
                    if (!callFile) break block66;
                    found = false;
                    unQuotedFile = null;
                    String endString = "";
                    if (localSql.length() <= 1 || !localSql.startsWith("\"") && !localSql.startsWith("'")) break block67;
                    endString = new Character(localSql.charAt(0)).toString();
                    int indexOfSecond = localSql.substring(1).indexOf(endString);
                    if (indexOfSecond == -1) break block68;
                    unQuotedFile = localSql.substring(1, indexOfSecond + 1);
                    i = indexOfSecond + 2;
                    break block68;
                }
                for (i = 0; i < localSql.length(); ++i) {
                    if (!Character.isWhitespace(localSql.charAt(i))) continue;
                    found = true;
                    break;
                }
            }
            if (found || localSql.length() != 0) {
                int dot;
                Object inputFile = "";
                if (found || unQuotedFile != null) {
                    if (unQuotedFile != null) {
                        inputFile = unQuotedFile;
                        if (localSql.length() > i) {
                            arguments = localSql.substring(i).trim();
                        }
                    } else {
                        inputFile = localSql.substring(0, i);
                        if (localSql.length() > i + 1) {
                            arguments = localSql.substring(i).trim();
                        }
                    }
                } else {
                    inputFile = localSql;
                }
                ScriptRunnerContext ctx = this.getScriptRunnerContext();
                if (!"$".equals(ctx.escChar) && ((String)inputFile).contains("$") || !"%".equals(ctx.escChar) && ((String)inputFile).contains("%")) {
                    inputFile = ScriptUtils.replaceEnvVars((String)inputFile);
                }
                if (((String)inputFile).startsWith("?") && ((String)inputFile).length() > 1) {
                    String OH = System.getProperty("sqlcl.script.dir");
                    if (OH == null) {
                        OH = System.getenv("ORACLE_HOME");
                    }
                    if (OH == null) {
                        OH = "?";
                    }
                    if (OH.endsWith(File.separator)) {
                        OH = OH.substring(0, OH.length() - 1);
                    }
                    inputFile = OH + ((String)inputFile).substring(1);
                }
                int filesep = ((String)inputFile).lastIndexOf("/");
                int filesepBack = ((String)inputFile).lastIndexOf("\\");
                if (filesepBack > filesep) {
                    filesep = filesepBack;
                }
                if ((dot = ((String)inputFile).lastIndexOf(46)) <= filesep && !this.getScriptRunnerContext().getProperty("script.runner.file.suffix").equals("")) {
                    inputFile = (String)inputFile + "." + String.valueOf(this.getScriptRunnerContext().getProperty("script.runner.file.suffix"));
                }
                preAppendInputFile = inputFile;
                boolean prependDirectory = false;
                if (!(FileUtils.startsWithHttpOrFtp((String)inputFile) || ((String)inputFile).startsWith("/") || ((String)inputFile).startsWith("\\"))) {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        if (((String)inputFile).length() <= 3 || (((String)inputFile).charAt(1) != ':' || ((String)inputFile).charAt(2) != '/' && ((String)inputFile).charAt(2) != '\\') && (((String)inputFile).charAt(0) != '/' || ((String)inputFile).charAt(2) != ':' || ((String)inputFile).charAt(3) != '/')) {
                            prependDirectory = true;
                        }
                    } else if (!((String)inputFile).startsWith("/") && !((String)inputFile).startsWith("\\")) {
                        prependDirectory = true;
                    }
                }
                if (this.cmd.getStmtId() == SQLCommand.StmtSubType.G_S_ATNESTED) {
                    String uRLString = null;
                    boolean slashCase = false;
                    if (prependDirectory) {
                        String possibleMatch = null;
                        if (this.getDirectory() != null) {
                            possibleMatch = this.getDirectory().endsWith("/") || this.getDirectory().endsWith("\\") ? this.getDirectory() + (String)inputFile : this.getDirectory() + File.separator + (String)inputFile;
                        }
                        if (possibleMatch != null && FileUtils.startsWithHttpOrFtp(possibleMatch)) {
                            if (FileUtils.haveIBytes(possibleMatch, this.getScriptRunnerContext())) {
                                uRLString = possibleMatch.replace("\\", "/");
                            } else if (this.getDirectory().indexOf("\\") != -1 && FileUtils.haveIBytesRaw(possibleMatch.replace("/", "\\"))) {
                                uRLString = possibleMatch.replace("/", "\\");
                            } else {
                                prependDirectory = false;
                                slashCase = true;
                            }
                        } else if (possibleMatch != null && new File(possibleMatch.replace("/", "\\")).exists()) {
                            prependDirectory = true;
                        } else if (possibleMatch != null && new File(possibleMatch.replace("\\", "/")).exists()) {
                            prependDirectory = true;
                        } else {
                            prependDirectory = false;
                            slashCase = true;
                        }
                    }
                    if (uRLString != null) {
                        inputFile = uRLString;
                    } else if (prependDirectory && this.getDirectory() != null && !this.getDirectory().equals("")) {
                        inputFile = this.getDirectory().endsWith("/") || this.getDirectory().endsWith("\\") ? this.getDirectory() + (String)inputFile : this.getDirectory() + File.separator + (String)inputFile;
                    }
                    prependDirectory = false;
                    if (slashCase) {
                        prependDirectory = true;
                    }
                }
                if (prependDirectory) {
                    String encoding = encodingOverride;
                    retVal = this.checkPath(false, false, false, (String)this.getScriptRunnerContext().getProperty("script.runner.cd_command"), null, (String)inputFile, encoding, null);
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, baseURL, (String)inputFile, encoding, null);
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, topURL, (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, this.useIfNotDirectoryOrNotFile(this.getScriptRunnerContext().getLastNodeForDirNameURL()), (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(true, false, false, null, this.useIfDirectoryOrNotFile(this.getScriptRunnerContext().getLastNodeForDirNameURL()), (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, false, false, null, this.useIfNotDirectoryOrNotFile(this.getScriptRunnerContext().getLastDirNameURL()), (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(true, false, false, null, this.useIfDirectoryOrNotFile(this.getScriptRunnerContext().getLastDirNameURL()), (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                        retVal = this.checkPath(false, true, false, (String)this.getScriptRunnerContext().getProperty("DBConfig.DEFAULT_PATH"), null, (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (retVal.getLiveReader() == null && retVal.getUrl() == null && SQLPLUSUtil.getSqlpathProvider() != null) {
                        retVal = this.checkPath(false, true, false, SQLPLUSUtil.getSqlpathProvider().getSQLPATHsetting(), null, (String)inputFile, encoding, retVal.getLastException());
                    }
                    if (this.getScriptRunnerContext().getProperty("script.runner.jline") != null) {
                        if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                            retVal = this.checkPath(false, false, true, null, null, (String)inputFile, encoding, retVal.getLastException());
                        }
                        if (retVal.getLiveReader() == null && retVal.getUrl() == null) {
                            retVal = this.checkPath(false, false, true, null, null, (String)inputFile, encoding, retVal.getLastException());
                        }
                    }
                }
                if (retVal == null) {
                    retVal = this.checkPath(false, false, true, null, null, (String)inputFile, encodingOverride, null);
                }
            }
        }
        if (retVal != null) {
            retVal.setArguments(arguments);
            retVal.setPreAppendInputFile(preAppendInputFile);
        }
        return retVal;
    }

    URL useIfDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return inURL;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    URL useIfNotDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return null;
            }
            return inURL;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecuteFile() {
        if (this.getScriptRunnerContext().isStdin()) {
            this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input.was.on", Boolean.TRUE);
        }
        this.getScriptRunnerContext().putProperty("script.runner.sqlcl.stdin.input", Boolean.FALSE);
        this.getScriptRunnerContext().putProperty("script.runner.sqlcl.execute.file", Boolean.TRUE);
        if (this.getScriptRunnerContext().getRestrictedLevel().getLevel() > 2) {
            this.getScriptRunnerContext().write(MessageFormat.format(Messages.getString("SQLPLUS.9"), "start"));
            this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), MessageFormat.format(Messages.getString("SQLPLUS.9"), "start"), this.cmd.getSql());
            return;
        }
        Integer localDepth = 0;
        boolean localTopLevel = this.getScriptRunnerContext().getTopLevel();
        localDepth = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
        URL baseURL = (URL)this.getScriptRunnerContext().getProperty("script.runner.base.url");
        String previousInputFile = this.getScriptRunnerContext().getSourceRef();
        ExecutePathCheckReturn retVal = this.checkMultiplePaths(this.cmd);
        if (retVal != null && (retVal.getLiveReader() != null || retVal.getUrl() != null)) {
            try {
                this._runner = retVal.getLiveReader() != null ? new ScriptExecutor(retVal.getLiveReader(), this.conn) : (this.getScriptRunnerContext().getEncoding() != null ? new ScriptExecutor(retVal.getUrl(), this.conn, this.getScriptRunnerContext().getEncoding()) : new ScriptExecutor(retVal.getUrl(), this.conn));
                String[] parserArgs = ScriptUtils.executeArgs(retVal.getArguments());
                if (parserArgs != null) {
                    for (int argCount = 0; argCount < parserArgs.length; ++argCount) {
                        Map<String, String> m = this.getScriptRunnerContext().getMap();
                        m.put(Integer.toString(argCount + 1), parserArgs[argCount]);
                    }
                }
                this._runner.setOut(this.out);
                if (localDepth < 20) {
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth + 1);
                    this.getScriptRunnerContext().setTopLevel(false);
                    this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                    Object pathval = null;
                    String inputFile = retVal.getOutputFile();
                    inputFile = retVal.getUrl() == null ? retVal.getOutputFile() : retVal.getUrl().toString();
                    SQLPLUSUtil.setExecutorPath(this._runner, inputFile, this.getScriptRunnerContext());
                    ArrayList scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
                    scrArrayList.add(retVal.getPreAppendInputFile());
                    this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
                    if (scrArrayList.size() != 0) {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                    }
                    this._runner.run();
                    this.getScriptRunnerContext().removeProperty("script.runner.sqlcl.execute.file");
                    if (baseURL != null) {
                        this.getScriptRunnerContext().putProperty("script.runner.base.url", baseURL);
                    }
                    if ((scrArrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist")).size() != 0) {
                        scrArrayList.remove(scrArrayList.size() - 1);
                    }
                    this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", scrArrayList);
                    if (scrArrayList.size() != 0) {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                    } else {
                        SetAppinfo.setAppinfo(this.getScriptRunnerContext(), this.getScriptRunnerContext().getCurrentConnection(), SQLPLUSUtil.getProductName(), 0);
                    }
                    this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                    this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                }
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("MAX_NEST"), this.getScriptRunnerContext()));
            }
            catch (FileNotFoundException fnfe) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", retVal.getPreAppendInputFile()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            catch (IOException ioe) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", retVal.getPreAppendInputFile()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            catch (ArgumentQuoteException aqe) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("QUOTEMISMATCH", aqe.getMessage()), this.getScriptRunnerContext()));
                this.doWhenever(false);
            }
            finally {
                this.getScriptRunnerContext().setTopLevel(localTopLevel);
                this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth);
                this.getScriptRunnerContext().setSourceRef(previousInputFile);
                if (retVal != null && retVal.getLiveReader() != null) {
                    try {
                        retVal.getLiveReader().close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                }
            }
        } else if (retVal != null) {
            if (retVal.getLastException() != null) {
                LOGGER.log(Level.FINE, retVal.getLastException().getStackTrace()[0].toString(), retVal.getLastException());
            }
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("UNABLE_TO_OPEN_FILE", retVal.getPreAppendInputFile()), this.getScriptRunnerContext()));
            this.doWhenever(false);
        } else if (this.cmd.getModifiedSQL().toLowerCase().equals("@@")) {
            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("INVALID_FILE_NAME"));
        } else {
            this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("INVALID_ARGUMENTS") + m_lineSeparator);
        }
        this.getScriptRunnerContext().removeProperty("script.runner.sqlcl.execute.file");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL joinUrl(boolean tryUrlAsDir, URL inURL, String inputf) {
        try {
            if (inURL == null || inputf == null) {
                return null;
            }
            Object urlString = inURL.toString();
            int lasts = ((String)urlString).lastIndexOf("/");
            int lastbs = ((String)urlString).lastIndexOf("\\");
            if (tryUrlAsDir) {
                if (lastbs > lasts) {
                    urlString = (String)urlString + "\\" + inputf.replace("/", "\\");
                    return new URL((String)urlString);
                } else {
                    if (lasts <= lastbs) return null;
                    urlString = (String)urlString + "/" + inputf.replace("\\", "/");
                }
                return new URL((String)urlString);
            } else if (lastbs > lasts) {
                urlString = ((String)urlString).substring(0, lastbs + 1) + inputf.replace("/", "\\");
                return new URL((String)urlString);
            } else {
                if (lasts <= lastbs) return null;
                urlString = ((String)urlString).substring(0, lasts + 1) + inputf.replace("\\", "/");
            }
            return new URL((String)urlString);
        }
        catch (Exception e) {
            return null;
        }
    }

    private InputStream getInputStream(String base) {
        if (!FileUtils.startsWithHttpOrFtp(base)) {
            return null;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (FileUtils.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            boolean wasException = false;
            try {
                c = new URL(base.replace("\\", "/")).openConnection();
            }
            catch (MalformedURLException e1) {
                wasException = true;
            }
            catch (IOException e1) {
                wasException = true;
            }
            if (wasException) {
                c = new URL(base.replace("//", "\\")).openConnection();
            }
            is = c.getInputStream();
        }
        catch (MalformedURLException e1) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return is;
    }

    private void runPrompt() {
        String localSql = this.cmd.getSql();
        localSql = localSql.trim();
        boolean found = false;
        int i = 0;
        for (i = 0; i < localSql.length(); ++i) {
            if (!Character.isWhitespace(localSql.charAt(i))) continue;
            found = true;
            break;
        }
        if (found) {
            this.report(this.getScriptRunnerContext(), localSql.substring(i).trim());
        } else {
            this.report(this.getScriptRunnerContext(), "");
        }
    }

    private void runPrint() {
        BindPrinter printer = new BindPrinter(this.getScriptRunnerContext(), this.out, this.getCmd());
        printer.runPrint();
    }

    private int indexOfFirstWhitespace(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isWhitespace(value.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runVariable() {
        String[] stringArray = SQLPLUSUtil.nextWordAndRest(this.cmd.getSql());
        if (stringArray[1].trim().equals("")) {
            Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
            Set<String> s = m.keySet();
            Map<String, Bind> map = m;
            synchronized (map) {
                Iterator<String> i = s.iterator();
                if (i.hasNext()) {
                    while (i.hasNext()) {
                        String nextKey = i.next();
                        Bind bind = m.get(nextKey);
                        String type = bind.getType();
                        String datatypeBracket = bind.getBracket();
                        String type2Show = datatypeBracket != null ? datatypeBracket : type;
                        String msg = "variable {0}\ndatatype {1}\n";
                        msg = MessageFormat.format(msg, bind.getPrintBind(), type2Show);
                        this.report(this.getScriptRunnerContext(), msg);
                    }
                } else {
                    this.report(this.getScriptRunnerContext(), "SP2-0568: No bind variables declared.\n");
                    this.getScriptRunnerContext().errorLog("", "SP2-0568: No bind variables declared.", this.cmd.getSql());
                }
            }
        }
        String localSubName = "";
        if (this.indexOfFirstWhitespace(stringArray[1]) == -1) {
            Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
            Set<String> s = m.keySet();
            Iterator<String> i = s.iterator();
            boolean found = false;
            while (i.hasNext()) {
                String nextKey = i.next();
                if (!stringArray[1].toLowerCase().equals(nextKey.toLowerCase())) continue;
                Bind bind = m.get(nextKey);
                String type = bind.getType();
                String datatypeBracket = bind.getBracket();
                String type2Show = datatypeBracket != null ? datatypeBracket : type;
                String msg = "variable {0}\ndatatype {1}\n";
                msg = MessageFormat.format(msg, bind.getPrintBind(), type2Show);
                this.report(this.getScriptRunnerContext(), msg);
                found = true;
            }
            if (!found) {
                String msg = ScriptRunnerDbArb.format("UNDECLARED_VARIABLE", stringArray[1]);
                this.report(this.getScriptRunnerContext(), msg);
                this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), msg, this.cmd.getSql());
            }
        } else {
            localSubName = stringArray[1].substring(0, this.indexOfFirstWhitespace(stringArray[1])).trim();
            String dataTypeString = "";
            dataTypeString = stringArray[1].substring(this.indexOfFirstWhitespace(stringArray[1]) + 1).trim();
            String[] typeNValue = dataTypeString.split("=");
            String dataType = typeNValue[0].trim();
            String varValue = "";
            if (typeNValue.length > 1) {
                varValue = typeNValue[1].trim();
            }
            String dataTypeBracket = this.validVariableDatatype(dataType, true);
            dataType = this.validVariableDatatype(dataType, false);
            if (Character.isLetter(localSubName.charAt(0))) {
                try {
                    if (dataTypeBracket == null || dataType == null || dataTypeBracket.replace(dataType, "").trim().equals("(0)")) {
                        String msg = ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName);
                        this.report(this.getScriptRunnerContext(), msg);
                        this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), msg, this.cmd.getSql());
                        return;
                    }
                    if (dataTypeBracket != null || dataType != null) {
                        String num_dtype = dataTypeBracket.replaceFirst(dataType, "").replace("(", "").replace(")", "").trim();
                        String[] dtype = num_dtype.split(" ");
                        if (dataTypeBracket.indexOf("(") != -1 && dtype.length > 0) {
                            long size = Long.parseLong(dtype[0].trim());
                            if (dtype.length > 1) {
                                String dataTypeLower = dataType.toLowerCase(Locale.US);
                                String second = dtype[1];
                                second = second != null ? second.toLowerCase(Locale.US) : "";
                                if (dtype.length > 2 || !dataTypeLower.equals("char") && !dataTypeLower.equals("varchar2") || !second.equals("byte") && !second.equals("char")) {
                                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName));
                                    this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName), this.cmd.getSql());
                                    return;
                                }
                                if (dtype[1].trim().equalsIgnoreCase("char") || dtype[1].trim().equalsIgnoreCase("byte")) {
                                    if (size > 2000L) {
                                        this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("INVALID_VARIABLE_LENGTH") + m_lineSeparator);
                                        return;
                                    }
                                    if (size < 1L) {
                                        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ILLEGAL_USAGE", localSubName));
                                        return;
                                    }
                                }
                            }
                        }
                        if (typeNValue.length > 1) {
                            // empty if block
                        }
                        Bind bind = new Bind(localSubName.toUpperCase(), dataType.toUpperCase(), dataTypeBracket.toUpperCase(), localSubName, typeNValue.length > 1 ? typeNValue[1].trim().replaceAll("^\"|\"$|^'|'$", "") : null, localSubName);
                        bind.setPrintBind(localSubName);
                        Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
                        m.put(localSubName.toUpperCase(), bind);
                    }
                }
                catch (NumberFormatException e) {
                    this.getScriptRunnerContext().write(ScriptRunnerDbArb.getString("INVALID_VARIABLE_LENGTH") + m_lineSeparator);
                }
            } else {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("ILLEGAL_VARIABLE", localSubName));
            }
        }
    }

    private boolean containsNoBackSlash(String check) {
        if (Aliases.getInstance().contains(check)) {
            return true;
        }
        String checkNoBSlash = check.replace("\\", "");
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        for (String curAlias : aliases) {
            if (!curAlias.replace("\\", "").equals(checkNoBSlash)) continue;
            return true;
        }
        return false;
    }

    private Alias getNoBackslash(String check) {
        Alias a = Aliases.getInstance().get(check);
        if (a != null) {
            return a;
        }
        String checkNoBSlash = check.replace("\\", "");
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        for (String curAlias : aliases) {
            if (!curAlias.replace("\\", "").equals(checkNoBSlash)) continue;
            return Aliases.getInstance().get(curAlias);
        }
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "SQLPLUS.getNoBackslash:null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAliases() throws ArgumentQuoteException {
        if (!this.getScriptRunnerContext().isProductNameSQLDeveloper() && !this.getScriptRunnerContext().isProductNameSQLcl()) {
            return false;
        }
        String localSql = this.cmd.getSql().trim();
        String[] tokens = localSql.split("\\s+");
        Object command = "";
        String args = "";
        if (tokens.length > 0) {
            Alias textFlag;
            String trim;
            String theText = "";
            boolean theNulls = false;
            boolean isHostAlias = false;
            if (tokens.length > 1 && this.containsNoBackSlash(tokens[0] + tokens[1])) {
                command = tokens[0] + tokens[1];
                if (tokens.length > 2) {
                    trim = this.cmd.getSql().trim();
                    trim = trim.substring(trim.indexOf(tokens[0]) + tokens[0].length()).trim();
                    args = trim.substring(trim.indexOf(tokens[1]) + tokens[1].length()).trim();
                }
                textFlag = this.getNoBackslash((String)command);
                theText = this.conn != null ? textFlag.getQuery(DefaultConnectionIdentifier.createIdentifier(this.conn)) : textFlag.getQuery(new Version("8"));
                theNulls = textFlag.isNullDefaults();
            } else if (this.containsNoBackSlash(tokens[0])) {
                command = tokens[0];
                if (tokens.length > 1) {
                    trim = this.cmd.getSql().trim();
                    args = trim.substring(trim.indexOf(tokens[0]) + tokens[0].length()).trim();
                }
                textFlag = this.getNoBackslash((String)command);
                theText = this.conn != null ? textFlag.getQuery(DefaultConnectionIdentifier.createIdentifier(this.conn)).trim() : textFlag.getQuery(new Version("8")).trim();
                theNulls = textFlag.isNullDefaults();
                isHostAlias = Alias.isHostCommand(theText);
            }
            if (theText != null && !theText.equals("")) {
                ArrayList<String> bindsToBeRemoved = new ArrayList<String>();
                ArrayList<String> bindsSetToNull = new ArrayList<String>();
                String errorMessage = "";
                Integer localDepth = 0;
                String localSourceRef = this.getScriptRunnerContext().getSourceRef();
                boolean localTopLevel = this.getScriptRunnerContext().getTopLevel();
                localDepth = this.getScriptRunnerContext().getTopLevel() || this.getScriptRunnerContext().getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.getScriptRunnerContext().getProperty("script.runner.script_depth");
                Boolean lastEOF = (Boolean)this.getScriptRunnerContext().getProperty("sqcl.alias.end_statement_on_eof");
                if (lastEOF == null) {
                    lastEOF = Boolean.FALSE;
                }
                try {
                    String[] parserArgs;
                    this.getScriptRunnerContext().putProperty("sqcl.alias.end_statement_on_eof", Boolean.TRUE);
                    ScriptParser sp = new ScriptParser(theText);
                    if (this.getScriptRunnerContext().isCommandLine()) {
                        sp.setScriptRunnerContext(this.getScriptRunnerContext());
                    }
                    if ((parserArgs = ScriptUtils.executeArgs(args)) == null) {
                        parserArgs = new String[]{};
                    }
                    ISQLCommand icmd = null;
                    int nextArg = 0;
                    String startNoBinds = "";
                    boolean startNoBindsInit = false;
                    if (this.getScriptRunnerContext().getVarMap().containsKey(SPECIALBINDFORALIASNULLS)) {
                        startNoBinds = this.getScriptRunnerContext().getVarMap().get(SPECIALBINDFORALIASNULLS).getValue();
                    } else {
                        startNoBindsInit = true;
                    }
                    while ((icmd = sp.next()) != null) {
                        try {
                            if (isHostAlias) {
                                ArrayList<Bind> parsedHostBinds = Parser.getInstance().getHostBinds(icmd.getSql(), false);
                                for (Bind b : parsedHostBinds) {
                                    if (this.getScriptRunnerContext().getVarMap().containsKey(b.getName().toUpperCase())) continue;
                                    if (nextArg < parserArgs.length) {
                                        theText = theText.replace("${" + b.getName() + "}", parserArgs[nextArg]);
                                        ++nextArg;
                                        continue;
                                    }
                                    if (!theNulls) {
                                        errorMessage = ScriptRunnerDbArb.getString("ALIASWITHBINDS_NOTENOUGH");
                                        continue;
                                    }
                                    theText = theText.replace("${" + b.getName() + "}", "");
                                }
                                continue;
                            }
                            ArrayList<Bind> parsedBinds = Parser.getInstance().getBinds(icmd.getSql(), false);
                            for (Bind b : parsedBinds) {
                                Bind bind;
                                if (this.getScriptRunnerContext().getVarMap().containsKey(b.getName().toUpperCase()) || b.getName().equals(SPECIALBINDFORALIASNULLS)) continue;
                                if (nextArg < parserArgs.length) {
                                    bind = new Bind(b.getName().toUpperCase(), "VARCHAR2", "VARCHAR2(1000)", b.getName().toUpperCase(), parserArgs[nextArg], b.getName().toUpperCase());
                                    ++nextArg;
                                    this.getScriptRunnerContext().getVarMap().put(b.getName().toUpperCase(), bind);
                                    bindsToBeRemoved.add(b.getName().toUpperCase());
                                    continue;
                                }
                                if (!theNulls) {
                                    errorMessage = ScriptRunnerDbArb.getString("ALIASWITHBINDS_NOTENOUGH");
                                    continue;
                                }
                                bind = new Bind(b.getName().toUpperCase(), "VARCHAR2", "VARCHAR2(1000)", b.getName().toUpperCase(), "", b.getName().toUpperCase());
                                this.getScriptRunnerContext().getVarMap().put(b.getName().toUpperCase(), bind);
                                bindsToBeRemoved.add(b.getName().toUpperCase());
                                bindsSetToNull.add(b.getName().toUpperCase());
                            }
                            Object special = " ";
                            for (String bindset : bindsSetToNull) {
                                special = (String)special + ":" + bindset + " ";
                                Bind bind = new Bind(SPECIALBINDFORALIASNULLS, "VARCHAR2", "VARCHAR2(1000)", SPECIALBINDFORALIASNULLS, (String)special, SPECIALBINDFORALIASNULLS);
                                this.getScriptRunnerContext().getVarMap().put(SPECIALBINDFORALIASNULLS, bind);
                            }
                        }
                        catch (Throwable t) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, t.getMessage());
                        }
                    }
                    if (nextArg != parserArgs.length) {
                        errorMessage = ScriptRunnerDbArb.getString("ALIASWITHBINDS_TOOMANY");
                    }
                    if (localDepth > 20) {
                        errorMessage = this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString()) ? ScriptRunnerDbArb.getString("MAX_NEST_CLASSIC") : ScriptRunnerDbArb.getString("MAX_NEST");
                    }
                    if (errorMessage.equals("")) {
                        this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth + 1);
                        this.getScriptRunnerContext().setTopLevel(false);
                        this._runner = new ScriptExecutor(theText, this.conn);
                        this._runner.setOut(this.out);
                        this._runner.setScriptRunnerContext(this.getScriptRunnerContext());
                        this._runner.setDirectory(this.getDirectory());
                        this._runner.run();
                        this.setScriptRunnerContext(this._runner.getScriptRunnerContext());
                        this.setConn(this._runner.getScriptRunnerContext().getCurrentConnection());
                    } else {
                        this.report(this.getScriptRunnerContext(), errorMessage);
                        errorMessage = "";
                    }
                    for (String bindName : bindsToBeRemoved) {
                        this.getScriptRunnerContext().getVarMap().remove(bindName);
                    }
                    if (startNoBindsInit) {
                        this.getScriptRunnerContext().getVarMap().remove(SPECIALBINDFORALIASNULLS);
                    } else {
                        Bind bind = new Bind(SPECIALBINDFORALIASNULLS, "VARCHAR2", "VARCHAR2(1000)", SPECIALBINDFORALIASNULLS, startNoBinds, SPECIALBINDFORALIASNULLS);
                        this.getScriptRunnerContext().getVarMap().put(SPECIALBINDFORALIASNULLS, bind);
                    }
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getLocalizedMessage());
                }
                finally {
                    this.getScriptRunnerContext().putProperty("sqcl.alias.end_statement_on_eof", lastEOF);
                    for (String bindName : bindsToBeRemoved) {
                        this.getScriptRunnerContext().getVarMap().remove(bindName);
                    }
                    this.getScriptRunnerContext().setTopLevel(localTopLevel);
                    this.getScriptRunnerContext().putProperty("script.runner.script_depth", localDepth);
                    this.getScriptRunnerContext().setSourceRef(localSourceRef);
                }
                if (errorMessage != null && !errorMessage.equals("")) {
                    this.report(this.getScriptRunnerContext(), errorMessage);
                }
                return true;
            }
        }
        return false;
    }

    private String runCall(ISQLCommand cmd) {
        String theCommand = cmd.getSql().trim();
        List src = Lexer.parse((String)theCommand, (boolean)false);
        int listLength = src.size();
        boolean callFound = false;
        callFound = listLength > 0 && ((LexerToken)src.get((int)0)).content.trim().equalsIgnoreCase("call");
        boolean openBracketFound = false;
        if (callFound) {
            for (int i = 1; i < src.size(); ++i) {
                if (!((LexerToken)src.get((int)i)).content.trim().equals("(")) continue;
                openBracketFound = true;
                break;
            }
        }
        boolean closedBracket = false;
        if (openBracketFound) {
            int startAt = src.size() - 1;
            if (startAt > 0 && ((LexerToken)src.get((int)startAt)).content.trim().equals(";")) {
                --startAt;
            }
            String bind = null;
            if (startAt - 1 > 0 && ((LexerToken)src.get((int)(startAt - 1))).content.trim().equals(":") && startAt - 2 > 0 && ((LexerToken)src.get((int)(startAt - 2))).content.trim().equalsIgnoreCase("INTO") && startAt - 3 > 0 && ((LexerToken)src.get((int)(startAt - 3))).content.trim().equals(")")) {
                bind = ((LexerToken)src.get((int)startAt)).content.trim();
            }
            boolean noBindMatch = false;
            boolean bl = noBindMatch = startAt > 0 && ((LexerToken)src.get((int)startAt)).content.trim().equals(")");
            if (bind != null || noBindMatch) {
                LexerToken end = (LexerToken)src.get(startAt);
                if (bind != null) {
                    end = (LexerToken)src.get(startAt - 3);
                }
                LexerToken start = (LexerToken)src.get(1);
                StringBuilder buildNew = new StringBuilder("exec ");
                if (bind != null) {
                    buildNew.append(":").append(bind).append(":=");
                }
                buildNew.append(theCommand.substring(start.begin, end.end)).append(";");
                return buildNew.toString();
            }
        }
        this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("CALL_COMMAND"));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecute() {
        if (this.getScriptRunnerContext().getCurrentConnection() != null && this.getScriptRunnerContext().getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            this.getScriptRunnerContext().write("Not supported for nucleo connection\n");
            return;
        }
        this.cmd.setSql(SQLPLUSUtil.removeDashNewline(this.cmd, this.cmd.getSql()));
        boolean wasCall = false;
        if (this.cmd.getLoweredTrimmedSQL().startsWith("call")) {
            wasCall = true;
            this.cmd.setStmtType(SQLCommand.StmtType.G_C_SQL);
            String converted = this.runCall(this.cmd);
            if (converted.equals("")) {
                return;
            }
            this.cmd.setSql(converted);
        }
        String localSql = this.cmd.getSql();
        localSql = localSql.trim();
        boolean found = false;
        for (int i = 0; i < localSql.length(); ++i) {
            if (!Character.isWhitespace(localSql.charAt(i))) continue;
            found = true;
            localSql = localSql.substring(i);
            break;
        }
        if (found) {
            String anonymousBlock = "BEGIN" + localSql + (localSql.endsWith(";") ? "" : ";") + " END;";
            Literals2Binds bp = null;
            bp = this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals") == null ? (this.cmd.getEndLine() - this.cmd.getStartLine() < 20 ? Literals2Binds.bindAid(anonymousBlock) : Literals2Binds.Literals2BindsNull(anonymousBlock)) : (this.getScriptRunnerContext().getProperty("sqlcl.script.secureliterals").equals("ON") ? Literals2Binds.bindAid(anonymousBlock) : Literals2Binds.Literals2BindsNull(anonymousBlock));
            this.cmd.setSql(bp.getSql());
            if (!wasCall) {
                this.cmd.setSQLOrig(anonymousBlock);
                this.cmd.setProperty("prop_post_substitution", anonymousBlock);
            }
            PLSQL plsql = new PLSQL(this.cmd, this.out);
            Map<String, String> bindsMap = bp.getBinds();
            for (String bindName : bindsMap.keySet()) {
                Bind b = new Bind();
                b.setName(bindName);
                b.setType("VARCHAR2");
                b.setValue(bindsMap.get(bindName));
                this.getScriptRunnerContext().getVarMap().put(bindName, b);
            }
            plsql.setScriptRunnerContext(this.getScriptRunnerContext());
            plsql.setConn(this.conn);
            try {
                plsql.run();
            }
            finally {
                for (String bindName : bindsMap.keySet()) {
                    this.getScriptRunnerContext().getVarMap().remove(bindName);
                }
                plsql = null;
            }
        } else if (localSql.trim().toLowerCase().equals("exec") || localSql.trim().toLowerCase().equals("execute")) {
            this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("EXEC_COMMAND"));
        } else {
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("MALFORMED_EXECUTE_CONTENT", this.cmd.getSql()), this.getScriptRunnerContext()));
        }
    }

    protected String validVariableDatatype(String str, boolean withBracket) {
        String dataTypeRegex = null;
        StringBuilder sb = new StringBuilder();
        sb.append("NUMBER");
        sb.append("|CHAR([\\s]*\\([\\s]*\\d+[\\s]*[CHAR|BYTE]*[\\s]*\\))*");
        sb.append("|NCHAR([\\s]*\\([\\s]*\\d+[\\s]*\\))*");
        sb.append("|VARCHAR2([\\s]*\\([\\s]*\\d+[\\s]*[CHAR|BYTE]*[\\s]*\\))*");
        sb.append("|NVARCHAR2([\\s]*\\([\\s]*\\d+[\\s]*\\))*");
        sb.append("|CLOB");
        sb.append("|NCLOB");
        sb.append("|BLOB");
        sb.append("|BFILE");
        sb.append("|REFCURSOR");
        sb.append("|BINARY_FLOAT");
        sb.append("|BINARY_DOUBLE");
        dataTypeRegex = sb.toString();
        Pattern pat = Pattern.compile(dataTypeRegex);
        Matcher matcher = pat.matcher(str.toUpperCase());
        if (matcher.matches()) {
            String ret = matcher.group();
            if (withBracket && ret.indexOf(")") > 0) {
                return ret.substring(0, ret.indexOf(")") + 1).trim().toUpperCase();
            }
            if (ret.indexOf("(") > 0) {
                return ret.substring(0, ret.indexOf("(")).trim().toUpperCase();
            }
            return ret.trim().toUpperCase();
        }
        return null;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }
}

