/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;

public class TaskLinkedList<S>
extends LinkedList<RaptorTask<?>> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(RaptorTask<?> o) {
        boolean ret = true;
        TaskLinkedList taskLinkedList = this;
        synchronized (taskLinkedList) {
            ret = super.offer(o);
            this.notify();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean ret = true;
        TaskLinkedList taskLinkedList = this;
        synchronized (taskLinkedList) {
            ret = super.remove(o);
            this.notify();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaptorTask<?> takeNextTask(Collection<RaptorTask<?>> runningTaskList) throws InterruptedException {
        RaptorTask<?> nextTask = null;
        TaskLinkedList taskLinkedList = this;
        synchronized (taskLinkedList) {
            while (this.getNextTask(runningTaskList) == null) {
                this.wait();
            }
            nextTask = this.getNextTask(runningTaskList);
            this.remove(nextTask);
        }
        return nextTask;
    }

    private RaptorTask<?> getNextTask(Collection<RaptorTask<?>> runningTaskList) {
        RaptorTask elementToReturn = null;
        for (RaptorTask element : this) {
            RaptorTask<?> conflictingTask = this.getConflictingTask(element, runningTaskList);
            if (conflictingTask != null) {
                element.getDescriptor().setMessage(MessageFormat.format(Messages.getString("TaskLinkedList.0"), conflictingTask.getDescriptor().getName()));
                continue;
            }
            if (elementToReturn != null) continue;
            elementToReturn = element;
        }
        return elementToReturn;
    }

    private RaptorTask<?> getConflictingTask(RaptorTask<?> raptorTask, Collection<RaptorTask<?>> runningTaskList) {
        ISchedulingRule currentTaskRule = raptorTask.getSchedulingRule();
        if (currentTaskRule == null) {
            return null;
        }
        for (RaptorTask<?> task : runningTaskList) {
            ISchedulingRule runningTaskRule;
            if (task.getStatus() == IRaptorTaskStatus.FINISHED || task.getStatus() == IRaptorTaskStatus.FAILED || task.getSchedulingRule() == null || !currentTaskRule.isConflicting(runningTaskRule = task.getSchedulingRule()) && !runningTaskRule.isConflicting(currentTaskRule)) continue;
            return task;
        }
        return null;
    }
}

