/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.commands.sql.Query;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class ExecuteSql
extends CodeLens {
    static final String normalTitle = "Execute statement:";
    static final String cancelTitle = "Cancel running statement:";
    Statement stmt = null;

    public ExecuteSql(ParseNode node, BackgroundParser parser) {
        super(node, normalTitle, parser);
    }

    @Override
    public Object executeCommand() {
        return this.executeCommand(Query.Mode.Standalone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(Query.Mode mode) {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
                this.command.title = normalTitle;
                this.parser.documentBump();
                String string = "OK";
                return string;
            }
            catch (SQLException e) {
                if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                    LSP.Log.log(Level.SEVERE, e.getMessage(), e);
                }
                ResponseError responseError = new ResponseError(-32603, Util.sugarcoatText((String)e.getMessage()), (Object)this.stmt);
                return responseError;
            }
            finally {
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        Object s = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        if (((String)s).toUpperCase().startsWith("EXECUTE ")) {
            s = "begin \n" + ((String)s).substring("EXECUTE ".length()) + "\n end;";
        } else if (((String)s).endsWith(";") & !this.node.contains("block_stmt")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        } else if (((String)s).endsWith("/")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        Object sql = s;
        LanguageServer server = this.parser.languageServer;
        Object conn = this.parser.getRegistry().getConnection();
        if (conn == null || !(conn instanceof Connection)) {
            return new ResponseError(-32603, "Not connected", (Object)server.getLastUrl());
        }
        try {
            this.stmt = ((Connection)conn).createStatement();
            if (mode == Query.Mode.Standalone) {
                this.command.title = cancelTitle;
                this.parser.documentBump();
                this.parser.resetDiagnostics();
                new Thread((String)sql){
                    final /* synthetic */ String val$sql;
                    {
                        this.val$sql = string;
                    }

                    @Override
                    public void run() {
                        ExecuteSql.this.command(this.val$sql, Query.Mode.Script0);
                    }
                }.start();
            } else {
                this.command((String)sql, mode);
            }
            return "OK";
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
            return new ResponseError(-32603, Util.sugarcoatText((String)e.getMessage()), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void command(String sql, Query.Mode mode) {
        LanguageServer server = this.parser.languageServer;
        try {
            this.stmt.execute(sql);
            server.logStatement(sql);
            String abbrSql = 20 < sql.length() ? sql.substring(0, 20) : sql;
            System.out.println(abbrSql + "...finished");
            LSP.windowShowMessage("Statement finished", 3);
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) && !(e instanceof SQLSyntaxErrorException)) {
                LSP.Log.log(Level.SEVERE, e.getMessage(), e);
            }
            if (e instanceof SQLException) {
                this.parser.failedCommand(this.node, e);
            }
        }
        finally {
            if (mode == Query.Mode.Standalone) {
                server.documentsBump();
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                    this.stmt = null;
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

