/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.arbori;

import java.io.IOException;
import java.util.Map;
import oracle.arbori.scripting.GlobalMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.commands.arbori.Query;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.plsql.SqlEarley;

public class RunScript
extends CodeLens {
    static final String normalTitle = "Run Script";
    public boolean output2file = true;

    public RunScript(BackgroundParser parser) {
        this(parser, normalTitle);
    }

    public RunScript(BackgroundParser parser, String title) {
        super(new ParseNode(0, 0, -1, null), title, parser);
    }

    @Override
    public Object executeCommand() {
        String conn = this.parser.getRegistry().fullConnString();
        if (conn == null) {
            Position start = new Position(0, 0);
            Position end = new Position(0, 3);
            Range range = new Range(start, end);
            String msg = "Not connected to SQL file";
            this.parser.diagnostics.add(new Diagnostics(range, msg));
            this.parser.documentBump();
            return new ResponseError(-32603, msg, (Object)"");
        }
        GlobalMap _globals = this.parser.program.getGlobals();
        if (_globals != null) {
            _globals.put("parser", (Object)this.parser);
            _globals.put("thisCommand", (Object)this);
            _globals.put("lsp", (Object)this.parser.getLanguageServer().getLSP());
            _globals.put("server", (Object)this.parser.getLanguageServer());
            _globals.put("rootUri", (Object)this.parser.getLanguageServer().rootUri);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    RunScript.runArboriScript(RunScript.this.parser, RunScript.this.output2file);
                }
                catch (Throwable e) {
                    if (e instanceof ScriptException) {
                        e = RunScript.this.processScriptException(e);
                    } else if (e instanceof javax.script.ScriptException) {
                        e = RunScript.this.processScriptException(e);
                    } else {
                        e.printStackTrace();
                    }
                    RunScript.this.parser.failedCommand(RunScript.this.node, e);
                    LSP.windowShowMessage("Script Error", 1);
                }
                finally {
                    RunScript.this.parser.documentBump();
                    Object connection = RunScript.this.parser.getRegistry().getConnection();
                    ((BackgroundParser)connection).documentBump();
                }
            }
        }.start();
        return "OK";
    }

    public static void runArboriScript(BackgroundParser parser, boolean output2file) throws IOException, javax.script.ScriptException, AssertionError, ScriptException {
        LanguageServer server = parser.languageServer;
        Object connection = parser.getRegistry().getConnection();
        Program r = new Program((Earley)SqlEarley.getInstance(), null, parser.program.getEngine(), parser.program.getGlobals(), true){

            public Boolean getBoolBindVar(String name) {
                return true;
            }
        };
        r.compile(parser.text, null, true);
        r.setStruct((Object)server);
        String conn = parser.getRegistry().fullConnString();
        if (conn != null) {
            if (conn.charAt(0) == '\"') {
                conn = conn.substring(1, conn.length() - 1);
            }
            r.setTargetFileName(conn);
        }
        parser.resetDiagnostics();
        Map output = r.eval();
        if (output2file) {
            StringBuilder ret = new StringBuilder();
            for (String t : output.keySet()) {
                if (t.startsWith("anonymous JS Block")) continue;
                ret.append(t + ":\n");
                ret.append("===============\n");
                MaterializedPredicate p = (MaterializedPredicate)output.get(t);
                ret.append(Query.render(p, (BackgroundParser)connection));
                ret.append("\n");
            }
            String fileExt = ".output.csv";
            String uri = server.getLastUrl().substring(1, server.getLastUrl().length() - 1) + fileExt;
            server.getLSP().createFile(uri, ret.toString());
        }
        LSP.windowShowMessage("Script finished", 3);
    }
}

