/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.insight;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.db.LockManager;

public class UsersCache {
    public int schema = -1;
    public String schemaName = null;
    private Map<String, Integer> userCodes = new HashMap<String, Integer>();
    public boolean isObjQueriable = false;
    public static Map<String, UsersCache> usersAtConnection = new HashMap<String, UsersCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsersCache fillIn(String connName) {
        UsersCache ret = usersAtConnection.get(connName);
        if (ret != null) {
            return ret;
        }
        long t1 = System.currentTimeMillis();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        boolean locked = false;
        int maxUser = 0;
        try {
            conn = ChameleonConnection.getConnection(connName);
            locked = LockManager.tryLock(conn, 10000L);
            if (!locked) {
                UsersCache usersCache = null;
                return usersCache;
            }
            ps = conn.prepareStatement("select user_id, username, SYS_CONTEXT('USERENV','CURRENT_SCHEMA') current_schema from all_users");
            ps.setFetchSize(10000);
            rs = ps.executeQuery();
            ret = new UsersCache();
            while (rs.next()) {
                String userName = rs.getString("username");
                int userId = rs.getInt("user_id");
                if (userId > maxUser) {
                    maxUser = userId;
                }
                ret.schemaName = rs.getString("current_schema");
                ret.userCodes.put(userName, userId);
                if (ret.schema != -1 || !ret.schemaName.equals(userName)) continue;
                ret.schema = userId;
            }
            usersAtConnection.put(connName, ret);
            ps.close();
            ps = conn.prepareStatement("select 1 from sys.obj$ where 1=0");
            ps.executeQuery();
            ret.isObjQueriable = false;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (locked) {
                LockManager.unlock(conn);
            }
            long l = System.currentTimeMillis();
        }
        return ret;
    }

    public Integer getUserId(String name) {
        return this.userCodes.get(name);
    }

    public String getUserName(int id) {
        for (String ret : this.userCodes.keySet()) {
            if (id != this.userCodes.get(ret)) continue;
            return ret;
        }
        return "not_found?";
    }

    public List<String> prefixedUsers(String prefix) {
        LinkedList<String> ret = new LinkedList<String>();
        for (String user : this.userCodes.keySet()) {
            if (!user.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            ret.add(user);
        }
        return ret;
    }
}

