/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.db.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagValue;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NameProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ReplaceFlag;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.SavePasswordFlag;

public interface ConnectionSaveHandler {
    public void validateProperties(PropertyValues var1, Map<ConnectionProperty, String> var2);

    public void saveConnectionDetails(PropertyValues var1, Connection var2);

    public static String getName(PropertyValues props) {
        return props.getValueOf(NameProperty.SAVE);
    }

    public static boolean savePwd(PropertyValues props) {
        return FlagValue.PRESENT.equals((Object)props.getValueOf(SavePasswordFlag.SAVEPWD));
    }

    public static boolean replace(PropertyValues props) {
        return FlagValue.PRESENT.equals((Object)props.getValueOf(ReplaceFlag.REPLACE));
    }

    public static ConnectionSaveHandler createDefaultHandler(PropertyValues props) {
        return new DefaultSaveHandler(ConnectionSaveHandler.getName(props), ConnectionSaveHandler.replace(props), ConnectionSaveHandler.savePwd(props));
    }

    public static class DefaultSaveHandler
    implements ConnectionSaveHandler {
        private final String name;
        private final boolean replace;
        private final boolean nowpd;

        DefaultSaveHandler(String name, boolean replace, boolean nopwd) {
            this.name = name;
            this.replace = replace;
            this.nowpd = nopwd;
        }

        @Override
        public void validateProperties(PropertyValues props, Map<ConnectionProperty, String> connectionProperties) {
            if (this.name != null) {
                connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, Messages.getString("ConnectionSaveHandler.UNSUPPORTED_CONNECTOR"));
            } else {
                StringBuilder sb = new StringBuilder();
                if (this.nowpd) {
                    sb.append(Messages.getString("ConnectionSaveHandler.INVALID_SAVEPWD_OPTION"));
                }
                if (this.replace) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(Messages.getString("ConnectionSaveHandler.INVALID_REPLACE_OPTION"));
                }
                if (sb.length() > 0) {
                    connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, sb.toString());
                }
            }
        }

        @Override
        public void saveConnectionDetails(PropertyValues props, Connection conn) {
        }
    }
}

