/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.ora.BasicSupport;
import oracle.dbtools.connections.db.ora.BequeathSupport;
import oracle.dbtools.connections.db.ora.CloudSupport;
import oracle.dbtools.connections.db.ora.TnsSupport;
import oracle.dbtools.core.jdbc.DataSourceConfigurator;
import oracle.dbtools.core.jdbc.configurators.BasicConfiguration;
import oracle.dbtools.core.jdbc.configurators.ConfigurationException;

public interface OracleSubtypeConfigurator<T extends DataSourceConfigurator> {
    public static boolean isJDBCUrl(String url) {
        boolean valid = false;
        if (ModelUtil.hasLength(url)) {
            valid = true;
        }
        return valid;
    }

    public static OracleSubtypeConfigurator<? extends DataSourceConfigurator> lookupConfiguration(String type) {
        OracleSubtypeConfigurator<? extends DataSourceConfigurator> configuration = Registry.INSTANCE.lookupConfiguration(type);
        if (configuration == null) {
            // empty if block
        }
        return configuration;
    }

    public static boolean isPasswordProperty(String propName) {
        return Registry.INSTANCE.search(p -> p.encryptedProperties().contains(propName));
    }

    public static boolean isPathProperty(String propName) {
        return Registry.INSTANCE.search(p -> p.pathProperties().contains(propName));
    }

    public T createConfigurator(Properties var1) throws ConfigurationException;

    public String getConnectionURL(Properties var1) throws ConfigurationException;

    default public Set<String> encryptedProperties() {
        return Collections.singleton("password");
    }

    default public Set<String> pathProperties() {
        return Collections.EMPTY_SET;
    }

    public static class Registry {
        static final Registry INSTANCE = new Registry();
        private Map<String, OracleSubtypeConfigurator<? extends DataSourceConfigurator>> registry = new HashMap<String, OracleSubtypeConfigurator<? extends DataSourceConfigurator>>();

        private Registry() {
            this.registerConfiguration("BASIC", new BasicSupport());
            this.registerConfiguration("ADVANCED", new SimpleSubtypeSupport());
            this.registerConfiguration("BEQUEATH", new BequeathSupport());
            this.registerConfiguration("CLOUD", new CloudSupport());
            this.registerConfiguration("LDAP", new SimpleSubtypeSupport());
            this.registerConfiguration("TNS", new TnsSupport());
        }

        void registerConfiguration(String type, OracleSubtypeConfigurator<? extends DataSourceConfigurator> configuration) {
            this.registry.put(type, configuration);
        }

        OracleSubtypeConfigurator<? extends DataSourceConfigurator> lookupConfiguration(String type) {
            return this.registry.get(type);
        }

        boolean search(Predicate<OracleSubtypeConfigurator<? extends DataSourceConfigurator>> p) {
            return this.registry.values().stream().anyMatch(p);
        }
    }

    public static class SimpleSubtypeSupport
    implements OracleSubtypeConfigurator<BasicConfiguration> {
        @Override
        public final BasicConfiguration createConfigurator(Properties props) throws ConfigurationException {
            BasicConfiguration.Builder builder = BasicConfiguration.builder();
            String url = this.getConnectionURL(props);
            if (!ModelUtil.hasLength(url)) {
                throw new ConfigurationException("URL not specified");
            }
            builder.customURL(url);
            return builder.build();
        }

        @Override
        public String getConnectionURL(Properties props) throws ConfigurationException {
            return props.getProperty("customUrl");
        }
    }
}

