/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db;

import java.util.Properties;

public class JDBCParametersParser {
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String EQUALS = "=";

    public static String createParameterString(Properties jdbcParams) {
        String retval = null;
        if (jdbcParams != null && !jdbcParams.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            for (String key : jdbcParams.stringPropertyNames()) {
                String value = jdbcParams.getProperty(key);
                if (value == null) continue;
                if (buff.length() > 0) {
                    buff.append(SEMICOLON);
                }
                buff.append(key).append(EQUALS).append(value);
            }
            retval = buff.toString();
        }
        return retval;
    }

    public static void parseParameterString(String paramString, Properties jdbcParams) {
        if (paramString != null && paramString.length() > 0) {
            String[] split = paramString.contains(SEMICOLON) || !paramString.contains(COMMA) || !paramString.contains(EQUALS) ? paramString.split(SEMICOLON) : paramString.split(COMMA);
            for (String param : split) {
                String[] kv;
                if (param == null || param.length() <= 0 || (kv = param.split(EQUALS)).length != 2) continue;
                jdbcParams.put(kv[0].trim(), kv[1].trim());
            }
        }
    }
}

