/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

public final class ModelUtil {
    public static final boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static final boolean areDifferent(Object o1, Object o2) {
        return !ModelUtil.areEqual(o1, o2);
    }

    public static final boolean hasNonNullElement(Object[] array) {
        if (array != null) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                if (array[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    public static final String concat(String[] strs) {
        return ModelUtil.concat(strs, " ");
    }

    public static final String concat(String[] strs, String delim) {
        if (strs != null) {
            StringBuilder bld = new StringBuilder();
            for (String str : strs) {
                if (str == null) continue;
                bld.append(str).append(delim);
            }
            int length = bld.length();
            if (length > 0) {
                bld.setLength(length - 1);
            }
            return bld.toString();
        }
        return "";
    }

    public static final boolean hasLength(String s) {
        return ModelUtil.hasLength((CharSequence)s);
    }

    public static int hashCodeFor(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static final boolean hasLength(CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    public static final String nullifyIfEmpty(String s) {
        return ModelUtil.hasLength(s) ? s : null;
    }

    public static <T> T as(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }

    private ModelUtil() {
    }
}

