/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.Usage;

class Symbol {
    String name;
    SymbolTable scope;
    Loc loc;
    private PlsqlType type;
    private Usage assigned;

    Symbol(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
        Usage u;
        this.scope = scope;
        this.name = name == null ? "" : name;
        this.type = type;
        this.loc = loc;
        this.assigned = u = new Usage(this, loc, label);
        if (scope != null && !name.equals("")) {
            scope.define(this, loc);
        }
    }

    PlsqlType getType() {
        return this.type;
    }

    Loc getLoc() {
        return this.loc;
    }

    public Usage getAssigned() {
        return this.assigned;
    }

    void assignUsage(Usage u) {
        this.assigned = u;
    }

    void setScope(SymbolTable symbols) {
        this.scope = symbols;
    }

    public String toString() {
        return this.name + " " + String.valueOf(this.type);
    }

    static Symbol createSymbolForType(SymbolTable enclosingScope, String name, PlsqlType type, Loc loc, Object label) {
        switch (type.getTypeClass()) {
            case RECORD: {
                return new SymbolTable.RecordSym(name, enclosingScope, ((PlsqlType.Record)type).fields, loc);
            }
            case FUNCTION: {
                return new FunctionSym(enclosingScope, name, (PlsqlType.Function)type, loc, label);
            }
            case EXCEPTION: 
            case SCALAR: 
            case COLLECTION: {
                return new Symbol(enclosingScope, name, type, loc, null);
            }
        }
        throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_INTERNAL_ERROR, "Unexpected symbol type", type);
    }

    static class FunctionSym
    extends Symbol {
        FunctionSym(SymbolTable scope, String name, PlsqlType.Function type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
            this.name = name;
        }

        FunctionSym(SymbolTable scope, String name, ArrayList<ParmSpec> parms, Loc loc, Object label) {
            this(scope, name, new PlsqlType.Function(new FuncFormal(parms, loc, label)), loc, label);
            this.name = name;
        }

        FuncFormal addSignature(FuncFormal formal) {
            return this.getType().addSignature(formal);
        }

        List<FuncFormal> getOverloads() {
            return this.getType().getOverloads();
        }

        List<Loc> getAllLocs() {
            ArrayList<Loc> ret = new ArrayList<Loc>();
            for (FuncFormal formal : this.getOverloads()) {
                ret.add(formal.getLoc());
            }
            return ret;
        }

        @Override
        PlsqlType.Function getType() {
            return (PlsqlType.Function)super.getType();
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }

    static class ObjectSym
    extends Symbol {
        ObjectSym(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
        }
    }

    static class VariableSym
    extends Symbol {
        VariableSym(SymbolTable scope, String name, PlsqlType type, Loc loc, Object label) {
            super(scope, name, type, loc, label);
        }
    }
}

