/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;
import oracle.dbtools.parser.ParseNode;

abstract class PlsqlType {
    private TYPECLASS typeClass;
    private PlsqlType subtypeOf;
    private String constraint;
    private Predicate<PlsqlType> convertibleFrom;
    private static final int DOWNWARD_PENALTY = 5;

    private PlsqlType(TYPECLASS typeClass) {
        this.typeClass = typeClass;
        this.subtypeOf = null;
        this.constraint = null;
        this.convertibleFrom = type -> false;
    }

    PlsqlType(PlsqlType subtypeOf, String constraint) {
        this(subtypeOf.typeClass);
        this.subtypeOf = subtypeOf;
        this.constraint = constraint;
    }

    public TYPECLASS getTypeClass() {
        return this.typeClass;
    }

    boolean isConvertibleFrom(PlsqlType type) {
        return this.convertibleFrom.test(type);
    }

    static PlsqlType dangerousType() {
        return new Scalar(ScalarType.VARCHAR2, 32);
    }

    static PlsqlType safeType() {
        return new Scalar(ScalarType.BOOLEAN);
    }

    static ValueNode.ExprNode safeExprNode(ParseNode pos) {
        return new ValueNode.ExprNode(pos, (PlsqlType)new Scalar(ScalarType.BINARY_INTEGER, 4), Collections.emptyList());
    }

    public abstract boolean isInjectable();

    public String toString() {
        String ret = String.valueOf((Object)this.typeClass) + (String)(this.subtypeOf == null ? "" : "(of " + this.subtypeOf.toString() + ")") + (String)(this.constraint == null ? "" : " " + this.constraint);
        return ret;
    }

    static enum TYPECLASS {
        SCALAR,
        COLLECTION,
        RECORD,
        FUNCTION,
        EXCEPTION,
        ELLIPSIS,
        UNRESOLVED,
        SCOPE;

    }

    public static class Scalar
    extends PlsqlType {
        private ScalarType scalarType = null;
        private int scalarSize = Integer.MIN_VALUE;

        Scalar(ScalarType scalarType, int size) {
            super(TYPECLASS.SCALAR);
            this.scalarType = scalarType;
            this.scalarSize = size;
            this.convertibleFrom = type -> this.scalarImplicitlyConvertibleFrom((PlsqlType)type);
        }

        @Override
        public boolean isInjectable() {
            return this.scalarType.scalarClass.injectable;
        }

        Scalar(ScalarType scalarType) {
            this(scalarType, -1);
        }

        ScalarType getScalarType() {
            return this.scalarType;
        }

        ScalarClass getScalarClass() {
            if (this.scalarType == null) {
                return null;
            }
            return this.scalarType.scalarClass;
        }

        int getScalarSize() {
            return this.scalarSize;
        }

        private boolean scalarImplicitlyConvertibleFrom(PlsqlType fromType) {
            switch (fromType.typeClass.ordinal()) {
                case 0: {
                    return this.scalarType.scalarClass.implicitlyConvertibleFrom(((Scalar)fromType).scalarType.scalarClass);
                }
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + " " + String.valueOf((Object)this.scalarType) + (String)(this.scalarSize < 0 ? "" : "(" + this.scalarSize + ")");
        }
    }

    static final class ScalarType
    extends Enum<ScalarType> {
        public static final /* enum */ ScalarType PLS_INTEGER = new ScalarType(ScalarClass.NUMERIC, NumericFamily.INTEGER);
        public static final /* enum */ ScalarType BINARY_INTEGER = new ScalarType(ScalarClass.NUMERIC, NumericFamily.INTEGER);
        public static final /* enum */ ScalarType BINARY_FLOAT = new ScalarType(ScalarClass.NUMERIC, NumericFamily.FLOAT);
        public static final /* enum */ ScalarType BINARY_DOUBLE = new ScalarType(ScalarClass.NUMERIC, NumericFamily.DOUBLE);
        public static final /* enum */ ScalarType NUMBER = new ScalarType(ScalarClass.NUMERIC, NumericFamily.NUMBER);
        public static final /* enum */ ScalarType CHAR = new ScalarType(ScalarClass.CHAR, CharFamily.VARCHAR2);
        public static final /* enum */ ScalarType VARCHAR2 = new ScalarType(ScalarClass.CHAR, CharFamily.VARCHAR2);
        public static final /* enum */ ScalarType RAW = new ScalarType(ScalarClass.CHAR, CharFamily.VARCHAR2);
        public static final /* enum */ ScalarType NCHAR = new ScalarType(ScalarClass.CHAR, CharFamily.VARCHAR2);
        public static final /* enum */ ScalarType NVARCHAR2 = new ScalarType(ScalarClass.CHAR, CharFamily.VARCHAR2);
        public static final /* enum */ ScalarType ROWID = new ScalarType(ScalarClass.CHAR, CharFamily.UROWID);
        public static final /* enum */ ScalarType UROWID = new ScalarType(ScalarClass.CHAR, CharFamily.UROWID);
        public static final /* enum */ ScalarType LONG = new ScalarType(ScalarClass.LONG);
        public static final /* enum */ ScalarType LONG_RAW = new ScalarType(ScalarClass.RAW);
        public static final /* enum */ ScalarType BOOLEAN = new ScalarType(ScalarClass.BOOLEAN);
        public static final /* enum */ ScalarType DATE = new ScalarType(ScalarClass.DATE, DateFamily.DATE);
        public static final /* enum */ ScalarType TIMESTAMP = new ScalarType(ScalarClass.DATE, DateFamily.TIMESTAMP);
        public static final /* enum */ ScalarType INTERVAL = new ScalarType(ScalarClass.DATE, DateFamily.INTERVAL_YEAR_TO_MONTH);
        public static final /* enum */ ScalarType BFILE = new ScalarType(ScalarClass.BFILE);
        public static final /* enum */ ScalarType BLOB = new ScalarType(ScalarClass.BLOB);
        public static final /* enum */ ScalarType CLOB = new ScalarType(ScalarClass.CLOB);
        public static final /* enum */ ScalarType NCLOB = new ScalarType(ScalarClass.CLOB);
        private ScalarClass scalarClass;
        private NumericFamily numericFamily;
        private CharFamily charFamily;
        private DateFamily dateFamily;
        private static final /* synthetic */ ScalarType[] $VALUES;

        public static ScalarType[] values() {
            return (ScalarType[])$VALUES.clone();
        }

        public static ScalarType valueOf(String name) {
            return Enum.valueOf(ScalarType.class, name);
        }

        ScalarClass getScalarClass() {
            return this.scalarClass;
        }

        private ScalarType(ScalarClass scalarClass) {
            this.scalarClass = scalarClass;
            assert (scalarClass != ScalarClass.NUMERIC);
            assert (scalarClass != ScalarClass.CHAR);
            assert (scalarClass != ScalarClass.DATE);
        }

        private ScalarType(ScalarClass scalarClass, NumericFamily numericFamily) {
            this.scalarClass = scalarClass;
            this.numericFamily = numericFamily;
        }

        private ScalarType(ScalarClass scalarClass, CharFamily charFamily) {
            this.scalarClass = scalarClass;
            this.charFamily = charFamily;
        }

        private ScalarType(ScalarClass scalarClass, DateFamily dateFamily) {
            this.scalarClass = scalarClass;
            this.dateFamily = dateFamily;
        }

        static ScalarType fromString(String typeString) {
            if (!typeString.contains("'")) {
                Object newString = "";
                String sep = "";
                for (String word : typeString.split(" ")) {
                    newString = (String)newString + sep + "'" + word + "'";
                    sep = " ";
                }
                typeString = newString;
            }
            switch (typeString) {
                case "'BFILE'": 
                case "'BINARY'": 
                case "'BINARY' 'LARGE' 'OBJECT'": 
                case "'BLOB'": 
                case "'LONG' 'RAW'": {
                    return BLOB;
                }
                case "'BINARY_DOUBLE'": 
                case "'DOUBLE' 'PRECISION'": 
                case "'SIMPLE_DOUBLE'": {
                    return BINARY_DOUBLE;
                }
                case "'BINARY_FLOAT'": 
                case "'SIMPLE_FLOAT'": {
                    return BINARY_FLOAT;
                }
                case "'BINARY_INTEGER'": {
                    return BINARY_INTEGER;
                }
                case "'BOOLEAN'": {
                    return BOOLEAN;
                }
                case "'CHAR'": 
                case "'CHARACTER'": {
                    return CHAR;
                }
                case "'CHAR' 'LARGE' 'OBJECT'": 
                case "'CHARACTER' 'LARGE' 'OBJECT'": 
                case "'CLOB'": {
                    return CLOB;
                }
                case "'CHAR' 'VARYING'": 
                case "'CHARACTER' 'VARYING'": 
                case "'RAW'": 
                case "'VARCHAR'": 
                case "'VARCHAR2'": {
                    return VARCHAR2;
                }
                case "'COLUMNS'": 
                case "'COLUMNS' 'WITH' 'TYPE'": {
                    return null;
                }
                case "'DEC'": 
                case "'DECIMAL'": 
                case "'FLOAT'": 
                case "'NUMBER'": 
                case "'NUMERIC'": 
                case "'POSITIVE'": 
                case "'POSITIVEN'": 
                case "'REAL'": 
                case "'SIGNTYPE'": 
                case "'SMALLINT'": {
                    return NUMBER;
                }
                case "'INT'": 
                case "'INTEGER'": 
                case "'NATURAL'": 
                case "'NATURALN'": 
                case "'PLS_INTEGER'": 
                case "'SIMPLE_INTEGER'": {
                    return PLS_INTEGER;
                }
                case "'LONG'": {
                    return LONG;
                }
                case "'MLSLABEL'": {
                    return null;
                }
                case "'NATIONAL'": 
                case "'NATIONAL' 'CHAR'": 
                case "'NATIONAL' 'CHARACTER'": 
                case "'NCHAR'": {
                    return NCHAR;
                }
                case "'NATIONAL' 'CHAR' 'VARYING'": 
                case "'NATIONAL' 'CHARACTER' 'VARYING'": 
                case "'NCHAR' 'VARYING'": 
                case "'NVARCHAR2'": {
                    return NVARCHAR2;
                }
                case "'NATIONAL' 'CHARACTER' 'LARGE' 'OBJECT'": 
                case "'NCHAR' 'LARGE' 'OBJECT'": 
                case "'NCLOB'": {
                    return NCLOB;
                }
                case "'REF' 'XMLTYPE'": 
                case "'REF' link_expanded_n": {
                    return null;
                }
                case "'ROWID'": {
                    return ROWID;
                }
                case "'STRING'": {
                    return VARCHAR2;
                }
                case "'SYS_REFCURSOR'": {
                    return null;
                }
                case "'TABLE'": {
                    return null;
                }
                case "'UROWID'": {
                    return UROWID;
                }
                case "'XMLTYPE'": {
                    return null;
                }
            }
            return null;
        }

        private static /* synthetic */ ScalarType[] $values() {
            return new ScalarType[]{PLS_INTEGER, BINARY_INTEGER, BINARY_FLOAT, BINARY_DOUBLE, NUMBER, CHAR, VARCHAR2, RAW, NCHAR, NVARCHAR2, ROWID, UROWID, LONG, LONG_RAW, BOOLEAN, DATE, TIMESTAMP, INTERVAL, BFILE, BLOB, CLOB, NCLOB};
        }

        static {
            $VALUES = ScalarType.$values();
        }
    }

    public static class Exception
    extends PlsqlType {
        Exception() {
            super(TYPECLASS.EXCEPTION);
        }

        @Override
        public boolean isInjectable() {
            return false;
        }
    }

    public static class Collection
    extends PlsqlType {
        PlsqlType collectionOf;

        Collection(PlsqlType collectionOf) {
            super(TYPECLASS.COLLECTION);
            this.collectionOf = collectionOf;
        }

        @Override
        public boolean isInjectable() {
            return true;
        }

        PlsqlType collectionOf() {
            return this.collectionOf;
        }
    }

    static enum DateFamily {
        DATE,
        TIMESTAMP,
        TIMESTAMP_WITH_TIME_ZONE,
        INTERVAL_YEAR_TO_MONTH,
        TIMESTAMP_WITH_LOCAL_TIME_ZONE;

    }

    static enum CharFamily {
        VARCHAR2,
        MLSLABEL,
        UROWID;

    }

    static enum NumericFamily {
        INTEGER,
        NUMBER,
        FLOAT,
        DOUBLE;


        static int match(NumericFamily from, NumericFamily to) {
            if (from.ordinal() <= to.ordinal()) {
                return to.ordinal() - from.ordinal();
            }
            return from.ordinal() - to.ordinal() + NumericFamily.values().length;
        }
    }

    static enum ScalarClass {
        CHAR,
        DATE,
        NUMERIC(false),
        LONG,
        RAW,
        CLOB,
        BLOB,
        BOOLEAN(false),
        BFILE;

        static int size;
        int idx;
        final boolean injectable;
        boolean[][] implicitConv = new boolean[][]{{true, true, true, true, true, true, false, false, false}, {true, true, false, false, false, false, false, false, false}, {true, false, true, false, false, false, false, false, false}, {true, false, false, true, true, true, false, false, false}, {true, false, false, true, true, false, true, false, false}, {true, false, false, true, false, true, false, false, false}, {false, false, false, false, true, false, true, false, false}, {false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false}};

        private ScalarClass() {
            this.injectable = true;
        }

        private ScalarClass(boolean injectable) {
            this.injectable = injectable;
        }

        boolean implicitlyConvertibleFrom(ScalarClass fromType) {
            return this.implicitConv[fromType.ordinal()][this.ordinal()];
        }

        static {
            size = 0;
        }
    }

    static class Scope
    extends PlsqlType {
        Scope() {
            super(TYPECLASS.SCOPE);
        }

        @Override
        public boolean isInjectable() {
            return false;
        }
    }

    static class Record
    extends PlsqlType {
        LinkedHashMap<String, PlsqlType> fields;
        private boolean isInjectible;

        Record() {
            super(TYPECLASS.RECORD);
        }

        Record(LinkedHashMap<String, PlsqlType> fields) {
            super(TYPECLASS.RECORD);
            this.fields = fields;
            this.isInjectible = false;
            if (fields == null) {
                return;
            }
            for (Map.Entry<String, PlsqlType> field : fields.entrySet()) {
                if (!field.getValue().isInjectable()) continue;
                this.isInjectible = true;
                break;
            }
        }

        @Override
        public boolean isInjectable() {
            return this.isInjectible;
        }
    }

    public static class Function
    extends PlsqlType {
        ArrayList<FuncFormal> overloads = new ArrayList();

        Function(FuncFormal signature) {
            super(TYPECLASS.FUNCTION);
            this.addSignature(signature);
        }

        FuncFormal addSignature(FuncFormal signature) {
            int match = this.matchSignature(signature);
            if (match < 0) {
                this.overloads.add(signature);
            } else {
                this.merge(this.overloads.get(match), signature);
                signature = this.overloads.get(match);
            }
            return signature;
        }

        int matchSignature(FuncFormal signature) {
            block0: for (int i = 0; i < this.overloads.size(); ++i) {
                FuncFormal existing = this.overloads.get(i);
                if (signature.getParms().size() != existing.getParms().size() || signature.getResultIdx() != existing.getResultIdx()) continue;
                for (int p = 0; p < signature.getParms().size(); ++p) {
                    int score;
                    if (p != signature.getResultIdx() && (score = Function.match(signature.getParmSymbols().get(p).getType(), existing.getParmSymbols().get(p).getType())) >= ARGMATCH.INCOMPATIBLE.getScore()) continue block0;
                }
                return i;
            }
            return -1;
        }

        void merge(FuncFormal exist, FuncFormal newSig) {
            for (int i = 0; i < exist.getParmSymbols().size(); ++i) {
                Symbol exSym = exist.getParmSymbols().get(i);
                Symbol nsSym = newSig.getParmSymbols().get(i);
                exSym.getAssigned().from(nsSym.getAssigned());
                Usage exU = exist.getAfterCall().get(i);
                Usage nsU = newSig.getAfterCall().get(i);
                exU.from(nsU);
            }
        }

        FuncFormalResolved resolveArguments(List<ValueNode.ArgNode> args) throws SqlInjectionAnalysisFailure {
            SqlInjectionGraph.Debug.FUNCRESOLVE.outln("resolve args: " + Arrays.toString(args.toArray()));
            FuncFormalResolved ret = null;
            int[] retArgsToParms = new int[args.size()];
            int retScore = Integer.MAX_VALUE;
            int numFuzzyCandidates = 0;
            block0: for (FuncFormal formal : this.overloads) {
                if (SqlInjectionGraph.Debug.FUNCRESOLVE.debug) {
                    System.out.println(formal);
                }
                int pspecScore = 0;
                boolean positionalOk = true;
                int position = 0;
                ArrayList<ParmSpec> pspec = formal.getParms();
                boolean[] parmUsed = new boolean[pspec.size()];
                for (int argi = 0; argi < args.size(); ++argi) {
                    ValueNode.ArgNode arg = args.get(argi);
                    if (position < pspec.size() && pspec.get(position).getName() == null) {
                        assert (!pspec.get(position).getMode().isIn());
                        ++position;
                    }
                    if (position >= pspec.size()) {
                        positionalOk = false;
                    }
                    int posidx = -1;
                    int posidxDiff = Integer.MAX_VALUE;
                    boolean ellipsis = false;
                    if (arg.namedArg == null) {
                        if (!positionalOk) continue block0;
                        posidx = position++;
                        if (pspec.get((int)posidx).getType().typeClass == TYPECLASS.ELLIPSIS) {
                            ellipsis = true;
                        }
                        posidxDiff = Function.match(arg, pspec.get(posidx));
                        if (posidxDiff >= ARGMATCH.INCOMPATIBLE.score) {
                            continue block0;
                        }
                    } else {
                        positionalOk = false;
                        int i = 0;
                        if (i < pspec.size()) {
                            posidxDiff = Function.match(arg, pspec.get(i));
                            if (posidxDiff >= ARGMATCH.INCOMPATIBLE.score) continue block0;
                            posidx = i;
                        }
                    }
                    assert (posidxDiff < ARGMATCH.INCOMPATIBLE.score);
                    if (parmUsed[posidx] && !ellipsis) continue block0;
                    parmUsed[posidx] = true;
                    retArgsToParms[argi] = posidx;
                    pspecScore += posidxDiff;
                }
                for (int i = 0; i < pspec.size(); ++i) {
                    if (parmUsed[i] || pspec.get(i).isDefaulted() || pspec.get(i).getName() == null) continue;
                    pspecScore += ARGMATCH.MISSING_NODEFAULT.score;
                }
                if (SqlInjectionGraph.Debug.FUNCRESOLVE.debug) {
                    System.out.print("(");
                    for (int idx : retArgsToParms) {
                        System.out.print("[" + idx + "],");
                    }
                    System.out.println(" score " + pspecScore + (String)(pspecScore < retScore ? " < " + retScore : ""));
                }
                if (pspecScore < retScore) {
                    retScore = pspecScore;
                    numFuzzyCandidates = 0;
                    ret = new FuncFormalResolved(formal, retArgsToParms);
                    continue;
                }
                if (pspecScore != retScore) continue;
                ++numFuzzyCandidates;
            }
            if (retScore > 0 && numFuzzyCandidates > 0) {
                throw new SqlInjectionAnalysisFailure("Multiple matching overloads for " + Arrays.toString(args.toArray()));
            }
            return ret;
        }

        private static int match(ValueNode.ArgNode arg, ParmSpec pspec) {
            PlsqlType from = arg.getType();
            PlsqlType to = pspec.getType();
            return Function.match(from, to);
        }

        private static int match(PlsqlType from, PlsqlType to) {
            if (from == null && to == null) {
                return 0;
            }
            if (from == null || to == null) {
                return ARGMATCH.INCOMPATIBLE.getScore();
            }
            if (from == null || from.typeClass == null || to == null || to.typeClass == null) {
                SqlInjectionGraph.Debug.PLSQL.outln("from=" + String.valueOf(from) + " to=" + String.valueOf(to));
            }
            if (to.typeClass == TYPECLASS.ELLIPSIS) {
                return ARGMATCH.PERFECT.getScore();
            }
            if (from.typeClass != to.typeClass) {
                return ARGMATCH.INCOMPATIBLE.getScore();
            }
            if (to.typeClass == null) {
                return 0;
            }
            switch (to.typeClass.ordinal()) {
                case 0: {
                    Scalar toScalar = (Scalar)to;
                    Scalar fromScalar = (Scalar)from;
                    if (toScalar.getScalarClass() != fromScalar.getScalarClass()) {
                        return Function.matchConvertScalarClass(fromScalar.getScalarClass(), toScalar.getScalarClass());
                    }
                    if (toScalar.getScalarClass() == null) {
                        return 0;
                    }
                    switch (toScalar.getScalarClass().ordinal()) {
                        case 0: {
                            if (fromScalar.scalarType.charFamily == toScalar.scalarType.charFamily) {
                                return 0;
                            }
                            return 1;
                        }
                        case 1: {
                            if (fromScalar.scalarType.dateFamily == toScalar.scalarType.dateFamily) {
                                return 0;
                            }
                            return 1;
                        }
                        case 2: {
                            return NumericFamily.match(fromScalar.scalarType.numericFamily, toScalar.scalarType.numericFamily);
                        }
                    }
                    return 0;
                }
            }
            return ARGMATCH.INCOMPATIBLE.getScore();
        }

        private static int matchConvertScalarClass(ScalarClass from, ScalarClass to) {
            assert (from != to);
            if (from == null || to == null) {
                return ARGMATCH.INCOMPATIBLE.getScore();
            }
            return to.implicitlyConvertibleFrom(from) ? ARGMATCH.CONVERSION.getScore() : ARGMATCH.INCOMPATIBLE.getScore();
        }

        List<FuncFormal> getOverloads() {
            return new ArrayList<FuncFormal>(this.overloads);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            for (FuncFormal formal : this.overloads) {
                String sep = "";
                sb.append("(");
                for (ParmSpec parm : formal.getParms()) {
                    sb.append(sep + String.valueOf(parm));
                    sep = ",";
                }
                sb.append(") ");
            }
            return sb.toString();
        }

        @Override
        public boolean isInjectable() {
            return false;
        }

        static enum ARGMATCH {
            PERFECT(0),
            CONVERSION(1),
            MISSING_NODEFAULT(25),
            INCOMPATIBLE(1000);

            private final int score;

            private int getScore() {
                return this.score;
            }

            private ARGMATCH(int score) {
                this.score = score;
            }
        }

        static class FuncFormalResolved {
            final FuncFormal formal;
            final int[] argsToParms;

            public FuncFormalResolved(FuncFormal formal, int[] argsToParms) {
                this.formal = formal;
                this.argsToParms = argsToParms;
            }

            FuncFormal getFormal() {
                return this.formal;
            }

            ParmSpec getResultParm() {
                int resultIdx = this.formal.getResultIdx();
                if (resultIdx < 0) {
                    return null;
                }
                return this.formal.getParms().get(resultIdx);
            }
        }
    }

    static class Ellipsis
    extends PlsqlType {
        Ellipsis() {
            super(TYPECLASS.ELLIPSIS);
        }

        @Override
        public boolean isInjectable() {
            return true;
        }
    }
}

