/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.app.injection.FlowFunc;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;

public class FuncFormal {
    private final String RETURN_PARM_NAME = "[return]";
    private boolean bodyDefined;
    private Object bodyLabel;
    private ArrayList<ParmSpec> parms;
    private ArrayList<Symbol> parmSymbols;
    private ArrayList<Usage> afterCall;
    private int resultIdx;
    private Loc loc;
    private boolean safe;
    private Map<Loc, FlowFunc> specificFlows;

    FuncFormal(ArrayList<ParmSpec> parms, Loc loc, Object label) {
        int i;
        assert (loc != null);
        this.bodyDefined = false;
        this.bodyLabel = null;
        this.parms = parms;
        this.parmSymbols = new ArrayList(parms.size());
        this.afterCall = new ArrayList(parms.size());
        this.loc = loc;
        this.safe = false;
        this.specificFlows = new HashMap<Loc, FlowFunc>();
        this.resultIdx = -1;
        for (i = 0; i < parms.size(); ++i) {
            String name = parms.get(i).getName();
            if (name != null && !name.equals("")) continue;
            assert (this.resultIdx < 0);
            this.resultIdx = i;
            name = "[return]";
        }
        if (this.resultIdx > 0) {
            ArrayList<ParmSpec> reorderedParms = new ArrayList<ParmSpec>(parms);
            ParmSpec retParm = reorderedParms.get(this.resultIdx);
            for (int i2 = this.resultIdx; i2 > 0; --i2) {
                reorderedParms.set(i2, reorderedParms.get(i2 - 1));
            }
            reorderedParms.set(0, retParm);
            this.parms = reorderedParms;
            this.resultIdx = 0;
        }
        for (i = 0; i < this.parms.size(); ++i) {
            ParmSpec parm = this.parms.get(i);
            String name = parm.getName();
            PlsqlType type = parm.getType();
            if (name == null) {
                name = "";
            }
            Symbol parmSym = type != null ? Symbol.createSymbolForType(null, name, type, loc, label) : new Symbol(null, name, type, loc, label);
            this.parmSymbols.add(parmSym);
            this.afterCall.add(new Usage(parmSym, loc, label));
        }
    }

    void defineBody(SymbolTable scope, Object bodyLabel) {
        this.bodyDefined = true;
    }

    boolean getBodyDefined() {
        return this.bodyDefined;
    }

    Object getBodyLabel() {
        return this.bodyLabel;
    }

    ArrayList<ParmSpec> getParms() {
        return this.parms;
    }

    ArrayList<Symbol> getParmSymbols() {
        return this.parmSymbols;
    }

    List<Usage> getAfterCall() {
        return this.afterCall;
    }

    Loc getLoc() {
        return this.loc;
    }

    int getResultIdx() {
        return this.resultIdx;
    }

    void markAsSafe() {
        this.safe = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.loc.toString() + ":(");
        String sep = "";
        for (ParmSpec pspec : this.parms) {
            sb.append(sep + String.valueOf(pspec));
            sep = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    public Usage doCallLink(List<ValueNode.ArgNode> argsInParmOrder, Loc callLoc, Object label) {
        int n = argsInParmOrder.size();
        if (this.safe) {
            return new Usage(new Symbol(null, "", PlsqlType.safeType(), callLoc, label), callLoc, label);
        }
        Symbol[] outSym = new Symbol[n];
        for (int out = 0; out < n; ++out) {
            Symbol sym;
            ValueNode.ArgNode outArg = argsInParmOrder.get(out);
            if (!this.getParms().get(out).getMode().isOut()) continue;
            outSym[out] = sym = this.parmSymbols.get(out);
            Usage newOutU = new Usage(sym, callLoc, label);
            sym.assignUsage(newOutU);
            for (int in = 0; in < n; ++in) {
                if (!this.getParms().get(in).getMode().isIn()) continue;
                ValueNode.ArgNode inArg = argsInParmOrder.get(in);
                for (Usage inU : inArg.getUsages()) {
                    outSym[out].getAssigned().from(inU);
                }
            }
        }
        if (this.getResultIdx() < 0) {
            return null;
        }
        return outSym[this.getResultIdx()].getAssigned();
    }

    public void linkCallBefore(List<ValueNode.ArgNode> argsInParmOrder, Loc callLoc, Object label) {
        int n = argsInParmOrder.size();
        for (int i = 0; i < n; ++i) {
            Symbol parmSym = this.parmSymbols.get(i);
            Usage parmU = parmSym.getAssigned();
            ValueNode.ArgNode arg = argsInParmOrder.get(i);
            if (arg == null || !this.getParms().get(i).getMode().isIn()) continue;
            List<Usage> argUsages = arg.getUsages();
            for (Usage u : argUsages) {
                parmU.from(u);
            }
        }
    }

    public Usage connectFlows(List<ValueNode.ArgNode> argsInParmOrder, Loc callLoc, Object label) {
        assert (callLoc != null);
        FlowFunc flowFunc = this.specificFlows.get(callLoc);
        if (flowFunc == null) {
            flowFunc = new FlowFunc(this, this.loc, callLoc);
            this.specificFlows.put(callLoc, flowFunc);
        }
        return flowFunc.connect(argsInParmOrder);
    }
}

