/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import oracle.dbtools.parser.json.Jsonable;
import oracle.dbtools.parser.json.Util;

public class CompletionItem
implements Jsonable {
    public String entry;
    public Type type;

    public CompletionItem(String entry, Type type) {
        this.entry = entry;
        this.type = type;
    }

    public CompletionItem(String entry) {
        this(entry, Type.UNKNOWN);
    }

    public String toString() {
        return this.entry + " " + String.valueOf((Object)this.type);
    }

    public boolean equals(Object obj) {
        CompletionItem cmp = (CompletionItem)obj;
        if (!cmp.entry.equals(this.entry)) {
            return false;
        }
        if (cmp.type == null && this.type != null) {
            return false;
        }
        if (cmp.type != null && this.type == null) {
            return false;
        }
        return cmp.type == null || cmp.type.equals((Object)this.type);
    }

    public int lspCode() {
        switch (this.type.ordinal()) {
            case 0: {
                return 6;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 14;
            }
            case 6: {
                return 1;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 9;
            }
            case 12: {
                return 6;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 15;
            }
            case 17: {
                return 19;
            }
            case 18: {
                return 3;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 6;
            }
            case 21: {
                return 15;
            }
        }
        return 1;
    }

    public String toJson() {
        return "{\"label\":\"" + Util.sugarcoatText((String)this.entry) + "\",\"kind\":" + this.lspCode() + "}";
    }

    public static enum Type {
        TABLE,
        VIEW,
        COLUMN,
        USER,
        KEYWORD,
        TURLNET,
        SYNONYM,
        SEQUENCE,
        PROCEDURE,
        FUNCTION,
        PACKAGE,
        PACKAGE_BODY,
        INDEX,
        OTHER_DB_OBJECT,
        CONDITION,
        ARGUMENT,
        PARTIALLY_RECOGNIZED_SYNTAX,
        JAVA_PACKAGE,
        JAVA_CLASS,
        JAVA_METHOD,
        JAVA_VARIABLE,
        SNIPPET,
        FILE,
        OPTION,
        PARAMETER,
        STRING,
        BOOLEAN,
        UNKNOWN;

    }
}

