/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3;

import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Options;
import com.oracle.bmc.http.client.jersey3.WrappedResponseInputStream;
import com.oracle.bmc.http.client.jersey3.io.internal.AutoCloseableContentLengthVerifyingInputStream;
import com.oracle.bmc.http.client.jersey3.io.internal.ContentLengthVerifyingInputStream;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Jersey3HttpResponse
implements HttpResponse {
    private static final Logger log = LoggerFactory.getLogger(Jersey3HttpResponse.class);
    private final Response response;
    private boolean bodyConsumed = false;

    Jersey3HttpResponse(Response response) {
        this.response = response;
    }

    public int status() {
        return this.response.getStatus();
    }

    public Map<String, List<String>> headers() {
        return this.response.getStringHeaders();
    }

    public String header(String name) {
        return this.response.getHeaderString(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<InputStream> streamBody() {
        this.bodyConsumed = true;
        List contentType = (List)this.response.getHeaders().remove((Object)"Content-Type");
        log.debug("Entity type is InputStream, ignoring contentType {} and processing as stream", (Object)contentType);
        try {
            long contentLength;
            InputStream rawInputStream = (InputStream)this.response.readEntity(InputStream.class);
            InputStream inputStream = new WrappedResponseInputStream(rawInputStream, this.response);
            String contentLengthStr = this.header("Content-Length");
            if (contentLengthStr != null && this.header("Content-Encoding") == null && (contentLength = Long.parseLong(contentLengthStr)) > 0L) {
                inputStream = Options.getShouldAutoCloseResponseInputStream() ? new AutoCloseableContentLengthVerifyingInputStream(inputStream, contentLength) : new ContentLengthVerifyingInputStream(inputStream, contentLength);
            }
            CompletableFuture<InputStream> completableFuture = CompletableFuture.completedFuture(inputStream);
            return completableFuture;
        }
        catch (Exception e) {
            CompletableFuture<InputStream> completableFuture = Jersey3HttpResponse.failedFuture(e);
            return completableFuture;
        }
        finally {
            if (contentType != null) {
                this.response.getHeaders().addAll((Object)"Content-Type", contentType);
            }
        }
    }

    public <T> CompletionStage<T> body(Class<T> type) {
        this.bodyConsumed = true;
        try {
            return CompletableFuture.completedFuture(this.readEntitySync(new GenericType(type)));
        }
        catch (Exception e) {
            return Jersey3HttpResponse.failedFuture(e);
        }
    }

    public <T> CompletionStage<List<T>> listBody(Class<T> type) {
        this.bodyConsumed = true;
        GenericType listType = new GenericType((Type)new SimpleParameterizedType(List.class, type));
        try {
            return CompletableFuture.completedFuture((List)this.readEntitySync(listType));
        }
        catch (Exception e) {
            return Jersey3HttpResponse.failedFuture(e);
        }
    }

    private <T> T readEntitySync(GenericType<T> type) {
        this.response.bufferEntity();
        return (T)this.response.readEntity(type);
    }

    public CompletionStage<String> textBody() {
        this.bodyConsumed = true;
        return CompletableFuture.completedFuture((String)this.response.readEntity(String.class));
    }

    public void close() {
        if (!this.bodyConsumed && this.response.hasEntity()) {
            try {
                ((InputStream)this.response.readEntity(InputStream.class)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.response.close();
    }

    private static <T> CompletableFuture<T> failedFuture(Throwable failure) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(failure);
        return future;
    }

    private static final class SimpleParameterizedType
    implements ParameterizedType {
        private final Class<?> rawType;
        private final Type contentType;

        SimpleParameterizedType(Class<?> rawType, Type contentType) {
            this.rawType = rawType;
            this.contentType = contentType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.contentType};
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

