/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.InterruptibleChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;

public class BidirectionalPipe
implements Closeable {
    private final Side client;
    private final Side server;

    private BidirectionalPipe(Side client, Side server) {
        this.client = client;
        this.server = server;
    }

    public static BidirectionalPipe open() throws IOException {
        Pipe clientToServer = Pipe.open();
        Pipe serverToClient = Pipe.open();
        Side client = new Side(clientToServer.source(), serverToClient.sink());
        Side server = new Side(serverToClient.source(), clientToServer.sink());
        return new BidirectionalPipe(client, server);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
        this.server.close();
    }

    public Side client() {
        return this.client;
    }

    public Side server() {
        return this.server;
    }

    public static class Side
    implements Closeable {
        private final Sink sink;
        private final Source source;
        private final AtomicBoolean closed;
        private final Runnable onClose;

        Side(Pipe.SourceChannel source, Pipe.SinkChannel sink) {
            this.sink = new Sink(sink);
            this.source = new Source(source);
            this.closed = new AtomicBoolean();
            this.onClose = () -> {
                Side.close(source);
                Side.close(sink);
            };
        }

        private static void close(Closeable resource) {
            try {
                resource.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Sink sink() {
            return this.sink;
        }

        public Source source() {
            return this.source;
        }

        public InputStream input() {
            return Channels.newInputStream(this.source);
        }

        public OutputStream output() {
            return Channels.newOutputStream(this.sink);
        }

        public Reader reader() {
            return Channels.newReader((ReadableByteChannel)this.source, StandardCharsets.UTF_8);
        }

        public Writer writer() {
            return Channels.newWriter((WritableByteChannel)this.sink, StandardCharsets.UTF_8);
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                this.onClose.run();
            }
        }

        public boolean isOpen() {
            return !this.closed.get();
        }
    }

    public static class Sink
    implements WritableByteChannel,
    GatheringByteChannel,
    InterruptibleChannel,
    Closeable {
        private final Pipe.SinkChannel delegate;

        Sink(Pipe.SinkChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.delegate.write(srcs);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class Source
    implements ReadableByteChannel,
    ScatteringByteChannel,
    InterruptibleChannel,
    Closeable {
        private final Pipe.SourceChannel delegate;

        Source(Pipe.SourceChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.delegate.read(dsts);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

