/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.mcp.api.Mcp;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SchemaInformationTool
implements Mcp.Feature {
    public static final String name = "schema-information";
    public static final String description = "This tool provides detailed insights about the currently connected schema by analyzing and enriching the metadata returned from the executed queriesNote: This tool requires a database connection.";

    @Override
    public void configure(Mcp.Definition definition) {
        McpServer.SyncSpecification specification = definition.specification();
        McpSchema.Tool tool = new McpSchema.Tool(name, description, Schemas.getSchema(Schemas.SchemaName.SCHEMA_INFORMATION_SCHEMA));
        specification.tool(tool, (exchange, args) -> {
            try {
                ScriptRunnerContext ctx = definition.find(ScriptRunnerContext.class).orElseGet(ScriptRunnerContext::new);
                String model = McpUtils.optionalArgument(args, "model", McpUtils.MODEL_DEFAULT_VALUE);
                if (null != ctx.getCurrentConnection()) {
                    McpUtils.mcpLogs(ctx, name, model, exchange.getClientInfo().name(), "tool", McpMessages.format("SCHEMA_METADATA_LOG_MESSAGE", ctx.getCurrentConnection().getSchema()));
                    ArrayList<McpSchema.TextContent> metadata = new ArrayList<McpSchema.TextContent>();
                    String queryResult = QueryUtils.getSchemaObjectsFull(ctx);
                    if (null != queryResult) {
                        metadata.add(new McpSchema.TextContent(queryResult));
                    }
                    if (null != (queryResult = QueryUtils.getOptimizedDdl(ctx))) {
                        metadata.add(new McpSchema.TextContent(queryResult));
                    }
                    return new McpSchema.CallToolResult(metadata, Boolean.valueOf(false));
                }
                throw new McpError((Object)McpMessages.getString("NOT_CONNECTED"));
            }
            catch (Exception e) {
                return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", e.getLocalizedMessage()))), Boolean.valueOf(true));
            }
        });
    }
}

