/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.service;

import com.google.common.base.Throwables;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.raptor.liquibase.service.LbThread;
import oracle.dbtools.raptor.liquibase.service.LbThreadFactory;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class LbExecutorService
extends ThreadPoolExecutor {
    String servcieName;
    ScriptRunnerContext ctx;
    ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();

    public LbExecutorService(ScriptRunnerContext ctx, int coreCount, int maxCount, int keepAlive, TimeUnit timeUnit, String serviceName) {
        super(coreCount, maxCount, keepAlive, timeUnit, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(new LbThreadFactory(serviceName));
        this.servcieName = serviceName;
        this.ctx = ctx;
        this.allowCoreThreadTimeOut(false);
        this.prestartAllCoreThreads();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (Thread.currentThread() instanceof LbThread) {
            this.connections.add(((LbThread)Thread.currentThread()).getConnection());
            ((LbThread)Thread.currentThread()).setConnection(null);
        }
        super.afterExecute(r, t);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        try {
            if (Thread.currentThread() instanceof LbThread) {
                Connection conn = this.connections.poll();
                if (conn == null || conn.isClosed()) {
                    conn = this.ctx.cloneCLIConnection();
                    conn.setAutoCommit(false);
                }
                ((LbThread)Thread.currentThread()).setConnection(conn);
            }
        }
        catch (SQLException e) {
            throw new RejectedExecutionException(Throwables.getStackTraceAsString((Throwable)e), e);
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void terminated() {
        this.closeConnections();
    }

    private void closeConnections() {
        for (Connection c : this.connections) {
            try {
                if (c.isClosed()) continue;
                c.close();
            }
            catch (SQLException e) {
                throw new RejectedExecutionException(Throwables.getStackTraceAsString((Throwable)e), e);
            }
        }
    }
}

