/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import com.google.common.base.Throwables;
import java.util.Objects;
import liquibase.exception.LiquibaseException;
import oracle.dbtools.raptor.liquibase.generator.changesets.core.JsonChangeSet;
import oracle.dbtools.raptor.liquibase.generator.changesets.core.SqlChangeSet;
import oracle.dbtools.raptor.liquibase.generator.changesets.core.XmlChangeSet;
import oracle.dbtools.raptor.liquibase.generator.changesets.core.YamlChangeSet;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.generator.changesets.interfaces.ChangeSet;

public class ChangeSetFactory {
    public ChangeSet getChangeGenerator(String changeType, ChangeData data) throws LiquibaseException {
        try {
            if (Objects.equals(changeType, TYPE.SQL.toString())) {
                return new SqlChangeSet(data);
            }
            if (Objects.equals(changeType, TYPE.YAML.toString())) {
                return new YamlChangeSet(data);
            }
            if (Objects.equals(changeType, TYPE.XML.toString())) {
                return new XmlChangeSet(data);
            }
            if (Objects.equals(changeType, TYPE.JSON.toString())) {
                return new JsonChangeSet(data);
            }
            return null;
        }
        catch (Exception e) {
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e), (Throwable)e);
        }
    }

    public static enum TYPE {
        SQL,
        YAML,
        XML,
        JSON;

    }
}

