/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.rdbms;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.Wrapper;
import javax.json.JsonValue;
import oracle.json.common.DocumentCodec;
import oracle.json.common.DocumentCodecFactory;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.common.Message;
import oracle.json.rdbms.JsonpGeneratorWrapper;
import oracle.json.rdbms.JsonpParserWrapper;
import oracle.json.util.ByteArray;
import oracle.json.util.Pair;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonValue;

public class OsonCodecFactory
extends DocumentCodecFactory {
    private final OracleJsonFactory osonFactory = new OracleJsonFactory();

    public OsonCodecFactory() {
    }

    public OsonCodecFactory(JsonFactoryProvider jsonFactoryProvider) {
        super(jsonFactoryProvider);
    }

    @Override
    public DocumentCodec getCodec() {
        if (this.factoryProvider == null) {
            this.setFactoryProvider(new JsonFactoryProvider());
        }
        return new OsonDocumentCodec(this.factoryProvider, this.osonFactory);
    }

    private class OsonDocumentCodec
    extends DocumentCodec<OracleJsonValue> {
        private final OracleJsonFactory osonFactory;

        OsonDocumentCodec(JsonFactoryProvider jsonFactoryProvider, OracleJsonFactory oracleJsonFactory) {
            super(jsonFactoryProvider);
            this.osonFactory = oracleJsonFactory;
        }

        @Override
        public void loadImage(byte[] byArray) {
            this.reset();
            this.image = byArray;
        }

        @Override
        public String getKey(boolean bl) throws JsonException {
            if (this.keySteps == null) {
                throw this.makeException(Message.EX_KEY_PATH_NOT_SET, new Object[0]);
            }
            if (this.rekeyingCheck()) {
                throw this.makeException(Message.EX_REKEY_PENDING, new Object[0]);
            }
            this.needViable = bl;
            if (this.doc == null) {
                if (this.image == null) {
                    return super.getKey(bl);
                }
                this.doc = this.getDocument();
                if (this.doc == null) {
                    return null;
                }
            }
            return this.extractKey((OracleJsonValue)this.doc);
        }

        @Override
        public OracleJsonValue getDocument() throws JsonException {
            if (this.doc == null && this.image == null) {
                this.image = this.getImage();
            }
            if (this.rekeyingCheck()) {
                this.image = this.getImage();
            }
            if (this.doc == null && this.image != null) {
                this.doc = this.osonFactory.createJsonBinaryValue(ByteBuffer.wrap(this.image));
            }
            return (OracleJsonValue)this.doc;
        }

        @Override
        public byte[] getImage() throws JsonException {
            boolean bl = this.rekeyingCheck();
            if (this.image == null) {
                ByteArrayOutputStream byteArrayOutputStream = this.getBAOS();
                OracleJsonGenerator oracleJsonGenerator = this.osonFactory.createJsonBinaryGenerator((OutputStream)byteArrayOutputStream);
                byteArrayOutputStream.reset();
                if (this.doc != null) {
                    oracleJsonGenerator.write((OracleJsonValue)this.doc);
                } else if (this.jsonText != null) {
                    JsonParser jsonParser = this.factoryProvider.getParserFactory().createParser((Reader)new StringReader(this.jsonText));
                    if (bl) {
                        // empty if block
                    }
                    oracleJsonGenerator.writeParser((Object)jsonParser);
                } else if (this.jsonUnicode != null) {
                    JsonParser jsonParser = this.factoryProvider.getParserFactory().createParser((InputStream)new ByteArrayInputStream(this.jsonUnicode));
                    if (bl) {
                        // empty if block
                    }
                    JsonpGeneratorWrapper jsonpGeneratorWrapper = new JsonpGeneratorWrapper(oracleJsonGenerator);
                    jsonpGeneratorWrapper.writeJsonParser(jsonParser);
                } else if (bl) {
                    JsonParser jsonParser = this.factoryProvider.getParserFactory().createParser((Reader)new StringReader("{}"));
                    oracleJsonGenerator.writeParser((Object)jsonParser);
                } else {
                    this.rekeyingClear();
                    return null;
                }
                oracleJsonGenerator.close();
                this.image = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
            }
            if (bl) {
                this.rekeyImage();
            }
            return this.image;
        }

        @Override
        public String getString() throws JsonException {
            if (this.jsonText == null && this.jsonUnicode == null) {
                this.jsonUnicode = this.getUnicode();
            }
            return super.getString();
        }

        @Override
        public byte[] getUnicode() throws JsonException {
            if (this.jsonText == null && this.jsonUnicode == null) {
                this.doc = this.getDocument();
                if (this.doc == null) {
                    return null;
                }
                ByteArrayOutputStream byteArrayOutputStream = this.getBAOS();
                OracleJsonGenerator oracleJsonGenerator = this.osonFactory.createJsonTextGenerator((OutputStream)byteArrayOutputStream);
                oracleJsonGenerator.write((OracleJsonValue)this.doc);
                oracleJsonGenerator.close();
                this.jsonUnicode = byteArrayOutputStream.toByteArray();
            }
            return super.getUnicode();
        }

        @Override
        public Object getDocument(Class clazz) throws JsonException {
            if (OracleJsonValue.class.isInstance(clazz)) {
                return this.getDocument();
            }
            if (JsonValue.class.isInstance(clazz)) {
                this.doc = this.getDocument();
                if (this.doc != null) {
                    return ((OracleJsonValue)this.doc).wrap(JsonValue.class);
                }
            }
            return super.getDocument(clazz);
        }

        private void rekeyImage() throws JsonException {
            if (this.image == null) {
                return;
            }
            if (this.rekeyingCheck() && this.insertKey()) {
                this.doc = null;
                this.jsonText = null;
                this.jsonUnicode = null;
            }
        }

        @Override
        protected void addKey(JsonGenerator jsonGenerator, String string, String string2) throws JsonException {
            if (jsonGenerator instanceof Wrapper || jsonGenerator instanceof JsonpGeneratorWrapper) {
                int n;
                OracleJsonGenerator oracleJsonGenerator;
                if (jsonGenerator instanceof JsonpGeneratorWrapper) {
                    oracleJsonGenerator = ((JsonpGeneratorWrapper)jsonGenerator).getWrapped();
                } else {
                    try {
                        oracleJsonGenerator = ((Wrapper)jsonGenerator).unwrap(OracleJsonGenerator.class);
                    }
                    catch (SQLException sQLException) {
                        throw new IllegalStateException(sQLException);
                    }
                }
                int n2 = n = string2 == null ? 0 : string2.length();
                if (this.keyIsId && (n & 1) == 0 && n > 0 && n < 256 && ByteArray.isHex(string2)) {
                    oracleJsonGenerator.writeKey(string);
                    oracleJsonGenerator.writeId(ByteArray.hexToRaw(string2));
                    return;
                }
            }
            super.addKey(jsonGenerator, string, string2);
        }

        private boolean insertKey() throws JsonException {
            if (this.keySteps == null || this.keySteps.length <= 0) {
                throw this.makeException(Message.EX_KEY_PATH_EMPTY, new Object[0]);
            }
            if (this.image == null) {
                throw this.makeException(Message.EX_NO_INPUT_DOCUMENT, new Object[0]);
            }
            if (this.image.length == 0) {
                throw this.makeException(Message.EX_NO_INPUT_DOCUMENT, new Object[0]);
            }
            ByteArrayOutputStream byteArrayOutputStream = this.getBAOS();
            OracleJsonParser oracleJsonParser = this.osonFactory.createJsonBinaryParser(ByteBuffer.wrap(this.image));
            OracleJsonGenerator oracleJsonGenerator = this.osonFactory.createJsonBinaryGenerator((OutputStream)byteArrayOutputStream);
            JsonpParserWrapper jsonpParserWrapper = new JsonpParserWrapper(oracleJsonParser);
            JsonpGeneratorWrapper jsonpGeneratorWrapper = new JsonpGeneratorWrapper(oracleJsonGenerator);
            boolean bl = false;
            Pair<String, Boolean> pair = this.parseStream(jsonpParserWrapper, jsonpGeneratorWrapper, false);
            bl = pair.getSecond();
            jsonpGeneratorWrapper.close();
            jsonpParserWrapper.close();
            this.image = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            this.rekeyingClear();
            return bl;
        }

        private String extractKey(OracleJsonValue oracleJsonValue) throws JsonException {
            if (this.keySteps == null || this.keySteps.length <= 0) {
                throw this.makeException(Message.EX_KEY_PATH_EMPTY, new Object[0]);
            }
            OracleJsonValue oracleJsonValue2 = oracleJsonValue;
            if (oracleJsonValue2.getOracleJsonType() != OracleJsonValue.OracleJsonType.OBJECT) {
                throw this.makeException(Message.EX_DOCUMENT_NOT_OBJECT, new Object[0]);
            }
            OracleJsonObject oracleJsonObject = oracleJsonValue2.asJsonObject();
            for (int i = 0; i < this.keySteps.length - 1; ++i) {
                oracleJsonValue2 = (OracleJsonValue)oracleJsonObject.get((Object)this.keySteps[i]);
                if (oracleJsonValue2 == null) {
                    return null;
                }
                if (oracleJsonValue2.getOracleJsonType() != OracleJsonValue.OracleJsonType.OBJECT) {
                    return null;
                }
                oracleJsonObject = oracleJsonValue2.asJsonObject();
            }
            OracleJsonValue oracleJsonValue3 = (OracleJsonValue)oracleJsonObject.get((Object)this.keySteps[this.keySteps.length - 1]);
            if (oracleJsonValue3 == null) {
                return null;
            }
            switch (oracleJsonValue3.getOracleJsonType()) {
                case STRING: {
                    return oracleJsonValue3.asJsonString().getString();
                }
                case DOUBLE: {
                    BigDecimal bigDecimal;
                    double d = oracleJsonValue3.asJsonDouble().doubleValue();
                    if (Double.isInfinite(d) || Double.isNaN(d) || (bigDecimal = BigDecimal.valueOf(d)).stripTrailingZeros().scale() > 0) break;
                    return bigDecimal.toBigInteger().toString();
                }
                case FLOAT: {
                    BigDecimal bigDecimal;
                    float f = oracleJsonValue3.asJsonFloat().floatValue();
                    if (Float.isInfinite(f) || Float.isNaN(f) || (bigDecimal = BigDecimal.valueOf(f)).stripTrailingZeros().scale() > 0) break;
                    return bigDecimal.toBigInteger().toString();
                }
                case DECIMAL: {
                    return OsonDocumentCodec.bigDecimalToKey(oracleJsonValue3.asJsonDecimal().bigDecimalValue());
                }
                case BINARY: {
                    OracleJsonBinary oracleJsonBinary = oracleJsonValue3.asJsonBinary();
                    if (!oracleJsonBinary.isId()) break;
                    return oracleJsonBinary.getString();
                }
            }
            if (this.needViable) {
                throw this.makeException(Message.EX_KEY_MUST_BE_STRING, new Object[0]);
            }
            return null;
        }
    }
}

