/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.common.Message;
import oracle.json.rdbms.JsonpGeneratorWrapper;
import oracle.json.rdbms.JsonpParserWrapper;
import oracle.json.util.Pair;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;

public abstract class DocumentCodec<T> {
    protected static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected static final String EMPTY_OBJECT_STRING = "{}";
    protected T doc = null;
    protected String jsonText = null;
    protected byte[] jsonUnicode = null;
    protected byte[] image = null;
    protected String[] keySteps = null;
    protected boolean validate = false;
    protected String newKey = null;
    protected boolean removeKey = false;
    protected boolean keyIsId = false;
    protected boolean mustMatch = false;
    protected boolean needViable = false;
    protected final JsonFactoryProvider factoryProvider;
    protected boolean isDetached = false;
    protected ByteArrayOutputStream baos = null;
    private boolean eJSONId = false;

    protected DocumentCodec(JsonFactoryProvider jsonFactoryProvider) {
        this.factoryProvider = jsonFactoryProvider;
    }

    public void detachFactory() {
        if (!this.isDetached) {
            this.isDetached = true;
            this.baos = null;
        }
    }

    protected ByteArrayOutputStream getBAOS() {
        if (this.baos == null) {
            this.isDetached = true;
            this.baos = new ByteArrayOutputStream();
        }
        this.baos.reset();
        return this.baos;
    }

    protected void reset() {
        this.doc = null;
        this.jsonText = null;
        this.jsonUnicode = null;
        this.image = null;
        this.rekeyingClear();
    }

    public void loadDocument(T t) {
        this.reset();
        this.doc = t;
    }

    public abstract void loadImage(byte[] var1);

    public void loadString(String string) {
        this.reset();
        this.jsonText = string;
    }

    public void loadUnicode(byte[] byArray) {
        this.reset();
        this.jsonUnicode = byArray;
    }

    public void setKeyPath(String[] stringArray) {
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        this.keySteps = stringArray;
        this.rekeyingClear();
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public String getKey(boolean bl) throws JsonException {
        this.needViable = bl;
        if (this.keySteps == null) {
            throw this.makeException(Message.EX_KEY_PATH_NOT_SET, new Object[0]);
        }
        if (this.rekeyingCheck()) {
            throw this.makeException(Message.EX_REKEY_PENDING, new Object[0]);
        }
        return this.extractKey(this.validate);
    }

    public void setRemoveKey(boolean bl) throws JsonException {
        if (this.keySteps == null) {
            throw this.makeException(Message.EX_KEY_PATH_NOT_SET, new Object[0]);
        }
        this.removeKey = bl;
    }

    public void generateEJSONId(boolean bl) {
        this.eJSONId = bl;
    }

    public void setNewKey(String string) throws JsonException {
        this.setNewKey(string, false);
    }

    public void setNewKey(String string, boolean bl) throws JsonException {
        this.setNewKey(string, bl, false);
    }

    public void setNewKey(String string, boolean bl, boolean bl2) {
        if (this.keySteps == null) {
            throw this.makeException(Message.EX_KEY_PATH_NOT_SET, new Object[0]);
        }
        this.newKey = string;
        this.keyIsId = bl;
        this.mustMatch = bl2;
    }

    public abstract T getDocument() throws JsonException;

    public abstract byte[] getImage() throws JsonException;

    public String getString() throws JsonException {
        if (this.rekeyingCheck()) {
            this.insertKey();
        }
        if (this.jsonText == null && this.jsonUnicode != null) {
            this.jsonText = new String(this.jsonUnicode, DEFAULT_CHARSET);
        }
        return this.jsonText;
    }

    public byte[] getUnicode() throws JsonException {
        if (this.rekeyingCheck()) {
            this.insertKey();
        }
        if (this.jsonUnicode == null && this.jsonText != null) {
            this.jsonUnicode = this.jsonText.getBytes(DEFAULT_CHARSET);
        }
        return this.jsonUnicode;
    }

    public Object getDocument(Class clazz) throws JsonException {
        throw this.makeException(Message.EX_UNSUPPORTED_DOC_TYPE, clazz.getName());
    }

    protected void rekeyingClear() {
        this.newKey = null;
        this.removeKey = false;
        this.keyIsId = false;
        this.mustMatch = false;
        this.needViable = false;
        this.validate = false;
    }

    protected boolean rekeyingCheck() {
        return this.newKey != null || this.removeKey;
    }

    protected JsonException makeException(Message message, Object ... objectArray) {
        return new JsonException(message.get(objectArray));
    }

    protected boolean checkNumericKey(String string, BigDecimal bigDecimal) {
        boolean bl = false;
        if (bigDecimal.stripTrailingZeros().scale() > 0) {
            return false;
        }
        try {
            BigDecimal bigDecimal2 = new BigDecimal(string);
            bl = bigDecimal.equals(bigDecimal2);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static String bigDecimalToKey(BigDecimal bigDecimal) {
        if (bigDecimal.stripTrailingZeros().scale() <= 0) {
            return bigDecimal.toBigInteger().toString();
        }
        return bigDecimal.toString();
    }

    private String parseRoot(JsonGenerator jsonGenerator, boolean bl) throws JsonException {
        JsonParserFactory jsonParserFactory = this.factoryProvider.getParserFactory();
        JsonParser jsonParser = null;
        if (this.jsonUnicode != null) {
            jsonParser = jsonParserFactory.createParser((InputStream)new ByteArrayInputStream(this.jsonUnicode));
        } else if (this.jsonText != null) {
            jsonParser = jsonParserFactory.createParser((Reader)new StringReader(this.jsonText));
        } else if (jsonGenerator != null) {
            jsonParser = jsonParserFactory.createParser((Reader)new StringReader(EMPTY_OBJECT_STRING));
        } else {
            throw this.makeException(Message.EX_NO_INPUT_DOCUMENT, new Object[0]);
        }
        String string = null;
        boolean bl2 = false;
        Pair<String, Boolean> pair = this.parseStream(jsonParser, jsonGenerator, bl);
        string = pair.getFirst();
        bl2 = pair.getSecond();
        jsonParser.close();
        return string;
    }

    private String extractKey(boolean bl) throws JsonException {
        return this.parseRoot(null, !bl);
    }

    private void insertKey() throws JsonException {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator jsonGenerator = this.factoryProvider.getGeneratorFactory().createGenerator((Writer)stringWriter);
        String string = this.parseRoot(jsonGenerator, false);
        jsonGenerator.flush();
        jsonGenerator.close();
        this.jsonText = stringWriter.toString();
        this.jsonUnicode = null;
        this.rekeyingClear();
    }

    protected void addKey(JsonGenerator jsonGenerator, String string, String string2) throws JsonException {
        if (this.eJSONId) {
            jsonGenerator.writeStartObject(string).write("$oid", string2).writeEnd();
        } else {
            jsonGenerator.write(string, string2);
        }
    }

    protected Pair<String, Boolean> parseStream(JsonParser jsonParser, JsonGenerator jsonGenerator, boolean bl) throws JsonException {
        if (this.keySteps == null || this.keySteps.length <= 0) {
            throw this.makeException(Message.EX_KEY_PATH_EMPTY, new Object[0]);
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.keySteps.length == 1 && this.removeKey && this.newKey != null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = null;
        String string2 = null;
        if (!this.rekeyingCheck() && jsonGenerator != null) {
            bl2 = false;
        }
        if (jsonGenerator != null) {
            bl = false;
        }
        block11: while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            if (bl2) {
                if (event != JsonParser.Event.START_OBJECT) {
                    throw this.makeException(Message.EX_DOCUMENT_NOT_OBJECT, new Object[0]);
                }
                bl2 = false;
                if (bl5) {
                    ++n;
                    if (jsonGenerator == null) continue;
                    jsonGenerator.writeStartObject();
                    this.addKey(jsonGenerator, this.keySteps[0], this.newKey);
                    string = this.newKey;
                    bl3 = true;
                    bl4 = true;
                    continue;
                }
            }
            switch (event) {
                case START_OBJECT: {
                    bl7 = false;
                    ++n;
                    if (jsonGenerator == null) break;
                    if (string2 != null) {
                        jsonGenerator.writeStartObject(string2);
                    } else {
                        jsonGenerator.writeStartObject();
                    }
                    string2 = null;
                    break;
                }
                case START_ARRAY: {
                    ++n2;
                    if (bl7) {
                        bl6 = true;
                        bl7 = false;
                    }
                    if (jsonGenerator == null) break;
                    if (string2 != null) {
                        jsonGenerator.writeStartArray(string2);
                    } else {
                        jsonGenerator.writeStartArray();
                    }
                    string2 = null;
                    break;
                }
                case END_ARRAY: {
                    --n2;
                    if (jsonGenerator == null) break;
                    jsonGenerator.writeEnd();
                    break;
                }
                case END_OBJECT: {
                    --n;
                    if (n2 == -1) {
                        if (!(bl6 || n != -1 && n3 <= 0)) {
                            if (this.newKey != null && !bl4) {
                                if (jsonGenerator != null) {
                                    int n4;
                                    for (n4 = n3; n4 < this.keySteps.length - 1; ++n4) {
                                        jsonGenerator.writeStartObject(this.keySteps[n4]);
                                    }
                                    this.addKey(jsonGenerator, this.keySteps[this.keySteps.length - 1], this.newKey);
                                    for (n4 = n3; n4 < this.keySteps.length - 1; ++n4) {
                                        jsonGenerator.writeEnd();
                                    }
                                    bl3 = true;
                                    bl4 = true;
                                }
                                string = this.newKey;
                            }
                            bl6 = true;
                        }
                        if (n3 > 0) {
                            --n3;
                        }
                    }
                    if (jsonGenerator == null) break;
                    jsonGenerator.writeEnd();
                    break;
                }
                case KEY_NAME: {
                    string2 = jsonParser.getString();
                    if (n2 != -1 || n != n3 || !string2.equals(this.keySteps[n3])) break;
                    if (bl6) {
                        throw this.makeException(Message.EX_KEY_DUPLICATE_STEP, string2);
                    }
                    if (++n3 == this.keySteps.length) {
                        event = jsonParser.next();
                        BigDecimal bigDecimal = null;
                        switch (event) {
                            case VALUE_STRING: {
                                string = jsonParser.getString();
                                if (!this.mustMatch || this.newKey == null || string.equals(this.newKey)) break;
                                throw this.makeException(Message.EX_KEY_MISMATCH, new Object[0]);
                            }
                            case VALUE_NUMBER: {
                                bigDecimal = jsonParser.getBigDecimal();
                                if (this.mustMatch && this.newKey != null && !this.checkNumericKey(this.newKey, bigDecimal)) {
                                    throw this.makeException(Message.EX_KEY_MISMATCH, new Object[0]);
                                }
                                string = DocumentCodec.bigDecimalToKey(bigDecimal);
                                break;
                            }
                            default: {
                                if (!this.needViable && (!this.mustMatch || this.newKey == null)) break;
                                throw this.makeException(Message.EX_KEY_MISMATCH, new Object[0]);
                            }
                        }
                        if (jsonGenerator != null) {
                            if (!this.removeKey) {
                                jsonGenerator.writeKey(string2);
                                this.writeCurrentPrimitive(jsonGenerator, jsonParser, event);
                                bl4 = true;
                                string2 = null;
                            } else if (this.newKey != null && !bl3) {
                                this.addKey(jsonGenerator, string2, this.newKey);
                                bl3 = true;
                                bl4 = true;
                                string2 = null;
                            }
                        }
                        --n3;
                        bl6 = true;
                        continue block11;
                    }
                    bl7 = true;
                    break;
                }
                default: {
                    if (bl7) {
                        bl6 = true;
                        bl7 = false;
                    }
                    if (jsonGenerator == null) break;
                    if (string2 != null) {
                        jsonGenerator.writeKey(string2);
                        this.writeCurrentPrimitive(jsonGenerator, jsonParser, event);
                    } else {
                        this.writeCurrentPrimitive(jsonGenerator, jsonParser, event);
                    }
                    string2 = null;
                }
            }
            if (!bl6 || !bl) continue;
            break;
        }
        if (!(bl || n == -1 && n2 == -1)) {
            throw this.makeException(Message.EX_DOCUMENT_NOT_CLOSED, new Object[0]);
        }
        return new Pair<Object, Boolean>(string, new Boolean(bl3));
    }

    private void writeCurrentPrimitive(JsonGenerator jsonGenerator, JsonParser jsonParser, JsonParser.Event event) {
        block8: {
            block7: {
                if (jsonGenerator instanceof JsonpGeneratorWrapper && jsonParser instanceof JsonpParserWrapper) break block7;
                switch (event) {
                    case VALUE_FALSE: {
                        jsonGenerator.write(false);
                        break block8;
                    }
                    case VALUE_TRUE: {
                        jsonGenerator.write(true);
                        break block8;
                    }
                    case VALUE_NULL: {
                        jsonGenerator.writeNull();
                        break block8;
                    }
                    case VALUE_NUMBER: {
                        jsonGenerator.write(jsonParser.getBigDecimal());
                        break block8;
                    }
                    case VALUE_STRING: {
                        jsonGenerator.write(jsonParser.getString());
                        break block8;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            JsonpGeneratorWrapper jsonpGeneratorWrapper = (JsonpGeneratorWrapper)jsonGenerator;
            JsonpParserWrapper jsonpParserWrapper = (JsonpParserWrapper)jsonParser;
            OracleJsonGenerator oracleJsonGenerator = jsonpGeneratorWrapper.getWrapped();
            OracleJsonParser oracleJsonParser = jsonpParserWrapper.getWrapped();
            oracleJsonGenerator.write(oracleJsonParser.getValue());
        }
    }
}

