/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal.download;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.transfer.DownloadConfiguration;
import com.oracle.bmc.objectstorage.transfer.internal.download.DownloadExecution;
import com.oracle.bmc.retrier.DefaultRetryCondition;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleRetry
implements DownloadExecution {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRetry.class);
    final Duration maximumBackoff;
    final long maxRetries;
    final AtomicLong currentBackoffMillis;
    final AtomicLong currentRetries;
    static final DefaultRetryCondition defaultRetryCondition = new DefaultRetryCondition();

    private SimpleRetry(Duration initialBackoff, Duration maximumBackoff, int maxRetries) {
        this.maximumBackoff = maximumBackoff;
        this.maxRetries = maxRetries;
        this.currentBackoffMillis = new AtomicLong(initialBackoff.toMillis());
        this.currentRetries = new AtomicLong(0L);
    }

    static SimpleRetry simpleRetryFromConfig(DownloadConfiguration config) {
        return new SimpleRetry(config.getInitialBackoff(), config.getMaxBackoff(), config.getMaxRetries());
    }

    @Override
    public boolean shouldRetryOn(Throwable t) {
        if (!SimpleRetry.isRetryableError(t)) {
            LOG.debug("Non-retryable exception", t);
            return false;
        }
        if (this.currentRetries.get() >= this.maxRetries || this.currentRetries.getAndIncrement() >= this.maxRetries) {
            LOG.error("Too many retries ({}/{})", new Object[]{this.currentRetries.get(), this.maxRetries, t});
            return false;
        }
        long oldBackoff = this.currentBackoffMillis.get();
        try {
            long sleepTime = ThreadLocalRandom.current().nextLong(0L, oldBackoff);
            LOG.info("Retrying request. Sleeping for {}ms before retry", (Object)sleepTime, (Object)t);
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        long newBackoff = Math.min(oldBackoff * 2L, this.maximumBackoff.toMillis());
        this.currentBackoffMillis.compareAndSet(oldBackoff, newBackoff);
        return true;
    }

    private static boolean isRetryableError(Throwable t) {
        return SimpleRetry.shouldBeRetriedPerDefault(t) || SimpleRetry.isIOException(t);
    }

    private static boolean shouldBeRetriedPerDefault(Throwable t) {
        if (t instanceof BmcException) {
            BmcException e = (BmcException)t;
            return defaultRetryCondition.shouldBeRetried(e);
        }
        return false;
    }

    private static boolean isIOException(Throwable t) {
        return t instanceof IOException;
    }
}

