/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.internal.ObjectStorageUtils;
import com.oracle.bmc.objectstorage.model.ChecksumAlgorithm;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.transfer.MultipartManifest;
import com.oracle.bmc.objectstorage.transfer.MultipartObjectAssembler;
import com.oracle.bmc.objectstorage.transfer.ProgressReporter;
import com.oracle.bmc.objectstorage.transfer.ProgressTrackerFactory;
import com.oracle.bmc.objectstorage.transfer.ProgressTrackingInputStreamFactory;
import com.oracle.bmc.objectstorage.transfer.UploadConfiguration;
import com.oracle.bmc.objectstorage.transfer.internal.ChecksumUtils;
import com.oracle.bmc.objectstorage.transfer.internal.MultipartUtils;
import com.oracle.bmc.objectstorage.transfer.internal.StreamChunkCreator;
import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(UploadManager.class);
    private static final int DEFAULT_NUM_MULTIPART_THREADS_PER_REQUEST = 3;
    private static final String UPLOAD_MANAGER_DEBUG_INFORMATION_LOG = String.format("\nClient Version: %s, OS Version: %s\nSee https://docs.oracle.com/iaas/Content/API/Concepts/sdk_troubleshooting.htm for common issues and steps to resolve them.\nIf you need to contact support, or file a GitHub issue, please include this full error message.", ClientRuntime.getRuntime().getClientInfo(), System.getProperty("os.version"));
    private static final RetryCondition RETRY_CONDITION = new DefaultRetryCondition(){

        public boolean shouldBeRetried(@Nonnull BmcException e) {
            if (e == null) {
                throw new NullPointerException("e is marked non-null but is null");
            }
            return super.shouldBeRetried(e) || e.getStatusCode() == -1 || e.getStatusCode() == 409 && "ConcurrentObjectUpdate".equals(e.getServiceCode());
        }
    };
    static final RetryConfiguration RETRY_CONFIGURATION = RetryConfiguration.builder().terminationStrategy((TerminationStrategy)new MaxAttemptsTerminationStrategy(5)).delayStrategy((DelayStrategy)new ExponentialBackoffDelayStrategy(100L)).retryCondition(exception -> RETRY_CONDITION.shouldBeRetried(exception)).build();
    private final ObjectStorage objectStorage;
    private final UploadConfiguration uploadConfiguration;

    public UploadResponse upload(UploadRequest uploadDetails) {
        if (MultipartUtils.shouldUseMultipart(this.uploadConfiguration, uploadDetails.putObjectRequest.getContentLength())) {
            return this.multipartUpload(uploadDetails);
        }
        return this.singleUpload(uploadDetails, uploadDetails.putObjectRequest.getContentLength());
    }

    private UploadResponse singleUpload(UploadRequest uploadRequest, long contentLength) {
        ProgressTrackerFactory progressTrackerFactory = ProgressTrackerFactory.createSingleUploadProgressTrackerFactory(uploadRequest.progressReporter, contentLength);
        PutObjectRequest putObjectRequest = uploadRequest.putObjectRequest;
        ChecksumAlgorithm algorithm = this.uploadConfiguration.getAdditionalChecksumAlgorithm();
        ChecksumAlgorithm enforceAlgoChecksum = this.uploadConfiguration.getEnforceAdditionalChecksumBeforeUpload();
        if (MultipartUtils.shouldCalculateMd5(this.uploadConfiguration, putObjectRequest)) {
            ChecksumUtils.MD5Calculation md5Calculation = ChecksumUtils.calculateMd5(putObjectRequest.getPutObjectBody(), putObjectRequest.getContentLength());
            putObjectRequest = PutObjectRequest.builder().copy(putObjectRequest).contentMD5(md5Calculation.getMd5()).putObjectBody(ProgressTrackingInputStreamFactory.create(md5Calculation.getStreamToUse(), progressTrackerFactory.getProgressTracker())).build();
        } else {
            putObjectRequest = MultipartUtils.shouldCalculateAdditionalChecksum(this.uploadConfiguration, putObjectRequest) ? this.updateRequestWithChecksum(putObjectRequest, enforceAlgoChecksum, progressTrackerFactory) : (MultipartUtils.shouldSetAdditionalChecksum(this.uploadConfiguration, putObjectRequest) ? PutObjectRequest.builder().copy(putObjectRequest).opcChecksumAlgorithm(algorithm).putObjectBody(ProgressTrackingInputStreamFactory.create(putObjectRequest.getPutObjectBody(), progressTrackerFactory.getProgressTracker())).build() : PutObjectRequest.builder().copy(putObjectRequest).putObjectBody(ProgressTrackingInputStreamFactory.create(putObjectRequest.getPutObjectBody(), progressTrackerFactory.getProgressTracker())).build());
        }
        putObjectRequest.setRetryConfiguration(UploadManager.getRetryToUse(putObjectRequest.getRetryConfiguration()));
        PutObjectResponse response = this.objectStorage.putObject(putObjectRequest);
        return this.buildUploadResponse((BmcResponse)response, algorithm, enforceAlgoChecksum, putObjectRequest.getOpcChecksumAlgorithm(), false);
    }

    private UploadResponse multipartUpload(UploadRequest uploadRequest) {
        boolean shutdownExecutor;
        ExecutorService executorServiceToUse;
        PutObjectRequest request = uploadRequest.putObjectRequest;
        ProgressTrackerFactory progressTrackerFactory = ProgressTrackerFactory.createMultiPartUploadProgressTrackerFactory(uploadRequest.progressReporter, request.getContentLength());
        long sizePerPart = MultipartUtils.calculatePartSize(this.uploadConfiguration, request.getContentLength());
        StreamChunkCreator chunkCreator = new StreamChunkCreator(request.getPutObjectBody(), request.getContentLength(), sizePerPart);
        ChecksumAlgorithm algorithm = this.uploadConfiguration.getAdditionalChecksumAlgorithm();
        ChecksumAlgorithm enforceAlgoChecksum = this.uploadConfiguration.getEnforceAdditionalChecksumBeforeMultipartUpload();
        if (this.uploadConfiguration.isAllowParallelUploads() && chunkCreator.supportsParallelReads()) {
            if (uploadRequest.parallelUploadExecutorService != null) {
                executorServiceToUse = uploadRequest.parallelUploadExecutorService;
                shutdownExecutor = false;
            } else {
                executorServiceToUse = UploadManager.buildDefaultParallelExecutor();
                shutdownExecutor = true;
            }
        } else {
            executorServiceToUse = Executors.newSingleThreadExecutor();
            shutdownExecutor = true;
        }
        MultipartObjectAssembler assembler = this.createAssembler(request, uploadRequest, executorServiceToUse);
        MultipartManifest manifest = null;
        try {
            manifest = assembler.newRequest(request.getContentType(), request.getContentLanguage(), request.getContentEncoding(), request.getOpcMeta());
            int partCount = 0;
            while (chunkCreator.hasMore()) {
                LOG.trace("Creating part {}", (Object)(++partCount));
                StreamChunkCreator.SubRangeInputStream chunk = chunkCreator.next();
                if (this.uploadConfiguration.isEnforceMd5BeforeMultipartUpload()) {
                    ChecksumUtils.MD5Calculation md5Calculation = ChecksumUtils.calculateMd5(chunk, chunk.length());
                    assembler.addPart(ProgressTrackingInputStreamFactory.create(md5Calculation.getStreamToUse(), progressTrackerFactory.getProgressTracker()), chunk.length(), md5Calculation.getMd5());
                    continue;
                }
                if (this.uploadConfiguration.getEnforceAdditionalChecksumBeforeMultipartUpload() != null) {
                    this.addPartWithChecksum(assembler, chunk, enforceAlgoChecksum, progressTrackerFactory);
                    continue;
                }
                if (MultipartUtils.shouldSetAdditionalChecksum(this.uploadConfiguration, request)) {
                    assembler.addPart(ProgressTrackingInputStreamFactory.create(chunk, progressTrackerFactory.getProgressTracker()), chunk.length(), null, algorithm.getValue());
                    continue;
                }
                if (request.getOpcChecksumAlgorithm() != null) {
                    assembler.addPart(ProgressTrackingInputStreamFactory.create(chunk, progressTrackerFactory.getProgressTracker()), chunk.length(), null, request.getOpcChecksumAlgorithm().getValue());
                    continue;
                }
                assembler.addPart(ProgressTrackingInputStreamFactory.create(chunk, progressTrackerFactory.getProgressTracker()), chunk.length(), null);
            }
            LOG.debug("Created {} parts", (Object)partCount);
            CommitMultipartUploadResponse response = assembler.commit();
            UploadResponse uploadResponse = this.buildUploadResponse((BmcResponse)response, algorithm, enforceAlgoChecksum, request.getOpcChecksumAlgorithm(), true);
            return uploadResponse;
        }
        catch (Exception e) {
            if (manifest != null) {
                LOG.error("Failed to upload object using multi-part uploads. Failed part numbers = '{}'. Successful parts = '{}'. {}", new Object[]{manifest.listFailedParts(), manifest.listCompletedParts(), UPLOAD_MANAGER_DEBUG_INFORMATION_LOG});
                if (this.uploadConfiguration.isDisableAutoAbort()) {
                    LOG.info("Not aborting failed multipart upload {} per configuration, client must manually abort it", (Object)manifest.getUploadId());
                } else {
                    try {
                        assembler.abort();
                    }
                    catch (Exception e2) {
                        LOG.warn("Failed to abort multipart upload {} after failure to upload object. {}", new Object[]{manifest.getUploadId(), UPLOAD_MANAGER_DEBUG_INFORMATION_LOG, e2});
                    }
                }
            }
            if (e instanceof BmcException) {
                throw e;
            }
            throw new BmcException(false, "Failed to upload object using multi-part uploads", (Throwable)e, null);
        }
        finally {
            StreamUtils.closeQuietly((InputStream)uploadRequest.putObjectRequest.getPutObjectBody());
            if (shutdownExecutor) {
                executorServiceToUse.shutdownNow();
            }
        }
    }

    private UploadResponse buildUploadResponse(BmcResponse response, ChecksumAlgorithm algorithm, ChecksumAlgorithm enforceAlgoChecksum, ChecksumAlgorithm requestAlgorithm, boolean isMultipart) {
        String responseChecksum;
        ChecksumAlgorithm checksumAlgorithm;
        UploadResponse.Builder responseBuilder = new UploadResponse.Builder();
        if (response instanceof PutObjectResponse) {
            PutObjectResponse putObjectResponse = (PutObjectResponse)response;
            responseBuilder.eTag(putObjectResponse.getETag()).opcRequestId(putObjectResponse.getOpcRequestId()).opcClientRequestId(putObjectResponse.getOpcClientRequestId()).contentMd5(putObjectResponse.getOpcContentMd5());
        } else if (response instanceof CommitMultipartUploadResponse) {
            CommitMultipartUploadResponse commitResponse = (CommitMultipartUploadResponse)response;
            responseBuilder.eTag(commitResponse.getETag()).opcRequestId(commitResponse.getOpcRequestId()).opcClientRequestId(commitResponse.getOpcClientRequestId()).multipartMd5(commitResponse.getOpcMultipartMd5());
        } else {
            throw new IllegalArgumentException("Unsupported response type: " + response.getClass().getName());
        }
        ChecksumAlgorithm checksumAlgorithm2 = algorithm != null ? algorithm : (checksumAlgorithm = enforceAlgoChecksum != null ? enforceAlgoChecksum : requestAlgorithm);
        if (checksumAlgorithm != null && (responseChecksum = ChecksumUtils.getResponseChecksum(response, checksumAlgorithm, isMultipart)) != null) {
            switch (checksumAlgorithm) {
                case Crc32C: {
                    responseBuilder.contentCrc32c(responseChecksum);
                    break;
                }
                case Sha256: {
                    if (isMultipart) {
                        responseBuilder.multipartSha256(responseChecksum);
                        break;
                    }
                    responseBuilder.contentSha256(responseChecksum);
                    break;
                }
                case Sha384: {
                    if (isMultipart) {
                        responseBuilder.multipartSha384(responseChecksum);
                        break;
                    }
                    responseBuilder.contentSha384(responseChecksum);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported checksum algorithm: " + checksumAlgorithm);
                }
            }
        }
        return responseBuilder.build();
    }

    private PutObjectRequest updateRequestWithChecksum(PutObjectRequest putObjectRequest, ChecksumAlgorithm algorithm, ProgressTrackerFactory progressTrackerFactory) {
        InputStream streamToUse;
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().copy(putObjectRequest).opcChecksumAlgorithm(algorithm);
        switch (algorithm) {
            case Crc32C: {
                ChecksumUtils.CRC32CCalculation crc32CCalculation = ChecksumUtils.calculateCrc32c(putObjectRequest.getPutObjectBody(), putObjectRequest.getContentLength());
                streamToUse = crc32CCalculation.getStreamToUse();
                String checksum = crc32CCalculation.getCrc32c();
                requestBuilder.opcContentCrc32c(checksum);
                break;
            }
            case Sha256: {
                ChecksumUtils.SHA256Calculation sha256Calculation = ChecksumUtils.calculateSha256(putObjectRequest.getPutObjectBody(), putObjectRequest.getContentLength());
                streamToUse = sha256Calculation.getStreamToUse();
                String checksum = sha256Calculation.getSha256();
                requestBuilder.opcContentSha256(checksum);
                break;
            }
            case Sha384: {
                ChecksumUtils.SHA384Calculation sha384Calculation = ChecksumUtils.calculateSha384(putObjectRequest.getPutObjectBody(), putObjectRequest.getContentLength());
                streamToUse = sha384Calculation.getStreamToUse();
                String checksum = sha384Calculation.getSha384();
                requestBuilder.opcContentSha384(checksum);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported checksum algorithm: " + algorithm);
            }
        }
        return requestBuilder.putObjectBody(ProgressTrackingInputStreamFactory.create(streamToUse, progressTrackerFactory.getProgressTracker())).build();
    }

    private void addPartWithChecksum(MultipartObjectAssembler assembler, StreamChunkCreator.SubRangeInputStream chunk, ChecksumAlgorithm algorithm, ProgressTrackerFactory progressTrackerFactory) {
        switch (algorithm) {
            case Crc32C: {
                ChecksumUtils.CRC32CCalculation crc32CCalculation = ChecksumUtils.calculateCrc32c(chunk, chunk.length());
                InputStream streamToUse = crc32CCalculation.getStreamToUse();
                String checksum = crc32CCalculation.getCrc32c();
                assembler.addPart(ProgressTrackingInputStreamFactory.create(streamToUse, progressTrackerFactory.getProgressTracker()), chunk.length(), checksum, algorithm.getValue());
                break;
            }
            case Sha256: {
                ChecksumUtils.SHA256Calculation sha256Calculation = ChecksumUtils.calculateSha256(chunk, chunk.length());
                InputStream streamToUse = sha256Calculation.getStreamToUse();
                String checksum = sha256Calculation.getSha256();
                assembler.addPart(ProgressTrackingInputStreamFactory.create(streamToUse, progressTrackerFactory.getProgressTracker()), chunk.length(), checksum, algorithm.getValue());
                break;
            }
            case Sha384: {
                ChecksumUtils.SHA384Calculation sha384Calculation = ChecksumUtils.calculateSha384(chunk, chunk.length());
                InputStream streamToUse = sha384Calculation.getStreamToUse();
                String checksum = sha384Calculation.getSha384();
                assembler.addPart(ProgressTrackingInputStreamFactory.create(streamToUse, progressTrackerFactory.getProgressTracker()), chunk.length(), checksum, algorithm.getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported checksum algorithm: " + algorithm);
            }
        }
    }

    private static RetryConfiguration getRetryToUse(RetryConfiguration ... configs) {
        for (RetryConfiguration cfg : configs) {
            if (cfg == null) continue;
            return cfg;
        }
        return RETRY_CONFIGURATION;
    }

    @VisibleForTesting
    protected MultipartObjectAssembler createAssembler(PutObjectRequest request, UploadRequest uploadRequest, ExecutorService executorService) {
        RetryConfiguration retryToUse = UploadManager.getRetryToUse(uploadRequest.putObjectRequest.getRetryConfiguration(), request.getRetryConfiguration());
        MultipartObjectAssembler.MultipartObjectAssemblerBuilder assemblerBuilder = MultipartObjectAssembler.builder().allowOverwrite(uploadRequest.allowOverwrite).bucketName(request.getBucketName()).executorService(executorService).invocationCallback(request.getInvocationCallback()).namespaceName(request.getNamespaceName()).objectName(request.getObjectName()).storageTier(request.getStorageTier()).opcClientRequestId(request.getOpcClientRequestId()).service(this.objectStorage).cacheControl(request.getCacheControl()).contentDisposition(request.getContentDisposition()).retryConfiguration(retryToUse);
        if (this.uploadConfiguration.getAdditionalChecksumAlgorithm() != null) {
            assemblerBuilder.additionalChecksumAlgorithm(this.uploadConfiguration.getAdditionalChecksumAlgorithm());
        } else if (request.getOpcChecksumAlgorithm() != null) {
            assemblerBuilder.additionalChecksumAlgorithm(request.getOpcChecksumAlgorithm());
        }
        return assemblerBuilder.build();
    }

    private static ExecutorService buildDefaultParallelExecutor() {
        return Executors.newFixedThreadPool(3, (ThreadFactory)ClientThreadFactory.builder().nameFormat("multipart-upload-" + System.currentTimeMillis() + "-%d").isDaemon(true).build());
    }

    @ConstructorProperties(value={"objectStorage", "uploadConfiguration"})
    public UploadManager(ObjectStorage objectStorage, UploadConfiguration uploadConfiguration) {
        this.objectStorage = objectStorage;
        this.uploadConfiguration = uploadConfiguration;
    }

    public static class UploadRequest {
        private final PutObjectRequest putObjectRequest;
        private final ExecutorService parallelUploadExecutorService;
        private final boolean allowOverwrite;
        private final ProgressReporter progressReporter;

        public static UploadRequestBuilder builder(InputStream stream, long contentLength) {
            return new UploadRequestBuilder(stream, contentLength);
        }

        public static UploadRequestBuilder builder(File file) {
            InputStream stream = StreamUtils.toInputStream((File)file);
            try {
                return new UploadRequestBuilder(stream, file.length());
            }
            catch (Exception e) {
                StreamUtils.closeQuietly((InputStream)stream);
                throw e;
            }
        }

        @ConstructorProperties(value={"putObjectRequest", "parallelUploadExecutorService", "allowOverwrite", "progressReporter"})
        public UploadRequest(PutObjectRequest putObjectRequest, ExecutorService parallelUploadExecutorService, boolean allowOverwrite, ProgressReporter progressReporter) {
            this.putObjectRequest = putObjectRequest;
            this.parallelUploadExecutorService = parallelUploadExecutorService;
            this.allowOverwrite = allowOverwrite;
            this.progressReporter = progressReporter;
        }

        public static class UploadRequestBuilder {
            private final InputStream inputStream;
            private final long contentLength;
            private boolean allowOverwrite = true;
            private ExecutorService parallelUploadExecutorService;
            private ProgressReporter progressReporter;

            public UploadRequestBuilder allowOverwrite(boolean allowOverwrite) {
                this.allowOverwrite = allowOverwrite;
                return this;
            }

            public UploadRequestBuilder parallelUploadExecutorService(ExecutorService parallelUploadExecutorService) {
                this.parallelUploadExecutorService = parallelUploadExecutorService;
                return this;
            }

            public UploadRequestBuilder progressReporter(ProgressReporter progressReporter) {
                this.progressReporter = progressReporter;
                return this;
            }

            public UploadRequest build(PutObjectRequest request) {
                String ifNoneMatch = ObjectStorageUtils.getIfNoneMatchHeader(this.allowOverwrite);
                return new UploadRequest(PutObjectRequest.builder().copy(request).putObjectBody(this.inputStream).contentLength(Long.valueOf(this.contentLength)).ifNoneMatch(ifNoneMatch).build(), this.parallelUploadExecutorService, this.allowOverwrite, this.progressReporter);
            }

            @ConstructorProperties(value={"inputStream", "contentLength"})
            public UploadRequestBuilder(InputStream inputStream, long contentLength) {
                this.inputStream = inputStream;
                this.contentLength = contentLength;
            }
        }
    }

    public static class UploadResponse {
        private final String eTag;
        private final String contentMd5;
        private final String multipartMd5;
        private final String opcRequestId;
        private final String opcClientRequestId;
        private final String contentCrc32c;
        private final String contentSha256;
        private final String contentSha384;
        private final String multipartSha256;
        private final String multipartSha384;

        @ConstructorProperties(value={"eTag", "contentMd5", "multipartMd5", "opcRequestId", "opcClientRequestId"})
        public UploadResponse(String eTag, String contentMd5, String multipartMd5, String opcRequestId, String opcClientRequestId) {
            this(eTag, contentMd5, multipartMd5, opcRequestId, opcClientRequestId, null, null, null, null, null);
        }

        @ConstructorProperties(value={"eTag", "contentMd5", "multipartMd5", "opcRequestId", "opcClientRequestId", "contentCrc32c", "contentSha256", "contentSha384", "multipartSha256", "multipartSha384"})
        public UploadResponse(String eTag, String contentMd5, String multipartMd5, String opcRequestId, String opcClientRequestId, String contentCrc32c, String contentSha256, String contentSha384, String multipartSha256, String multipartSha384) {
            this.eTag = eTag;
            this.contentMd5 = contentMd5;
            this.multipartMd5 = multipartMd5;
            this.opcRequestId = opcRequestId;
            this.opcClientRequestId = opcClientRequestId;
            this.contentCrc32c = contentCrc32c;
            this.contentSha256 = contentSha256;
            this.contentSha384 = contentSha384;
            this.multipartSha256 = multipartSha256;
            this.multipartSha384 = multipartSha384;
        }

        private UploadResponse(Builder builder) {
            this.eTag = builder.eTag;
            this.contentMd5 = builder.contentMd5;
            this.multipartMd5 = builder.multipartMd5;
            this.opcRequestId = builder.opcRequestId;
            this.opcClientRequestId = builder.opcClientRequestId;
            this.contentCrc32c = builder.contentCrc32c;
            this.contentSha256 = builder.contentSha256;
            this.contentSha384 = builder.contentSha384;
            this.multipartSha256 = builder.multipartSha256;
            this.multipartSha384 = builder.multipartSha384;
        }

        public String getETag() {
            return this.eTag;
        }

        public String getContentMd5() {
            return this.contentMd5;
        }

        public String getMultipartMd5() {
            return this.multipartMd5;
        }

        public String getOpcRequestId() {
            return this.opcRequestId;
        }

        public String getOpcClientRequestId() {
            return this.opcClientRequestId;
        }

        public String getContentCrc32c() {
            return this.contentCrc32c;
        }

        public String getContentSha256() {
            return this.contentSha256;
        }

        public String getContentSha384() {
            return this.contentSha384;
        }

        public String getMultipartSha256() {
            return this.multipartSha256;
        }

        public String getMultipartSha384() {
            return this.multipartSha384;
        }

        public String toString() {
            return "UploadManager.UploadResponse(eTag=" + this.getETag() + ", contentMd5=" + this.getContentMd5() + ", multipartMd5=" + this.getMultipartMd5() + ", opcRequestId=" + this.getOpcRequestId() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ", contentCrc32c=" + this.getContentCrc32c() + ", contentSha256=" + this.getContentSha256() + ", contentSha384=" + this.getContentSha384() + ", multipartSha256=" + this.getMultipartSha256() + ", multipartSha384=" + this.getMultipartSha384() + ")";
        }

        public static class Builder {
            private String eTag;
            private String contentMd5;
            private String multipartMd5;
            private String opcRequestId;
            private String opcClientRequestId;
            private String contentCrc32c;
            private String contentSha256;
            private String contentSha384;
            private String multipartSha256;
            private String multipartSha384;

            public Builder eTag(String eTag) {
                this.eTag = eTag;
                return this;
            }

            public Builder contentMd5(String contentMd5) {
                this.contentMd5 = contentMd5;
                return this;
            }

            public Builder multipartMd5(String multipartMd5) {
                this.multipartMd5 = multipartMd5;
                return this;
            }

            public Builder opcRequestId(String opcRequestId) {
                this.opcRequestId = opcRequestId;
                return this;
            }

            public Builder opcClientRequestId(String opcClientRequestId) {
                this.opcClientRequestId = opcClientRequestId;
                return this;
            }

            public Builder contentCrc32c(String contentCrc32c) {
                this.contentCrc32c = contentCrc32c;
                return this;
            }

            public Builder contentSha256(String contentSha256) {
                this.contentSha256 = contentSha256;
                return this;
            }

            public Builder contentSha384(String contentSha384) {
                this.contentSha384 = contentSha384;
                return this;
            }

            public Builder multipartSha256(String multipartSha256) {
                this.multipartSha256 = multipartSha256;
                return this;
            }

            public Builder multipartSha384(String multipartSha384) {
                this.multipartSha384 = multipartSha384;
                return this;
            }

            public UploadResponse build() {
                return new UploadResponse(this);
            }
        }
    }
}

