/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http.rest;

import java.io.IOException;
import java.util.Objects;
import oracle.dbtools.http.AbstractResponseHandler;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionCreator;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.http.auth.Authentication;
import oracle.dbtools.http.auth.AuthenticationEngine;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import oracle.dbtools.http.auth.basic.HeadlessBasicAuthenticationEngine;
import oracle.dbtools.http.rest.ISimpleRestObjectClient;
import oracle.dbtools.http.rest.SimpleRestObjectException;
import oracle.dbtools.http.rest.SimpleRestObjectHandler;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;

public class SimpleRestObjectClient
implements ISimpleRestObjectClient {
    public static final String CANNONICAL_OBJECT_CLASS = "X-CannonicalObjectClass";
    private ISimpleRestObjectClient.ConnectionInfo m_sessionInfo;
    private Session httpSession;

    @Override
    public void connect(ISimpleRestObjectClient.ConnectionInfo info) throws IOException {
        if (this.httpSession != null && this.httpSession.isOpen()) {
            if (Objects.equals(info, this.m_sessionInfo)) {
                return;
            }
            throw new IOException("Cannot change session info for connected client");
        }
        this.m_sessionInfo = info;
        SimpleRestClient client = new SimpleRestClient(new SimpleRestSessionType(info.getClientID(), info.getClientSecret()));
        SessionCreator sessionCreator = SessionCreator.createSessionCreator(client);
        SessionInfo sessionInfo = new SessionInfo("SimpleRestObjectAccessor", info.getServerRoot(), info.getServiceRoot(), info.getUsername(), info.getPassword());
        try {
            this.httpSession = sessionCreator.createSession(sessionInfo);
        }
        catch (Throwable t) {
            this.throwIOException(t);
        }
    }

    @Override
    public void close() {
        if (this.httpSession != null) {
            this.httpSession.close();
        }
    }

    @Override
    public <T> T get(String path, T object) throws IOException {
        T result = null;
        try {
            SimpleRestObjectHandler handler = new SimpleRestObjectHandler(object.getClass());
            result = (T)this.httpSession.executeQuery(path, handler);
        }
        catch (Throwable t) {
            this.throwIOException(t);
        }
        return result;
    }

    @Override
    public <T> T post(String path, T object) throws IOException {
        T result = null;
        try {
            SimpleRestObjectHandler handler = new SimpleRestObjectHandler(object.getClass());
            HttpPost post = this.httpSession.createPost(path);
            post.setEntity(handler.asEntity(object));
            result = (T)this.httpSession.executeRequest((HttpUriRequest)post, handler);
        }
        catch (Throwable t) {
            this.throwIOException(t);
        }
        return result;
    }

    @Override
    public <T> T put(String path, T object) throws IOException {
        T result = null;
        try {
            SimpleRestObjectHandler handler = new SimpleRestObjectHandler(object.getClass());
            HttpPut put = this.httpSession.createPut(path);
            put.setEntity(handler.asEntity(object));
            result = (T)this.httpSession.executeRequest((HttpUriRequest)put, handler);
        }
        catch (Throwable t) {
            this.throwIOException(t);
        }
        return result;
    }

    @Override
    public boolean delete(String path) throws IOException {
        boolean result = false;
        try {
            HttpDelete delete = this.httpSession.createDelete(path);
            result = this.httpSession.executeRequest((HttpUriRequest)delete, new AbstractResponseHandler<Boolean>(){

                @Override
                protected Boolean handleSuccess(ClassicHttpResponse resp) throws ClientProtocolException, IOException {
                    return true;
                }

                @Override
                protected IOException createInternalServerError(String errorMessage, String errorText, String errorTextType) {
                    return new SimpleRestObjectException(errorMessage, errorText, errorTextType);
                }

                @Override
                protected Boolean handleError(ClassicHttpResponse resp) throws ClientProtocolException, IOException {
                    this.report500Error(resp);
                    return false;
                }
            });
        }
        catch (Throwable t) {
            this.throwIOException(t);
        }
        return result;
    }

    private void throwIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        Throwable c = t.getCause();
        if (c instanceof IOException) {
            throw (IOException)c;
        }
        throw new IOException(t);
    }

    private static class SimpleRestClient
    extends Client {
        protected SimpleRestClient(SimpleRestSessionType type) {
            super(type);
        }

        @Override
        protected String getUserAgent() {
            return "oracle.dbtools.http.rest.SimpleRestObjectClient";
        }

        @Override
        protected AuthenticationEngine createAuthenticationEngine() {
            if (((SimpleRestSessionType)this.getConnectionType()).hasSecret()) {
                return new HeadlessBasicAuthenticationEngine();
            }
            return new HeadlessBasicAuthenticationEngine(){

                @Override
                public Authentication authenticate(SessionInfo conn) throws AuthenticationFailedException {
                    Authentication auth = new Authentication();
                    return auth;
                }
            };
        }
    }

    private static class SimpleRestSessionType
    extends SessionType {
        private String m_clientId;
        private String m_clientSecret;

        public SimpleRestSessionType(String clientId, String clientSecret) {
            this.m_clientId = clientId;
            this.m_clientSecret = clientSecret;
        }

        public boolean hasSecret() {
            return this.getClientSecret() != null && !this.getClientSecret().isEmpty();
        }

        @Override
        public String getType() {
            return "SimpleRestSessionType";
        }

        @Override
        protected String getClientID() {
            return this.m_clientId;
        }

        @Override
        protected String getClientSecret() {
            return this.m_clientSecret;
        }
    }
}

