/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import java.util.function.Predicate;
import oracle.dbtools.http.AbstractResponseHandler;
import oracle.dbtools.http.JSONProtocolException;
import oracle.dbtools.http.logger.Logger;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;

public abstract class AbstractJsonHandler<V>
extends AbstractResponseHandler<V> {
    private static final Logger LOGGER = Logger.of(AbstractJsonHandler.class);
    protected static Predicate<TreeNode> IS_STRING = p -> p instanceof JrsString;
    protected static Predicate<TreeNode> IS_OBJECT = p -> p.isObject();
    private String _entityTag;

    public static JSON getObjectMapper() {
        return Holder.mapper;
    }

    public static JsonParser createParser(Reader r) throws JsonParseException, IOException {
        return Holder.factory.createParser(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final V handleSuccess(ClassicHttpResponse resp) throws ClientProtocolException, IOException {
        ContentType type = ContentType.parse((CharSequence)resp.getEntity().getContentType());
        if (!Objects.equals(ContentType.APPLICATION_JSON.getMimeType(), type.getMimeType())) {
            throw new IOException("Unexpected Content-Type: " + String.valueOf(type));
        }
        Header h = resp.getFirstHeader("ETag");
        if (h != null) {
            this._entityTag = h.getValue();
        }
        HttpEntity entity = resp.getEntity();
        try (Reader r = null;){
            Charset cs = type.getCharset();
            if (cs == null) {
                try {
                    cs = Charset.forName("UTF-8");
                }
                catch (UnsupportedCharsetException e) {
                    LOGGER.warning("Unsupported charset: UTF-8!");
                    cs = Charset.defaultCharset();
                }
            }
            r = new BufferedReader(new InputStreamReader(entity.getContent(), cs));
            V v = this.build(r);
            return v;
        }
    }

    @Override
    protected final IOException createInternalServerError(String errorMessage, String errorText, String errorTextType) {
        return new JSONProtocolException(errorMessage, errorText, errorTextType);
    }

    @Override
    protected final V handleError(ClassicHttpResponse resp) throws ClientProtocolException, IOException {
        this.report500Error(resp);
        return null;
    }

    protected abstract V build(Reader var1) throws IOException;

    protected final void throwJSONFormatException(String expectedValue, String actualValue) throws JSONProtocolException {
        throw new JSONProtocolException(expectedValue, actualValue);
    }

    protected void checkJSONElement(Object o, String propName) throws JSONProtocolException {
        if (o == null) {
            throw new JSONProtocolException(propName);
        }
    }

    protected void checkJsonNode(TreeNode node, String propName) throws JSONProtocolException {
        if (node == null || node.isMissingNode()) {
            throw new JSONProtocolException(propName);
        }
    }

    protected void checkJsonNode(TreeNode node, String propName, Predicate<TreeNode> p) throws JSONProtocolException {
        if (node == null || p.negate().test(node)) {
            throw new JSONProtocolException(propName);
        }
    }

    protected String getAsString(TreeNode node, String fieldName) throws JSONProtocolException {
        TreeNode value = node.path(fieldName);
        if (value.isMissingNode()) {
            return null;
        }
        this.checkJsonNode(value, fieldName, IS_STRING);
        return ((JrsString)value).asText();
    }

    protected final String getEntityTag() {
        return this._entityTag;
    }

    private static class Holder {
        private static final JSON mapper;
        private static final JsonFactory factory;

        private Holder() {
        }

        static {
            factory = new JsonFactory();
            mapper = JSON.std.with(factory).with((TreeCodec)new JacksonJrsTreeCodec());
        }
    }
}

