/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpgradeDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpgradeDatabaseRequest
extends BmcRequest<UpgradeDatabaseDetails> {
    private String databaseId;
    private UpgradeDatabaseDetails upgradeDatabaseDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public UpgradeDatabaseDetails getUpgradeDatabaseDetails() {
        return this.upgradeDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpgradeDatabaseDetails getBody$() {
        return this.upgradeDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).upgradeDatabaseDetails(this.upgradeDatabaseDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",upgradeDatabaseDetails=").append(String.valueOf((Object)this.upgradeDatabaseDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpgradeDatabaseRequest)) {
            return false;
        }
        UpgradeDatabaseRequest other = (UpgradeDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.upgradeDatabaseDetails, (Object)other.upgradeDatabaseDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.upgradeDatabaseDetails == null ? 43 : this.upgradeDatabaseDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpgradeDatabaseRequest, UpgradeDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private UpgradeDatabaseDetails upgradeDatabaseDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder upgradeDatabaseDetails(UpgradeDatabaseDetails upgradeDatabaseDetails) {
            this.upgradeDatabaseDetails = upgradeDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpgradeDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.upgradeDatabaseDetails(o.getUpgradeDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpgradeDatabaseRequest build() {
            UpgradeDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpgradeDatabaseDetails body) {
            this.upgradeDatabaseDetails(body);
            return this;
        }

        public UpgradeDatabaseRequest buildWithoutInvocationCallback() {
            UpgradeDatabaseRequest request = new UpgradeDatabaseRequest();
            request.databaseId = this.databaseId;
            request.upgradeDatabaseDetails = this.upgradeDatabaseDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

