/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.BackupSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListBackupsRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String compartmentId;
    private Integer limit;
    private String page;
    private ShapeFamily shapeFamily;
    private String version;
    private String type;
    private BackupSummary.LifecycleState lifecycleState;
    private Date timeExpiryScheduledGreaterThanOrEqualTo;
    private Date timeExpiryScheduledLessThan;
    private String backupDestinationType;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public ShapeFamily getShapeFamily() {
        return this.shapeFamily;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public BackupSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeExpiryScheduledGreaterThanOrEqualTo() {
        return this.timeExpiryScheduledGreaterThanOrEqualTo;
    }

    public Date getTimeExpiryScheduledLessThan() {
        return this.timeExpiryScheduledLessThan;
    }

    public String getBackupDestinationType() {
        return this.backupDestinationType;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).compartmentId(this.compartmentId).limit(this.limit).page(this.page).shapeFamily(this.shapeFamily).version(this.version).type(this.type).lifecycleState(this.lifecycleState).timeExpiryScheduledGreaterThanOrEqualTo(this.timeExpiryScheduledGreaterThanOrEqualTo).timeExpiryScheduledLessThan(this.timeExpiryScheduledLessThan).backupDestinationType(this.backupDestinationType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",shapeFamily=").append(String.valueOf((Object)this.shapeFamily));
        sb.append(",version=").append(String.valueOf(this.version));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",timeExpiryScheduledGreaterThanOrEqualTo=").append(String.valueOf(this.timeExpiryScheduledGreaterThanOrEqualTo));
        sb.append(",timeExpiryScheduledLessThan=").append(String.valueOf(this.timeExpiryScheduledLessThan));
        sb.append(",backupDestinationType=").append(String.valueOf(this.backupDestinationType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBackupsRequest)) {
            return false;
        }
        ListBackupsRequest other = (ListBackupsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.shapeFamily, (Object)other.shapeFamily) && Objects.equals(this.version, other.version) && Objects.equals(this.type, other.type) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeExpiryScheduledGreaterThanOrEqualTo, other.timeExpiryScheduledGreaterThanOrEqualTo) && Objects.equals(this.timeExpiryScheduledLessThan, other.timeExpiryScheduledLessThan) && Objects.equals(this.backupDestinationType, other.backupDestinationType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.shapeFamily == null ? 43 : this.shapeFamily.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeExpiryScheduledGreaterThanOrEqualTo == null ? 43 : this.timeExpiryScheduledGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeExpiryScheduledLessThan == null ? 43 : this.timeExpiryScheduledLessThan.hashCode());
        result = result * 59 + (this.backupDestinationType == null ? 43 : this.backupDestinationType.hashCode());
        return result;
    }

    public static enum ShapeFamily implements BmcEnum
    {
        Singlenode("SINGLENODE"),
        Yoda("YODA"),
        Virtualmachine("VIRTUALMACHINE"),
        Exadata("EXADATA"),
        Exacc("EXACC"),
        ExadbXs("EXADB_XS");

        private final String value;
        private static Map<String, ShapeFamily> map;

        private ShapeFamily(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeFamily create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ShapeFamily: " + key);
        }

        static {
            map = new HashMap<String, ShapeFamily>();
            for (ShapeFamily v : ShapeFamily.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListBackupsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private ShapeFamily shapeFamily = null;
        private String version = null;
        private String type = null;
        private BackupSummary.LifecycleState lifecycleState = null;
        private Date timeExpiryScheduledGreaterThanOrEqualTo = null;
        private Date timeExpiryScheduledLessThan = null;
        private String backupDestinationType = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder shapeFamily(ShapeFamily shapeFamily) {
            this.shapeFamily = shapeFamily;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder lifecycleState(BackupSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder timeExpiryScheduledGreaterThanOrEqualTo(Date timeExpiryScheduledGreaterThanOrEqualTo) {
            this.timeExpiryScheduledGreaterThanOrEqualTo = timeExpiryScheduledGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeExpiryScheduledLessThan(Date timeExpiryScheduledLessThan) {
            this.timeExpiryScheduledLessThan = timeExpiryScheduledLessThan;
            return this;
        }

        public Builder backupDestinationType(String backupDestinationType) {
            this.backupDestinationType = backupDestinationType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBackupsRequest o) {
            this.databaseId(o.getDatabaseId());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.shapeFamily(o.getShapeFamily());
            this.version(o.getVersion());
            this.type(o.getType());
            this.lifecycleState(o.getLifecycleState());
            this.timeExpiryScheduledGreaterThanOrEqualTo(o.getTimeExpiryScheduledGreaterThanOrEqualTo());
            this.timeExpiryScheduledLessThan(o.getTimeExpiryScheduledLessThan());
            this.backupDestinationType(o.getBackupDestinationType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBackupsRequest build() {
            ListBackupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListBackupsRequest buildWithoutInvocationCallback() {
            ListBackupsRequest request = new ListBackupsRequest();
            request.databaseId = this.databaseId;
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.shapeFamily = this.shapeFamily;
            request.version = this.version;
            request.type = this.type;
            request.lifecycleState = this.lifecycleState;
            request.timeExpiryScheduledGreaterThanOrEqualTo = this.timeExpiryScheduledGreaterThanOrEqualTo;
            request.timeExpiryScheduledLessThan = this.timeExpiryScheduledLessThan;
            request.backupDestinationType = this.backupDestinationType;
            return request;
        }
    }
}

