/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExecutionWindowRequest
extends BmcRequest<Void> {
    private String executionWindowId;
    private String opcRequestId;

    public String getExecutionWindowId() {
        return this.executionWindowId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().executionWindowId(this.executionWindowId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",executionWindowId=").append(String.valueOf(this.executionWindowId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExecutionWindowRequest)) {
            return false;
        }
        GetExecutionWindowRequest other = (GetExecutionWindowRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.executionWindowId, other.executionWindowId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.executionWindowId == null ? 43 : this.executionWindowId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExecutionWindowRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String executionWindowId = null;
        private String opcRequestId = null;

        public Builder executionWindowId(String executionWindowId) {
            this.executionWindowId = executionWindowId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExecutionWindowRequest o) {
            this.executionWindowId(o.getExecutionWindowId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExecutionWindowRequest build() {
            GetExecutionWindowRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExecutionWindowRequest buildWithoutInvocationCallback() {
            GetExecutionWindowRequest request = new GetExecutionWindowRequest();
            request.executionWindowId = this.executionWindowId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

