/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.ConvertToStandaloneDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ConvertToStandaloneRequest
extends BmcRequest<ConvertToStandaloneDetails> {
    private String databaseId;
    private ConvertToStandaloneDetails convertToStandaloneDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public ConvertToStandaloneDetails getConvertToStandaloneDetails() {
        return this.convertToStandaloneDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ConvertToStandaloneDetails getBody$() {
        return this.convertToStandaloneDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).convertToStandaloneDetails(this.convertToStandaloneDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",convertToStandaloneDetails=").append(String.valueOf((Object)this.convertToStandaloneDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConvertToStandaloneRequest)) {
            return false;
        }
        ConvertToStandaloneRequest other = (ConvertToStandaloneRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.convertToStandaloneDetails, (Object)other.convertToStandaloneDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.convertToStandaloneDetails == null ? 43 : this.convertToStandaloneDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ConvertToStandaloneRequest, ConvertToStandaloneDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private ConvertToStandaloneDetails convertToStandaloneDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder convertToStandaloneDetails(ConvertToStandaloneDetails convertToStandaloneDetails) {
            this.convertToStandaloneDetails = convertToStandaloneDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ConvertToStandaloneRequest o) {
            this.databaseId(o.getDatabaseId());
            this.convertToStandaloneDetails(o.getConvertToStandaloneDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ConvertToStandaloneRequest build() {
            ConvertToStandaloneRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ConvertToStandaloneDetails body) {
            this.convertToStandaloneDetails(body);
            return this;
        }

        public ConvertToStandaloneRequest buildWithoutInvocationCallback() {
            ConvertToStandaloneRequest request = new ConvertToStandaloneRequest();
            request.databaseId = this.databaseId;
            request.convertToStandaloneDetails = this.convertToStandaloneDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

