/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateDataGuardAssociationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseAdminPassword")
    private final String databaseAdminPassword;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="transportType")
    private final TransportType transportType;
    @JsonProperty(value="isActiveDataGuardEnabled")
    private final Boolean isActiveDataGuardEnabled;

    @Deprecated
    @ConstructorProperties(value={"databaseAdminPassword", "protectionMode", "transportType", "isActiveDataGuardEnabled"})
    public UpdateDataGuardAssociationDetails(String databaseAdminPassword, ProtectionMode protectionMode, TransportType transportType, Boolean isActiveDataGuardEnabled) {
        this.databaseAdminPassword = databaseAdminPassword;
        this.protectionMode = protectionMode;
        this.transportType = transportType;
        this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDatabaseAdminPassword() {
        return this.databaseAdminPassword;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public Boolean getIsActiveDataGuardEnabled() {
        return this.isActiveDataGuardEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateDataGuardAssociationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("databaseAdminPassword=").append(String.valueOf(this.databaseAdminPassword));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", transportType=").append(String.valueOf((Object)this.transportType));
        sb.append(", isActiveDataGuardEnabled=").append(String.valueOf(this.isActiveDataGuardEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataGuardAssociationDetails)) {
            return false;
        }
        UpdateDataGuardAssociationDetails other = (UpdateDataGuardAssociationDetails)((Object)o);
        return Objects.equals(this.databaseAdminPassword, other.databaseAdminPassword) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals((Object)this.transportType, (Object)other.transportType) && Objects.equals(this.isActiveDataGuardEnabled, other.isActiveDataGuardEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseAdminPassword == null ? 43 : this.databaseAdminPassword.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.transportType == null ? 43 : this.transportType.hashCode());
        result = result * 59 + (this.isActiveDataGuardEnabled == null ? 43 : this.isActiveDataGuardEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ProtectionMode implements BmcEnum
    {
        MaximumAvailability("MAXIMUM_AVAILABILITY"),
        MaximumPerformance("MAXIMUM_PERFORMANCE"),
        MaximumProtection("MAXIMUM_PROTECTION");

        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ProtectionMode: " + key);
        }

        static {
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TransportType implements BmcEnum
    {
        Sync("SYNC"),
        Async("ASYNC"),
        Fastsync("FASTSYNC");

        private final String value;
        private static Map<String, TransportType> map;

        private TransportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TransportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TransportType: " + key);
        }

        static {
            map = new HashMap<String, TransportType>();
            for (TransportType v : TransportType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseAdminPassword")
        private String databaseAdminPassword;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="transportType")
        private TransportType transportType;
        @JsonProperty(value="isActiveDataGuardEnabled")
        private Boolean isActiveDataGuardEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseAdminPassword(String databaseAdminPassword) {
            this.databaseAdminPassword = databaseAdminPassword;
            this.__explicitlySet__.add("databaseAdminPassword");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder transportType(TransportType transportType) {
            this.transportType = transportType;
            this.__explicitlySet__.add("transportType");
            return this;
        }

        public Builder isActiveDataGuardEnabled(Boolean isActiveDataGuardEnabled) {
            this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
            this.__explicitlySet__.add("isActiveDataGuardEnabled");
            return this;
        }

        public UpdateDataGuardAssociationDetails build() {
            UpdateDataGuardAssociationDetails model = new UpdateDataGuardAssociationDetails(this.databaseAdminPassword, this.protectionMode, this.transportType, this.isActiveDataGuardEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateDataGuardAssociationDetails model) {
            if (model.wasPropertyExplicitlySet("databaseAdminPassword")) {
                this.databaseAdminPassword(model.getDatabaseAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("transportType")) {
                this.transportType(model.getTransportType());
            }
            if (model.wasPropertyExplicitlySet("isActiveDataGuardEnabled")) {
                this.isActiveDataGuardEnabled(model.getIsActiveDataGuardEnabled());
            }
            return this;
        }
    }
}

